// @Triggers(arrayOf(
//     Trigger(
//         name = "xobjectentity_remote_insert",
//         order = Trigger.Order.INSTEAD_OF,
//         on = Trigger.On.RECEIVEVIEW,
//         events = [Trigger.Event.INSERT],
//         sqlStatements = [
//             """REPLACE INTO XObjectEntity(xObjectUid, objectType, objectId, definitionType, interactionType, correctResponsePattern, objectContentEntryUid, objectStatementRefUid, xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum, xObjectLastChangedBy, xObjectLct) 
//             VALUES (NEW.xObjectUid, NEW.objectType, NEW.objectId, NEW.definitionType, NEW.interactionType, NEW.correctResponsePattern, NEW.objectContentEntryUid, NEW.objectStatementRefUid, NEW.xObjectMasterChangeSeqNum, NEW.xObjectocalChangeSeqNum, NEW.xObjectLastChangedBy, NEW.xObjectLct) 
//             /*psql ON CONFLICT (xObjectUid) DO UPDATE 
//             SET objectType = EXCLUDED.objectType, objectId = EXCLUDED.objectId, definitionType = EXCLUDED.definitionType, interactionType = EXCLUDED.interactionType, correctResponsePattern = EXCLUDED.correctResponsePattern, objectContentEntryUid = EXCLUDED.objectContentEntryUid, objectStatementRefUid = EXCLUDED.objectStatementRefUid, xObjectMasterChangeSeqNum = EXCLUDED.xObjectMasterChangeSeqNum, xObjectocalChangeSeqNum = EXCLUDED.xObjectocalChangeSeqNum, xObjectLastChangedBy = EXCLUDED.xObjectLastChangedBy, xObjectLct = EXCLUDED.xObjectLct
//             */"""
//         ]
//     )
// ))                @Query("""
//     REPLACE INTO XObjectEntityReplicate(xoePk, xoeDestination)
//      SELECT XObjectEntity.xObjectUid AS xoePk,
//             :newNodeId AS xoeDestination
//        FROM XObjectEntity
//       --notpsql 
//       WHERE XObjectEntity.xObjectLct != COALESCE(
//             (SELECT xoeVersionId
//                FROM XObjectEntityReplicate
//               WHERE xoePk = XObjectEntity.xObjectUid
//                 AND xoeDestination = :newNodeId), 0)
//       --endnotpsql            
//      /*psql ON CONFLICT(xoePk, xoeDestination) DO UPDATE
//             SET xoePending = (SELECT XObjectEntity.xObjectLct
//            FROM XObjectEntity
//           WHERE XObjectEntity.xObjectUid = EXCLUDED.xoePk ) 
//                 != XObjectEntityReplicate.xoeVersionId
//      */       
// """)
// @ReplicationRunOnNewNode
// @ReplicationCheckPendingNotificationsFor([XObjectEntity::class])
// abstract suspend fun replicateOnNewNode(@NewNodeIdParam newNodeId: Long)
// @Query("""
// REPLACE INTO XObjectEntityReplicate(xoePk, xoeDestination)
//  SELECT XObjectEntity.xObjectUid AS xoeUid,
//         UserSession.usClientNodeId AS xoeDestination
//    FROM ChangeLog
//         JOIN XObjectEntity
//             ON ChangeLog.chTableId = ${XObjectEntity.TABLE_ID}
//                AND ChangeLog.chEntityPk = XObjectEntity.xObjectUid
//         JOIN UserSession ON UserSession.usStatus = ${UserSession.STATUS_ACTIVE}
//   WHERE UserSession.usClientNodeId != (
//         SELECT nodeClientId 
//           FROM SyncNode
//          LIMIT 1)
//     --notpsql     
//     AND XObjectEntity.xObjectLct != COALESCE(
//         (SELECT xoeVersionId
//            FROM XObjectEntityReplicate
//           WHERE xoePk = XObjectEntity.xObjectUid
//             AND xoeDestination = UserSession.usClientNodeId), 0)
//     --endnotpsql        
// /*psql ON CONFLICT(xoePk, xoeDestination) DO UPDATE
//     SET xoePending = (SELECT XObjectEntity.xObjectLct
//        FROM XObjectEntity
//       WHERE XObjectEntityxObjectUid = EXCLUDED.xoePk ) 
//             != XObjectEntity.xoeVersionId
//  */               
// """)
// @ReplicationRunOnChange([XObjectEntity::class])
// @ReplicationCheckPendingNotificationsFor([XObjectEntity::class])
// abstract suspend fun replicateOnChange()
package com.ustadmobile.lib.db.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import com.ustadmobile.door.`annotation`.ReplicationDestinationNodeId
import com.ustadmobile.door.`annotation`.ReplicationEntityForeignKey
import com.ustadmobile.door.`annotation`.ReplicationPending
import com.ustadmobile.door.`annotation`.ReplicationVersionId
import kotlin.Boolean
import kotlin.Long
import kotlinx.serialization.Serializable

@Entity(
  primaryKeys = arrayOf("xoePk", "xoeDestination"),
  indices = arrayOf(Index(value = arrayOf("xoePk", "xoeDestination", "xoeVersionId")),
  Index(value = arrayOf("xoeDestination", "xoePending")))

)
@Serializable
public class XObjectEntityReplicate {
  @ReplicationEntityForeignKey
  public var xoePk: Long = 0

  @ColumnInfo(defaultValue = "0")
  @ReplicationVersionId
  public var xoeVersionId: Long = 0

  @ReplicationDestinationNodeId
  public var xoeDestination: Long = 0

  @ColumnInfo(defaultValue = "1")
  @ReplicationPending
  public var xoePending: Boolean = true
}
