package com.ustadmobile.core.db;

import java.lang.System;

/**
 * These triggers manage recursive progress tracking for ContentJobItem. Each ContentJobItem
 * can have multiple children, e.g.
 *
 * ContentJobItem (parent)
 * - ContentJobItem (child)
 * - ContentJobItem (child)
 *   - ContentJobItem (grandchild)
 *
 * A ContentJobItem can contain thousands of child items. Normally if the user wants to see the
 * progress of the parent item, this would create a complex recursive query (infeasible to use
 * to display regular progress).
 *
 * The recursive trigger system works by posting progress up the tree when an update occurs.
 */
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2 = {"Lcom/ustadmobile/core/db/ContentJobItemTriggersCallback;", "Lcom/ustadmobile/door/DoorDatabaseCallbackStatementList;", "()V", "onCreate", "", "", "db", "Lcom/ustadmobile/door/DoorSqlDatabase;", "onOpen", "Companion", "lib-database"})
public final class ContentJobItemTriggersCallback implements com.ustadmobile.door.DoorDatabaseCallbackStatementList {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.ContentJobItemTriggersCallback.Companion Companion = null;
    private static final java.lang.String[] sqliteContentJobItemTriggers = null;
    private static final java.lang.String[] postgresContentJobItemTriggers = null;
    
    public ContentJobItemTriggersCallback() {
        super();
    }
    
    @org.jetbrains.annotations.NotNull()
    @java.lang.Override()
    public java.util.List<java.lang.String> onCreate(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.door.DoorSqlDatabase db) {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    @java.lang.Override()
    public java.util.List<java.lang.String> onOpen(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.door.DoorSqlDatabase db) {
        return null;
    }
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\r"}, d2 = {"Lcom/ustadmobile/core/db/ContentJobItemTriggersCallback$Companion;", "", "()V", "postgresContentJobItemTriggers", "", "", "[Ljava/lang/String;", "sqliteContentJobItemTriggers", "dumpSqlStatements", "", "getStatusOfItemAndChildrenSql", "contentJobItemUidExpression", "recursiveStatusCaseClause", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
        
        /**
         * This is a convenience function that can be called from a test. Use it to get a list of
         * all statements to copy/paste for migration purposes.
         */
        public final void dumpSqlStatements() {
        }
        
        /**
         * Creates a UNION statement to select the status columns of the given ContentJobItem and
         * all of its direct children.
         */
        private final java.lang.String getStatusOfItemAndChildrenSql(java.lang.String contentJobItemUidExpression) {
            return null;
        }
        
        @org.jetbrains.annotations.NotNull()
        public final java.lang.String recursiveStatusCaseClause(@org.jetbrains.annotations.NotNull()
        java.lang.String contentJobItemUidExpression) {
            return null;
        }
    }
}