package com.ustadmobile.core.db;

import java.lang.System;

/**
 * Constants representing a network job status
 *
 * Statuses are grouped in ranges:
 * 0:       not queued
 * 1:       paused (by the user)
 * 2-10     waiting (inc. wait for retry)
 * 11-20    active/running
 * 21-30    finished
 */
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2 = {"Lcom/ustadmobile/core/db/JobStatus;", "", "()V", "CANCELED", "", "COMPLETE", "COMPLETE_MAX", "COMPLETE_MIN", "FAILED", "NOT_QUEUED", "PARTIAL_FAILED", "PAUSED", "QUEUED", "RUNNING", "RUNNING_MAX", "RUNNING_MIN", "WAITING_FOR_CONNECTION", "WAITING_MAX", "WAITING_MIN", "statusToString", "", "status", "lib-database"})
public final class JobStatus {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.JobStatus INSTANCE = null;
    public static final int NOT_QUEUED = 0;
    public static final int PAUSED = 3;
    
    /**
     * The minimum value of waiting type statuses e.g. queued, waiting for connection, etc. (inclusive)
     */
    public static final int WAITING_MIN = 4;
    
    /**
     * The maximum value of waiting type statuses - e.g.
     */
    public static final int WAITING_MAX = 10;
    public static final int QUEUED = 4;
    
    /**
     * Waiting for a connection. Could be waiting for Wifi / p2p availability if the download job
     * should complete without using mobile data. Could also be waiting for any kind of network if
     * the job does not depend on wifi.
     */
    public static final int WAITING_FOR_CONNECTION = 5;
    public static final int RUNNING_MIN = 11;
    public static final int RUNNING_MAX = 20;
    public static final int RUNNING = 12;
    public static final int COMPLETE_MIN = 21;
    public static final int COMPLETE_MAX = 30;
    public static final int PARTIAL_FAILED = 23;
    public static final int COMPLETE = 24;
    public static final int FAILED = 25;
    public static final int CANCELED = 28;
    
    private JobStatus() {
        super();
    }
    
    @org.jetbrains.annotations.NotNull()
    public final java.lang.String statusToString(int status) {
        return null;
    }
}