package com.ustadmobile.core.db;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\'\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\'J\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0011\u0010\u001b\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u001c\u001a\u00020\u00052\b\b\u0001\u0010\u001d\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J)\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2 = {"Lcom/ustadmobile/core/db/SiteTermsDao;", "Lcom/ustadmobile/core/db/dao/OneToManyJoinDao;", "Lcom/ustadmobile/lib/db/entities/SiteTerms;", "()V", "deactivateByUids", "", "uidList", "", "", "changeTime", "(Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllTermsAsFactory", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/SiteTermsWithLanguage;", "findAllWithLanguageAsList", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidAsync", "uid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findSiteTerms", "langCode", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertAsync", "siteTerms", "(Lcom/ustadmobile/lib/db/entities/SiteTerms;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "replicateOnNewNode", "newNodeId", "updateActiveByUid", "sTermsUid", "active", "", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class SiteTermsDao implements com.ustadmobile.core.db.dao.OneToManyJoinDao<com.ustadmobile.lib.db.entities.SiteTerms> {
    
    public SiteTermsDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO SiteTermsReplicate(stPk, stDestination)\n      SELECT DISTINCT SiteTerms.sTermsUid AS stPk,\n             :newNodeId AS stDestination\n        FROM SiteTerms\n       WHERE SiteTerms.sTermsLct != COALESCE(\n             (SELECT stVersionId\n                FROM SiteTermsReplicate\n               WHERE stPk = SiteTerms.sTermsUid\n                 AND stDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(stPk, stDestination) DO UPDATE\n             SET stPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.SiteTerms.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO SiteTermsReplicate(stPk, stDestination)\n  SELECT DISTINCT SiteTerms.sTermsUid AS stUid,\n         UserSession.usClientNodeId AS stDestination\n    FROM ChangeLog\n         JOIN SiteTerms\n             ON ChangeLog.chTableId = 272\n                AND ChangeLog.chEntityPk = SiteTerms.sTermsUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND SiteTerms.sTermsLct != COALESCE(\n         (SELECT stVersionId\n            FROM SiteTermsReplicate\n           WHERE stPk = SiteTerms.sTermsUid\n             AND stDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(stPk, stDestination) DO UPDATE\n     SET stPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.SiteTerms.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.SiteTerms.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * FROM SiteTerms WHERE sTermsUid = coalesce(\n            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = :langCode LIMIT 1),\n            (SELECT sTermsUid FROM SiteTerms st_int WHERE st_int.sTermsLang = \'en\' LIMIT 1),\n            0)\n    ")
    public abstract java.lang.Object findSiteTerms(@org.jetbrains.annotations.NotNull()
    java.lang.String langCode, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.SiteTerms> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.SiteTerms siteTerms, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM SiteTerms WHERE sTermsUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.SiteTerms> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT SiteTerms.*, Language.* \n        FROM SiteTerms \n        LEFT JOIN Language ON SiteTerms.sTermsLangUid = Language.langUid\n        WHERE CAST(sTermsActive AS INTEGER) = 1\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.SiteTermsWithLanguage> findAllTermsAsFactory();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT SiteTerms.*, Language.*\n        FROM SiteTerms\n        LEFT JOIN Language ON SiteTerms.sTermsLangUid = Language.langUid\n        WHERE CAST(sTermsActive AS INTEGER) = 1\n    ")
    public abstract java.lang.Object findAllWithLanguageAsList(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.SiteTermsWithLanguage>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Transaction()
    @java.lang.Override()
    public java.lang.Object deactivateByUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE SiteTerms \n           SET sTermsActive = :active,\n               sTermsLct = :changeTime\n         WHERE sTermsUid = :sTermsUid\n        ")
    public abstract java.lang.Object updateActiveByUid(long sTermsUid, boolean active, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}