package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003JF\u0010\u0004\u001a\u0004\u0018\u00010\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0006H\'J#\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0011\u0010\u000f\u001a\u00020\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\u00102\b\b\u0001\u0010\u0013\u001a\u00020\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2 = {"Lcom/ustadmobile/core/db/dao/AgentDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/AgentEntity;", "()V", "getAgentByAnyId", "openId", "", "mbox", "account", "homepage", "sha1", "getAgentFromPersonUsername", "endpoint", "username", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class AgentDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.AgentEntity> {
    
    public AgentDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO AgentEntityReplicate(aePk, aeDestination)\n      SELECT DISTINCT AgentEntity.agentUid AS aeUid,\n             :newNodeId AS aeDestination\n        FROM UserSession\n        JOIN PersonGroupMember \n               ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n               \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions & \n                        64\n                        \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n        JOIN AgentEntity \n             ON AgentEntity.agentPersonUid = Person.personUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         --notpsql \n         AND AgentEntity.agentLct != COALESCE(\n             (SELECT aeVersionId\n                FROM AgentEntityReplicate\n               WHERE aePk = AgentEntity.agentUid\n                 AND aeDestination = UserSession.usClientNodeId), 0) \n         --endnotpsql        \n      /*psql ON CONFLICT(aePk, aeDestination) DO UPDATE\n             SET aePending = (SELECT AgentEntity.agentLct\n                                FROM AgentEntity\n                               WHERE AgentEntity.agentUid = EXCLUDED.aePk ) \n                                     != AgentEntityReplicate.aePk\n      */       \n     ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.AgentEntity.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n     REPLACE INTO AgentEntityReplicate(aePk, aeDestination)\n      SELECT DISTINCT AgentEntity.agentUid AS aeUid,\n             UserSession.usClientNodeId AS aeDestination\n        FROM ChangeLog\n             JOIN AgentEntity\n                 ON ChangeLog.chTableId = 68\n                    AND ChangeLog.chEntityPk = AgentEntity.agentUid\n             JOIN Person \n                       ON Person.personUid = AgentEntity.agentPersonUid\n                  \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n                        64\n                        \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n               \n       WHERE UserSession.usClientNodeId != (\n             SELECT nodeClientId \n               FROM SyncNode\n              LIMIT 1)\n         --notpsql \n         AND AgentEntity.agentLct != COALESCE(\n             (SELECT aeVersionId\n                FROM AgentEntityReplicate\n               WHERE aePk = AgentEntity.agentUid\n                 AND aeDestination = UserSession.usClientNodeId), 0) \n         --endnotpsql \n      /*psql ON CONFLICT(aePk, aeDestination) DO UPDATE\n             SET aePending = (SELECT AgentEntity.agentLct\n                                FROM AgentEntity\n                               WHERE AgentEntity.agentUid = EXCLUDED.aePk ) \n                                     != AgentEntityReplicate.aePk\n      */    \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.AgentEntity.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.AgentEntity.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM AgentEntity WHERE agentOpenId = :openId OR agentMbox = :mbox OR agentMbox_sha1sum = :sha1 OR (agentAccountName = :account AND agentHomePage = :homepage)")
    public abstract com.ustadmobile.lib.db.entities.AgentEntity getAgentByAnyId(@org.jetbrains.annotations.Nullable()
    java.lang.String openId, @org.jetbrains.annotations.Nullable()
    java.lang.String mbox, @org.jetbrains.annotations.Nullable()
    java.lang.String account, @org.jetbrains.annotations.Nullable()
    java.lang.String homepage, @org.jetbrains.annotations.Nullable()
    java.lang.String sha1);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT *\n          FROM AgentEntity\n         WHERE agentAccountName = :username \n           AND agentHomePage = :endpoint\n    ")
    public abstract java.lang.Object getAgentFromPersonUsername(@org.jetbrains.annotations.NotNull()
    java.lang.String endpoint, @org.jetbrains.annotations.NotNull()
    java.lang.String username, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.AgentEntity> continuation);
}