package com.ustadmobile.core.db.dao;

import java.lang.System;

/**
 * Represents the minimal functionality that a DAO is expected to provide
 *
 * @param <T> The entity object
 * </T>
 */
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H\'\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0000H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\'J\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00028\u0000H\'\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2 = {"Lcom/ustadmobile/core/db/dao/BaseDao;", "T", "", "insert", "", "entity", "(Ljava/lang/Object;)J", "insertAsync", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertList", "", "entityList", "", "update", "(Ljava/lang/Object;)V", "updateList", "lib-database"})
public abstract interface BaseDao<T extends java.lang.Object> {
    
    /**
     * Insert the given entity
     *
     * @param entity entity to insert
     *
     * @return the generated primary key (if any)
     */
    @androidx.room.Insert()
    public abstract long insert(T entity);
    
    /**
     * Insert the given entity asynchronously
     *
     * @param entity entity to insert
     * @param result calback to run when complete, which returns the generated primary key (if any)
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertAsync(T entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @androidx.room.Insert()
    public abstract void insertList(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends T> entityList);
    
    /**
     * @param entityList
     */
    @androidx.room.Update()
    public abstract void updateList(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends T> entityList);
    
    /**
     * Find the given entity by the primary key
     *
     * @param uid uid to find
     * @return the object represented by the primary key, or null if there is no such object
     */
    @androidx.room.Update()
    public abstract void update(T entity);
}