package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u00020\u00052\b\b\u0001\u0010\b\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2 = {"Lcom/ustadmobile/core/db/dao/ChatMemberDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ChatMember;", "()V", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ChatMemberDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ChatMember> {
    
    public ChatMemberDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO chatMemberReplicate(chatMemberPk, chatMemberDestination)\n      SELECT DISTINCT ChatMember.chatMemberUid AS chatMemberPk,\n             :newNodeId AS chatMemberDestination\n             \n        FROM UserSession\n            JOIN ChatMember \n                 ON ((ChatMember.chatMemberChatUid IN\n                      (SELECT chatMemberInternal.chatMemberChatUid \n                         FROM ChatMember chatMemberInternal\n                        WHERE chatMemberInternal.chatMemberPersonUid = UserSession.usPersonUid))\n                     OR UserSession.usSessionType = 2)\n                 AND UserSession.usStatus = 1 \n       WHERE ChatMember.chatMemberLct != COALESCE(\n             (SELECT chatMemberVersionId\n                FROM chatMemberReplicate\n               WHERE chatMemberPk = ChatMember.chatMemberUid\n                 AND chatMemberDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(chatMemberPk, chatMemberDestination) DO UPDATE\n             SET chatMemberPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ChatMember.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n         REPLACE INTO chatMemberReplicate(chatMemberPk, chatMemberDestination)\n          SELECT DISTINCT ChatMember.chatMemberUid AS chatMemberUid,\n                 UserSession.usClientNodeId AS chatMemberDestination\n            FROM ChangeLog\n                 JOIN chatMember\n                     ON ChangeLog.chTableId = 128\n                        AND ChangeLog.chEntityPk = ChatMember.chatMemberUid\n                        \n                 JOIN UserSession ON \n                      (UserSession.usSessionType = 2\n                      OR (UserSession.usPersonUid IN \n                           (SELECT ChatMember.chatMemberPersonUid \n                              FROM ChatMember \n                             WHERE ChatMember.chatMemberChatUid IN \n                                   (SELECT ChatMemberInternal.chatMemberChatUid \n                                      FROM ChatMember ChatMemberInternal\n                                     WHERE ChatMemberInternal.chatMemberPersonUid = \n                                           UserSession.usPersonUid))))\n                      AND UserSession.usStatus = 1\n                      \n                \n           WHERE UserSession.usClientNodeId != (\n                 SELECT nodeClientId \n                   FROM SyncNode\n                  LIMIT 1)\n             AND ChatMember.chatMemberLct != COALESCE(\n                 (SELECT chatMemberVersionId\n                    FROM chatMemberReplicate\n                   WHERE chatMemberPk = ChatMember.chatMemberUid\n                     AND chatMemberDestination = UserSession.usClientNodeId), 0)\n         /*psql ON CONFLICT(chatMemberPk, chatMemberDestination) DO UPDATE\n             SET chatMemberPending = true\n          */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ChatMember.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ChatMember.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}