package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\'\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J\'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\'J\u0011\u0010\u000e\u001a\u00020\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u00020\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzAssignmentContentJoinDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ClazzAssignmentContentJoin;", "()V", "findAllContentByClazzAssignmentUidAsync", "", "Lcom/ustadmobile/lib/db/entities/ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer;", "clazzAssignmentUid", "", "personUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllContentByClazzAssignmentUidDF", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class ClazzAssignmentContentJoinDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ClazzAssignmentContentJoin> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ClazzAssignmentContentJoinDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String FINDBY_CLAZZ_ASSIGNMENT_UID = "\n                    SELECT ContentEntry.*, ContentEntryParentChildJoin.*, \n                            Container.*, \n                             COALESCE(ClazzAssignmentRollUp.cacheStudentScore,0) AS resultScore,\n                                           \n                             COALESCE(ClazzAssignmentRollUp.cacheMaxScore,0) AS resultMax,\n                                                         \n                             COALESCE(ClazzAssignmentRollUp.cacheProgress,0) AS progress,                            \n                            \n                             COALESCE(ClazzAssignmentRollUp.cacheContentComplete,\'FALSE\') AS contentComplete,\n                                 \n                             COALESCE(ClazzAssignmentRollUp.cacheSuccess,0) AS success,\n                             \n                             COALESCE(ClazzAssignmentRollUp.cachePenalty,0) AS penalty,\n                               \n                             COALESCE((CASE WHEN ClazzAssignmentRollUp.cacheContentComplete \n                                            THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                        \n                             0 as assignmentContentWeight,\n                             1 as totalContent\n                           \n                             \n                      FROM ClazzAssignmentContentJoin\n                            LEFT JOIN ContentEntry \n                            ON ContentEntry.contentEntryUid = cacjContentUid \n                            \n                            LEFT JOIN ContentEntryParentChildJoin \n                            ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n                           \n                            LEFT JOIN ClazzAssignmentRollUp\n                            ON cacheContentEntryUid = ClazzAssignmentContentJoin.cacjContentUid\n                                AND cachePersonUid = :personUid\n                                AND cacheClazzAssignmentUid = :clazzAssignmentUid\n                                                        \n                            \n                            LEFT JOIN Container \n                            ON Container.containerUid = \n                                (SELECT containerUid \n                                   FROM Container \n                                  WHERE containerContentEntryUid =  ContentEntry.contentEntryUid \n                               ORDER BY cntLastModified DESC LIMIT 1)\n                               \n                    WHERE ClazzAssignmentContentJoin.cacjAssignmentUid = :clazzAssignmentUid\n                      AND ClazzAssignmentContentJoin.cacjActive\n                      AND NOT ContentEntry.ceInactive\n                      AND (ContentEntry.publik OR :personUid != 0)\n                      ORDER BY ContentEntry.title ASC , \n                               ContentEntryParentChildJoin.childIndex, ContentEntry.contentEntryUid\n                               ";
    
    public ClazzAssignmentContentJoinDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ClazzAssignmentContentJoinReplicate(cacjPk, cacjDestination)\n      SELECT DISTINCT ClazzAssignmentContentJoin.cacjUid AS cacjUid,\n             :newNodeId AS cacjDestination\n        FROM UserSession\n               JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n               \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    8388608 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n         \n               JOIN ClazzAssignment\n                    ON ClazzAssignment.caClazzUid = Clazz.clazzUid\n               JOIN ClazzAssignmentContentJoin\n                    ON ClazzAssignment.caUid = ClazzAssignmentContentJoin.cacjAssignmentUid     \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1             \n         AND ClazzAssignmentContentJoin.cacjLct != COALESCE(\n             (SELECT cacjVersionId\n                FROM ClazzAssignmentContentJoinReplicate\n               WHERE cacjPk = ClazzAssignmentContentJoin.cacjUid\n                 AND cacjDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(cacjPk, cacjDestination) DO UPDATE\n             SET cacjPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzAssignmentContentJoin.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ClazzAssignmentContentJoinReplicate(cacjPk, cacjDestination)\n  SELECT DISTINCT ClazzAssignmentContentJoin.cacjUid AS cacjUid,\n         UserSession.usClientNodeId AS cacjDestination\n    FROM ChangeLog\n         JOIN ClazzAssignmentContentJoin\n             ON ChangeLog.chTableId = 521\n                AND ChangeLog.chEntityPk = ClazzAssignmentContentJoin.cacjUid\n         JOIN ClazzAssignment\n              ON ClazzAssignment.caUid = ClazzAssignmentContentJoin.cacjAssignmentUid\n         JOIN Clazz \n              ON Clazz.clazzUid = ClazzAssignment.caClazzUid \n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              8388608\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ClazzAssignmentContentJoin.cacjLct != COALESCE(\n         (SELECT cacjVersionId\n            FROM ClazzAssignmentContentJoinReplicate\n           WHERE cacjPk = ClazzAssignmentContentJoin.cacjUid\n             AND cacjDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(cacjPk, cacjDestination) DO UPDATE\n     SET cacjPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzAssignmentContentJoin.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ClazzAssignmentContentJoin.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n                    SELECT ContentEntry.*, ContentEntryParentChildJoin.*, \n                            Container.*, \n                             COALESCE(ClazzAssignmentRollUp.cacheStudentScore,0) AS resultScore,\n                                           \n                             COALESCE(ClazzAssignmentRollUp.cacheMaxScore,0) AS resultMax,\n                                                         \n                             COALESCE(ClazzAssignmentRollUp.cacheProgress,0) AS progress,                            \n                            \n                             COALESCE(ClazzAssignmentRollUp.cacheContentComplete,\'FALSE\') AS contentComplete,\n                                 \n                             COALESCE(ClazzAssignmentRollUp.cacheSuccess,0) AS success,\n                             \n                             COALESCE(ClazzAssignmentRollUp.cachePenalty,0) AS penalty,\n                               \n                             COALESCE((CASE WHEN ClazzAssignmentRollUp.cacheContentComplete \n                                            THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                        \n                             0 as assignmentContentWeight,\n                             1 as totalContent\n                           \n                             \n                      FROM ClazzAssignmentContentJoin\n                            LEFT JOIN ContentEntry \n                            ON ContentEntry.contentEntryUid = cacjContentUid \n                            \n                            LEFT JOIN ContentEntryParentChildJoin \n                            ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n                           \n                            LEFT JOIN ClazzAssignmentRollUp\n                            ON cacheContentEntryUid = ClazzAssignmentContentJoin.cacjContentUid\n                                AND cachePersonUid = :personUid\n                                AND cacheClazzAssignmentUid = :clazzAssignmentUid\n                                                        \n                            \n                            LEFT JOIN Container \n                            ON Container.containerUid = \n                                (SELECT containerUid \n                                   FROM Container \n                                  WHERE containerContentEntryUid =  ContentEntry.contentEntryUid \n                               ORDER BY cntLastModified DESC LIMIT 1)\n                               \n                    WHERE ClazzAssignmentContentJoin.cacjAssignmentUid = :clazzAssignmentUid\n                      AND ClazzAssignmentContentJoin.cacjActive\n                      AND NOT ContentEntry.ceInactive\n                      AND (ContentEntry.publik OR :personUid != 0)\n                      ORDER BY ContentEntry.title ASC , \n                               ContentEntryParentChildJoin.childIndex, ContentEntry.contentEntryUid\n                               ")
    public abstract java.lang.Object findAllContentByClazzAssignmentUidAsync(long clazzAssignmentUid, long personUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n                    SELECT ContentEntry.*, ContentEntryParentChildJoin.*, \n                            Container.*, \n                             COALESCE(ClazzAssignmentRollUp.cacheStudentScore,0) AS resultScore,\n                                           \n                             COALESCE(ClazzAssignmentRollUp.cacheMaxScore,0) AS resultMax,\n                                                         \n                             COALESCE(ClazzAssignmentRollUp.cacheProgress,0) AS progress,                            \n                            \n                             COALESCE(ClazzAssignmentRollUp.cacheContentComplete,\'FALSE\') AS contentComplete,\n                                 \n                             COALESCE(ClazzAssignmentRollUp.cacheSuccess,0) AS success,\n                             \n                             COALESCE(ClazzAssignmentRollUp.cachePenalty,0) AS penalty,\n                               \n                             COALESCE((CASE WHEN ClazzAssignmentRollUp.cacheContentComplete \n                                            THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                        \n                             0 as assignmentContentWeight,\n                             1 as totalContent\n                           \n                             \n                      FROM ClazzAssignmentContentJoin\n                            LEFT JOIN ContentEntry \n                            ON ContentEntry.contentEntryUid = cacjContentUid \n                            \n                            LEFT JOIN ContentEntryParentChildJoin \n                            ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n                           \n                            LEFT JOIN ClazzAssignmentRollUp\n                            ON cacheContentEntryUid = ClazzAssignmentContentJoin.cacjContentUid\n                                AND cachePersonUid = :personUid\n                                AND cacheClazzAssignmentUid = :clazzAssignmentUid\n                                                        \n                            \n                            LEFT JOIN Container \n                            ON Container.containerUid = \n                                (SELECT containerUid \n                                   FROM Container \n                                  WHERE containerContentEntryUid =  ContentEntry.contentEntryUid \n                               ORDER BY cntLastModified DESC LIMIT 1)\n                               \n                    WHERE ClazzAssignmentContentJoin.cacjAssignmentUid = :clazzAssignmentUid\n                      AND ClazzAssignmentContentJoin.cacjActive\n                      AND NOT ContentEntry.ceInactive\n                      AND (ContentEntry.publik OR :personUid != 0)\n                      ORDER BY ContentEntry.title ASC , \n                               ContentEntryParentChildJoin.childIndex, ContentEntry.contentEntryUid\n                               ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> findAllContentByClazzAssignmentUidDF(long clazzAssignmentUid, long personUid);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzAssignmentContentJoinDao$Companion;", "", "()V", "FINDBY_CLAZZ_ASSIGNMENT_UID", "", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}