package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\b\'\u0018\u0000 02\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0004J\'\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00102\u0006\u0010\r\u001a\u00020\tH\'J\u001b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\'J\u001f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u0015\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u0016\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ(\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00102\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\'J4\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\'J!\u0010!\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u0011\u0010$\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u001b\u0010&\u001a\u00020\u00062\b\b\u0001\u0010\'\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ)\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020+2\u0006\u0010\n\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0019\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzAssignmentDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ClazzAssignment;", "Lcom/ustadmobile/core/db/dao/OneToManyJoinDao;", "()V", "deactivateByUids", "", "uidList", "", "", "changeTime", "(Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidAsync", "uid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "findByUidWithBlockAsync", "Lcom/ustadmobile/lib/db/entities/ClazzAssignmentWithCourseBlock;", "findClazzAssignment", "getAllAssignmentsByClazzUidAsync", "clazzUid", "getGroupUidFromAssignment", "getProgressSummaryForAssignment", "Lcom/ustadmobile/lib/db/entities/AssignmentProgressSummary;", "assignmentUid", "group", "", "getSubmitterListForAssignment", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/PersonGroupAssignmentSummary;", "searchText", "getSubmitterUid", "personUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateActiveByUid", "cbUid", "active", "", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "clazzAssignment", "(Lcom/ustadmobile/lib/db/entities/ClazzAssignment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class ClazzAssignmentDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ClazzAssignment>, com.ustadmobile.core.db.dao.OneToManyJoinDao<com.ustadmobile.lib.db.entities.ClazzAssignment> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ClazzAssignmentDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String SUBMITTER_LIST_CTE = "\n            WITH SubmitterList (submitterId, name)\n            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                       Person.firstNames || \' \' || Person.lastName AS name\n                  FROM ClazzEnrolment\n                  \n                       JOIN Person \n                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                        \n                       JOIN ClazzAssignment\n                       ON ClazzAssignment.caUid = :assignmentUid\n\n                       JOIN CourseBlock\n                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n                       AND CourseBlock.cbType = 103\n                       \n                 WHERE ClazzAssignment.caGroupUid = 0\n                   AND clazzEnrolmentClazzUid = :clazzUid\n                   AND clazzEnrolmentActive\n                   AND clazzEnrolmentRole = 1000\n                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft\n                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate\n              GROUP BY submitterId, name\n            UNION                 \n             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                    :group || \' \' || CourseGroupMember.cgmGroupNumber AS name  \n               FROM CourseGroupMember\n                    JOIN ClazzAssignment\n                    ON ClazzAssignment.caUid = :assignmentUid\n              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid\n                AND ClazzAssignment.caGroupUid != 0\n                AND CourseGroupMember.cgmGroupNumber != 0\n           GROUP BY submitterId, name\n            )\n        ";
    public static final int SORT_DEADLINE_ASC = 1;
    public static final int SORT_DEADLINE_DESC = 2;
    public static final int SORT_TITLE_ASC = 3;
    public static final int SORT_TITLE_DESC = 4;
    public static final int SORT_SCORE_ASC = 5;
    public static final int SORT_SCORE_DESC = 6;
    public static final int SORT_START_DATE_ASC = 7;
    public static final int SORT_START_DATE_DESC = 8;
    
    public ClazzAssignmentDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ClazzAssignmentReplicate(caPk, caDestination)\n      SELECT DISTINCT ClazzAssignment.caUid AS caUid,\n             :newNodeId AS caDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    8388608 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n             JOIN ClazzAssignment\n                    ON ClazzAssignment.caClazzUid = Clazz.clazzUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND ClazzAssignment.caLct != COALESCE(\n             (SELECT caVersionId\n                FROM ClazzAssignmentReplicate\n               WHERE caPk = ClazzAssignment.caUid\n                 AND caDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(caPk, caDestination) DO UPDATE\n             SET caPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzAssignment.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ClazzAssignmentReplicate(caPk, caDestination)\n  SELECT DISTINCT ClazzAssignment.caUid AS caUid,\n         UserSession.usClientNodeId AS caDestination\n    FROM ChangeLog\n         JOIN ClazzAssignment\n             ON ChangeLog.chTableId = 520\n                AND ChangeLog.chEntityPk = ClazzAssignment.caUid\n         JOIN Clazz \n              ON Clazz.clazzUid = ClazzAssignment.caClazzUid \n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              8388608\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n          \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ClazzAssignment.caLct != COALESCE(\n         (SELECT caVersionId\n            FROM ClazzAssignmentReplicate\n           WHERE caPk = ClazzAssignment.caUid\n             AND caDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(caPk, caDestination) DO UPDATE\n     SET caPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzAssignment.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ClazzAssignment.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM ClazzAssignment\n         WHERE ClazzAssignment.caClazzUid = :clazzUid\n    ")
    public abstract java.lang.Object getAllAssignmentsByClazzUidAsync(long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.ClazzAssignment>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ClazzAssignment \n           SET caActive = :active, \n               caLct = :changeTime\n         WHERE caUid = :cbUid")
    public abstract java.lang.Object updateActiveByUid(long cbUid, boolean active, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @java.lang.Override()
    public java.lang.Object deactivateByUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n            \n            WITH SubmitterList (submitterId, name)\n            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                       Person.firstNames || \' \' || Person.lastName AS name\n                  FROM ClazzEnrolment\n                  \n                       JOIN Person \n                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                        \n                       JOIN ClazzAssignment\n                       ON ClazzAssignment.caUid = :assignmentUid\n\n                       JOIN CourseBlock\n                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n                       AND CourseBlock.cbType = 103\n                       \n                 WHERE ClazzAssignment.caGroupUid = 0\n                   AND clazzEnrolmentClazzUid = :clazzUid\n                   AND clazzEnrolmentActive\n                   AND clazzEnrolmentRole = 1000\n                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft\n                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate\n              GROUP BY submitterId, name\n            UNION                 \n             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                    :group || \' \' || CourseGroupMember.cgmGroupNumber AS name  \n               FROM CourseGroupMember\n                    JOIN ClazzAssignment\n                    ON ClazzAssignment.caUid = :assignmentUid\n              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid\n                AND ClazzAssignment.caGroupUid != 0\n                AND CourseGroupMember.cgmGroupNumber != 0\n           GROUP BY submitterId, name\n            )\n        \n            \n            SELECT (SELECT COUNT(*) FROM SubmitterList) AS totalStudents,\n            \n                    0 as notSubmittedStudents,\n                    \n                    (SELECT COUNT(DISTINCT CourseAssignmentSubmission.casSubmitterUid) \n                      FROM CourseAssignmentSubmission\n                           LEFT JOIN CourseAssignmentMark\n                           ON CourseAssignmentSubmission.casSubmitterUid = CourseAssignmentMark.camSubmitterUid\n                           AND CourseAssignmentMark.camAssignmentUid = CourseAssignmentSubmission.casAssignmentUid\n                     WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n                       AND CourseAssignmentMark.camUid IS NULL\n                       AND CourseAssignmentSubmission.casSubmitterUid IN (SELECT submitterId \n                                                                            FROM SubmitterList))\n                      AS submittedStudents,\n                     \n                     \n                     (SELECT COUNT(DISTINCT CourseAssignmentMark.camSubmitterUid) \n                        FROM CourseAssignmentMark\n                            \n                             JOIN CourseAssignmentSubmission\n                             ON CourseAssignmentSubmission.casSubmitterUid = CourseAssignmentMark.camSubmitterUid\n                             AND CourseAssignmentSubmission.casAssignmentUid = CourseAssignmentMark.camAssignmentUid\n                             \n                       WHERE CourseAssignmentMark.camAssignmentUid = :assignmentUid\n                         AND CourseAssignmentMark.camSubmitterUid IN (SELECT submitterId \n                                                                            FROM SubmitterList))\n                         AS markedStudents, \n                         \n                         \'TRUE\' AS hasMetricsPermission\n                         \n         FROM  ClazzAssignment\n        WHERE caActive\n          AND caClazzUid = :clazzUid \n          AND caUid = :assignmentUid                  \n    ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.AssignmentProgressSummary> getProgressSummaryForAssignment(long assignmentUid, long clazzUid, @org.jetbrains.annotations.NotNull()
    java.lang.String group);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n         \n            WITH SubmitterList (submitterId, name)\n            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId, \n                       Person.firstNames || \' \' || Person.lastName AS name\n                  FROM ClazzEnrolment\n                  \n                       JOIN Person \n                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                        \n                       JOIN ClazzAssignment\n                       ON ClazzAssignment.caUid = :assignmentUid\n\n                       JOIN CourseBlock\n                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n                       AND CourseBlock.cbType = 103\n                       \n                 WHERE ClazzAssignment.caGroupUid = 0\n                   AND clazzEnrolmentClazzUid = :clazzUid\n                   AND clazzEnrolmentActive\n                   AND clazzEnrolmentRole = 1000\n                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft\n                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate\n              GROUP BY submitterId, name\n            UNION                 \n             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                    :group || \' \' || CourseGroupMember.cgmGroupNumber AS name  \n               FROM CourseGroupMember\n                    JOIN ClazzAssignment\n                    ON ClazzAssignment.caUid = :assignmentUid\n              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid\n                AND ClazzAssignment.caGroupUid != 0\n                AND CourseGroupMember.cgmGroupNumber != 0\n           GROUP BY submitterId, name\n            )\n        \n        \n         SELECT submitterId AS submitterUid,\n                name, \n                \n                 COALESCE((CASE WHEN CourseAssignmentMark.camUid IS NOT NULL \n                          THEN 2 \n                          WHEN CourseAssignmentSubmission.casUid IS NOT NULL \n                          THEN 1 \n                          ELSE 0 END), \n                               0) AS fileSubmissionStatus,\n                \n                (CASE WHEN ClazzAssignment.caGroupUid = 0 \n                 THEN \'TRUE\' \n                 ELSE \'FALSE\' END) AS isGroupAssignment,\n                 \n                 cm.commentsText AS latestPrivateComment \n\n           FROM SubmitterList\n                JOIN ClazzAssignment\n                ON ClazzAssignment.caUid = :assignmentUid\n           \n                LEFT JOIN CourseAssignmentMark\n                ON CourseAssignmentMark.camUid = (SELECT camUid\n                                                    FROM CourseAssignmentMark\n                                                   WHERE camAssignmentUid = :assignmentUid\n                                                     AND camSubmitterUid = SubmitterList.submitterId\n                                                ORDER BY camLct DESC \n                                                   LIMIT 1)\n                \n                LEFT JOIN CourseAssignmentSubmission\n                ON CourseAssignmentSubmission.casUid = (SELECT casUid\n                                                          FROM CourseAssignmentSubmission\n                                                         WHERE casAssignmentUid = :assignmentUid\n                                                           AND casSubmitterUid = SubmitterList.submitterId\n                                                      ORDER BY casTimestamp DESC \n                                                         LIMIT 1)\n                LEFT JOIN Comments AS cm \n                    ON cm.commentsUid = (\n                                 SELECT Comments.commentsUid \n                                   FROM Comments \n                                  WHERE Comments.commentsEntityType = 520\n                                    AND commentsEntityUid = :assignmentUid\n                                    AND NOT commentsInActive\n                                    AND NOT commentsPublic\n                                    AND (CASE WHEN ClazzAssignment.caGroupUid = 0\n                                              THEN commentsPersonUid = SubmitterList.submitterId\n                                              ELSE commentSubmitterUid = SubmitterList.submitterId END)\n                               ORDER BY commentsDateTimeAdded DESC LIMIT 1)                                                      \n                                                                      \n          WHERE name LIKE :searchText\n       ORDER BY name \n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.PersonGroupAssignmentSummary> getSubmitterListForAssignment(long assignmentUid, long clazzUid, @org.jetbrains.annotations.NotNull()
    java.lang.String group, @org.jetbrains.annotations.NotNull()
    java.lang.String searchText);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT (CASE WHEN ClazzAssignment.caGroupUid = 0 \n                     THEN :personUid \n                     WHEN CourseGroupMember.cgmUid IS NULL \n                     THEN 0 \n                     ELSE CourseGroupMember.cgmGroupNumber END) as submitterUid\n          FROM ClazzAssignment\n               LEFT JOIN CourseGroupMember\n               ON cgmSetUid = ClazzAssignment.caGroupUid\n               AND cgmPersonUid = :personUid\n         WHERE caUid = :assignmentUid\n    ")
    public abstract java.lang.Object getSubmitterUid(long assignmentUid, long personUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ClazzAssignment clazzAssignment, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM ClazzAssignment \n         WHERE caUid = :uid\n    ")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ClazzAssignment> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n          SELECT COALESCE((\n           SELECT caGroupUid\n           FROM ClazzAssignment\n          WHERE caUid = :uid),-1)\n    ")
    public abstract java.lang.Object getGroupUidFromAssignment(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM ClazzAssignment\n               LEFT JOIN CourseBlock\n               ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n               AND CourseBlock.cbType = 103\n         WHERE caUid = :uid\n    ")
    public abstract java.lang.Object findByUidWithBlockAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ClazzAssignmentWithCourseBlock> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM ClazzAssignment LIMIT 1\n    ")
    public abstract com.ustadmobile.lib.db.entities.ClazzAssignment findClazzAssignment();
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * \n                      FROM ClazzAssignment \n                     WHERE caUid = :uid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ClazzAssignment> findByUidLive(long uid);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzAssignmentDao$Companion;", "", "()V", "SORT_DEADLINE_ASC", "", "SORT_DEADLINE_DESC", "SORT_SCORE_ASC", "SORT_SCORE_DESC", "SORT_START_DATE_ASC", "SORT_START_DATE_DESC", "SORT_TITLE_ASC", "SORT_TITLE_DESC", "SUBMITTER_LIST_CTE", "", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}