package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00020\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ/\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzContentJoinDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ClazzContentJoin;", "()V", "listOfEntriesInClazz", "", "", "clazzUid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "toggleVisibilityClazzContent", "toggleVisibility", "", "selectedItem", "changedTime", "(ZLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ClazzContentJoinDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ClazzContentJoin> {
    
    public ClazzContentJoinDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ClazzContentJoinReplicate(ccjPk, ccjDestination)\n      SELECT DISTINCT ClazzContentJoin.ccjUid AS ccjUid,\n             :newNodeId AS ccjDestination\n        FROM UserSession\n               JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n               \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    4398046511104 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n               JOIN ClazzContentJoin    \n                    ON Clazz.clazzUid = ClazzContentJoin.ccjClazzUid\n       WHERE UserSession.usClientNodeId = :newNodeId \n         AND UserSession.usStatus = 1             \n         AND ClazzContentJoin.ccjLct != COALESCE(\n             (SELECT ccjVersionId\n                FROM ClazzContentJoinReplicate\n               WHERE ccjPk = ClazzContentJoin.ccjUid\n                 AND ccjDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(ccjPk, ccjDestination) DO UPDATE\n             SET ccjPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzContentJoin.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ClazzContentJoinReplicate(ccjPk, ccjDestination)\n  SELECT DISTINCT ClazzContentJoin.ccjUid AS ccjUid,\n         UserSession.usClientNodeId AS ccjDestination\n    FROM ChangeLog\n         JOIN ClazzContentJoin\n             ON ChangeLog.chTableId = 134\n                AND ChangeLog.chEntityPk = ClazzContentJoin.ccjUid\n         JOIN Clazz \n              ON Clazz.clazzUid = ClazzContentJoin.ccjClazzUid                \n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              4398046511104\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ClazzContentJoin.ccjLct != COALESCE(\n         (SELECT ccjVersionId\n            FROM ClazzContentJoinReplicate\n           WHERE ccjPk = ClazzContentJoin.ccjUid\n             AND ccjDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(ccjPk, ccjDestination) DO UPDATE\n     SET ccjPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzContentJoin.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ClazzContentJoin.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "UPDATE ClazzContentJoin \n                       SET ccjActive = :toggleVisibility, \n                           ccjLct = :changedTime \n                     WHERE ccjContentEntryUid IN (:selectedItem)")
    public abstract java.lang.Object toggleVisibilityClazzContent(boolean toggleVisibility, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> selectedItem, long changedTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ccjContentEntryUid \n          FROM ClazzContentJoin\n         WHERE ccjClazzUid = :clazzUid\n           AND ccjActive\n    ")
    public abstract java.lang.Object listOfEntriesInClazz(long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.Long>> continuation);
}