package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\'\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\'J\u001f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\'J\u0014\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00050\u000eH\'J\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0011H\'J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\bH\'J\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\bH\'J\u001b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u001d\u001a\u00020\bH\'Jb\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001f0\u000b2\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\bH\'J%\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J \u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010.0\u000e2\u0006\u0010/\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\'J\u001b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010/\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ)\u00102\u001a\u0002032\u0006\u0010!\u001a\u00020\b2\u0006\u0010/\u001a\u00020\b2\u0006\u0010\'\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0011\u00105\u001a\u000206H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u001b\u00108\u001a\u0002062\b\b\u0001\u00109\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\'\u0010:\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010!\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0019\u0010<\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J!\u0010?\u001a\u0002062\u0006\u0010/\u001a\u00020\b2\u0006\u0010@\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006B"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Clazz;", "()V", "findAll", "", "findAllClazzesBySchool", "schoolUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllClazzesBySchoolLive", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "findAllLive", "Lcom/ustadmobile/door/DoorLiveData;", "findByClazzCode", "code", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByClazzCodeFromWeb", "findByClazzName", "name", "findByUid", "uid", "findByUidAsync", "findByUidLive", "findByUidWithHolidayCalendarAsync", "Lcom/ustadmobile/lib/db/entities/ClazzWithHolidayCalendarAndSchoolAndTerminology;", "findClazzesWithEffectiveHolidayCalendarAndFilter", "filterUid", "findClazzesWithPermission", "Lcom/ustadmobile/lib/db/entities/ClazzWithListDisplayDetails;", "searchQuery", "accountPersonUid", "excludeSelectedClazzList", "excludeSchoolUid", "sortOrder", "filter", "currentTime", "permission", "selectedSchool", "getClassNamesFromListOfIds", "Lcom/ustadmobile/lib/db/entities/UidAndLabel;", "ids", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getClazzWithDisplayDetails", "Lcom/ustadmobile/lib/db/entities/ClazzWithDisplayDetails;", "clazzUid", "getClazzWithSchool", "Lcom/ustadmobile/lib/db/entities/ClazzWithSchool;", "personHasPermissionWithClazz", "", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "selectDelegatablePermissions", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/Clazz;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateClazzAttendanceAverageAsync", "timeChanged", "Companion", "lib-database"})
public abstract class ClazzDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.Clazz> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ClazzDao.Companion Companion = null;
    public static final int SORT_CLAZZNAME_ASC = 1;
    public static final int SORT_CLAZZNAME_DESC = 2;
    public static final int SORT_ATTENDANCE_ASC = 3;
    public static final int SORT_ATTENDANCE_DESC = 4;
    public static final int FILTER_ACTIVE_ONLY = 1;
    public static final int FILTER_CURRENTLY_ENROLLED = 5;
    public static final int FILTER_PAST_ENROLLMENTS = 6;
    private static final java.lang.String SELECT_ACTIVE_CLAZZES = "SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1";
    
    public ClazzDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ClazzReplicate(clazzPk, clazzDestination)\n      SELECT DISTINCT Clazz.clazzUid AS clazzUid,\n             :newNodeId AS clazzDestination\n        FROM UserSession\n               JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n               \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    2 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n       WHERE UserSession.usClientNodeId = :newNodeId \n         AND Clazz.clazzLct != COALESCE(\n             (SELECT clazzVersionId\n                FROM ClazzReplicate\n               WHERE clazzPk = Clazz.clazzUid\n                 AND clazzDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(clazzPk, clazzDestination) DO UPDATE\n             SET clazzPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Clazz.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ClazzReplicate(clazzPk, clazzDestination)\n  SELECT DISTINCT Clazz.clazzUid AS clazzUid,\n         UserSession.usClientNodeId AS clazzDestination\n    FROM ChangeLog\n         JOIN Clazz\n             ON ChangeLog.chTableId = 6\n                AND ChangeLog.chEntityPk = Clazz.clazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                    2\n                    \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND Clazz.clazzLct != COALESCE(\n         (SELECT clazzVersionId\n            FROM ClazzReplicate\n           WHERE clazzPk = Clazz.clazzUid\n             AND clazzDestination = UserSession.usClientNodeId), 0)\n  /*psql ON CONFLICT(clazzPk, clazzDestination) DO UPDATE\n      SET clazzPending = true\n   */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Clazz.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.Clazz.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Clazz WHERE clazzUid = :uid")
    public abstract com.ustadmobile.lib.db.entities.Clazz findByUid(long uid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * From Clazz WHERE clazzUid = :uid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.Clazz> findByUidLive(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Clazz WHERE clazzCode = :code")
    public abstract java.lang.Object findByClazzCode(@org.jetbrains.annotations.NotNull()
    java.lang.String code, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Clazz> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.Repository(methodType = 2)
    @com.ustadmobile.door.annotation.RepoHttpAccessible()
    @androidx.room.Query(value = "SELECT * FROM Clazz WHERE clazzCode = :code")
    public abstract java.lang.Object findByClazzCodeFromWeb(@org.jetbrains.annotations.NotNull()
    java.lang.String code, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Clazz> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.Clazz>> findAllLive();
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Clazz WHERE CAST(isClazzActive AS INTEGER) = 1")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Clazz> findAll();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Clazz WHERE clazzUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Clazz> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT Clazz.*, \n               HolidayCalendar.*, \n               School.*,\n               CourseTerminology.*\n          FROM Clazz \n               LEFT JOIN HolidayCalendar \n               ON Clazz.clazzHolidayUMCalendarUid = HolidayCalendar.umCalendarUid\n               \n               LEFT JOIN School \n               ON School.schoolUid = Clazz.clazzSchoolUid\n               \n               LEFT JOIN CourseTerminology\n               ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n         WHERE Clazz.clazzUid = :uid")
    public abstract java.lang.Object findByUidWithHolidayCalendarAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ClazzWithHolidayCalendarAndSchoolAndTerminology> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Clazz entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Clazz WHERE clazzSchoolUid = :schoolUid AND CAST(isClazzActive AS INTEGER) = 1 ")
    public abstract java.lang.Object findAllClazzesBySchool(long schoolUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.Clazz>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Clazz WHERE clazzSchoolUid = :schoolUid AND CAST(isClazzActive AS INTEGER) = 1 ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.Clazz> findAllClazzesBySchoolLive(long schoolUid);
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.QueryLiveTables(value = {"Clazz", "ClazzEnrolment", "ScopedGrant", "PersonGroupMember", "CourseTerminology"})
    @androidx.room.Query(value = "\n        SELECT Clazz.*, ClazzEnrolment.*,\n               (SELECT COUNT(*) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1000 \n                   AND :currentTime BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,\n               (SELECT COUNT(*) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1001\n                   AND :currentTime BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,\n               \'\' AS teacherNames,\n               0 AS lastRecorded,\n               CourseTerminology.*\n          FROM PersonGroupMember\n               \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    :permission\n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                  \n               LEFT JOIN ClazzEnrolment \n                    ON ClazzEnrolment.clazzEnrolmentUid =\n                       COALESCE(\n                       (SELECT ClazzEnrolment.clazzEnrolmentUid \n                          FROM ClazzEnrolment\n                         WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                           AND ClazzEnrolment.clazzEnrolmentActive\n                           AND ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid LIMIT 1), 0)\n                LEFT JOIN CourseTerminology   \n                ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid           \n\n         WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid\n           AND PersonGroupMember.groupMemberActive \n           AND CAST(Clazz.isClazzActive AS INTEGER) = 1\n           AND Clazz.clazzName like :searchQuery\n           AND (Clazz.clazzUid NOT IN (:excludeSelectedClazzList))\n           AND ( :excludeSchoolUid = 0 OR Clazz.clazzUid NOT IN (SELECT cl.clazzUid FROM Clazz AS cl WHERE cl.clazzSchoolUid = :excludeSchoolUid) ) \n           AND ( :excludeSchoolUid = 0 OR Clazz.clazzSchoolUid = 0 )\n           AND ( :filter = 0 OR (CASE WHEN :filter = 5 \n                                      THEN :currentTime BETWEEN Clazz.clazzStartTime AND Clazz.clazzEndTime\n                                      ELSE :currentTime > Clazz.clazzEndTime \n                                      END))\n           AND ( :selectedSchool = 0 OR Clazz.clazzSchoolUid = :selectedSchool)\n      GROUP BY Clazz.clazzUid, ClazzEnrolment.clazzEnrolmentUid, CourseTerminology.ctUid\n      ORDER BY CASE :sortOrder\n               WHEN 3 THEN Clazz.attendanceAverage\n               ELSE 0\n               END ASC,\n               CASE :sortOrder\n               WHEN 1 THEN Clazz.clazzName\n               ELSE \'\'\n               END ASC,\n               CASE :sortOrder\n               WHEN 4 THEN Clazz.attendanceAverage\n               ELSE 0\n               END DESC,\n               CASE :sortOrder\n               WHEN 2 THEN clazz.Clazzname\n               ELSE \'\'\n               END DESC\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ClazzWithListDisplayDetails> findClazzesWithPermission(@org.jetbrains.annotations.NotNull()
    java.lang.String searchQuery, long accountPersonUid, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> excludeSelectedClazzList, long excludeSchoolUid, int sortOrder, int filter, long currentTime, long permission, long selectedSchool);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT Clazz.clazzUid AS uid, Clazz.clazzName AS labelName From Clazz WHERE clazzUid IN (:ids)")
    public abstract java.lang.Object getClassNamesFromListOfIds(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> ids, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.UidAndLabel>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Clazz WHERE clazzName = :name and CAST(isClazzActive AS INTEGER) = 1")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Clazz> findByClazzName(@org.jetbrains.annotations.NotNull()
    java.lang.String name);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.PostgresQuery(value = "\n        UPDATE Clazz \n           SET attendanceAverage = \n               COALESCE(CAST(\n                    (SELECT SUM(clazzLogNumPresent) \n                       FROM ClazzLog \n                      WHERE clazzLogClazzUid = :clazzUid\n                       AND clazzLogStatusFlag = 4) AS REAL) /\n                    \n                    CAST(GREATEST(1.0, \n                        (SELECT SUM(clazzLogNumPresent) + SUM(clazzLogNumPartial) + SUM(clazzLogNumAbsent)\n                        FROM ClazzLog \n                       WHERE clazzLogClazzUid = :clazzUid \n                        AND clazzLogStatusFlag = 4)) AS REAL), 0),\n               clazzLct = :timeChanged         \n         WHERE clazzUid = :clazzUid\n    ")
    @androidx.room.Query(value = "\n        UPDATE Clazz \n           SET attendanceAverage = \n               COALESCE(CAST(\n                    (SELECT SUM(clazzLogNumPresent) \n                       FROM ClazzLog \n                      WHERE clazzLogClazzUid = :clazzUid\n                       AND clazzLogStatusFlag = 4) AS REAL) /\n                    \n                    CAST(MAX(1.0, \n                        (SELECT SUM(clazzLogNumPresent) + SUM(clazzLogNumPartial) + SUM(clazzLogNumAbsent)\n                        FROM ClazzLog \n                       WHERE clazzLogClazzUid = :clazzUid \n                        AND clazzLogStatusFlag = 4)) AS REAL), 0),\n               clazzLct = :timeChanged         \n         WHERE clazzUid = :clazzUid\n    ")
    public abstract java.lang.Object updateClazzAttendanceAverageAsync(long clazzUid, long timeChanged, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    /**
     * Check if a permission is present on a specific entity e.g. updateState/modify etc
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT EXISTS( \n               SELECT PrsGrpMbr.groupMemberPersonUid\n                  FROM Clazz\n                       \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                          :permission\n                          \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n        \n                 WHERE Clazz.clazzUid = :clazzUid\n                   AND PrsGrpMbr.groupMemberPersonUid = :accountPersonUid)\n    ")
    public abstract java.lang.Object personHasPermissionWithClazz(long accountPersonUid, long clazzUid, long permission, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ScopedGrant.sgPermissions\n          FROM Clazz\n               JOIN ScopedGrant\n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n               JOIN PersonGroupMember AS PrsGrpMbr\n                    ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n         WHERE Clazz.clazzUid = :clazzUid\n           AND (ScopedGrant.sgPermissions & 4294967296) > 0\n           AND PrsGrpMbr.groupMemberPersonUid = :accountPersonUid\n    ")
    public abstract java.lang.Object selectDelegatablePermissions(long accountPersonUid, long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.Long>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT Clazz.*, \n               HolidayCalendar.*, \n               School.*,\n               (SELECT COUNT(*) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1000 \n                   AND :currentTime BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                        AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numStudents,\n               (SELECT COUNT(*) \n                  FROM ClazzEnrolment \n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n                   AND clazzEnrolmentRole = 1001 \n                   AND :currentTime BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                       AND ClazzEnrolment.clazzEnrolmentDateLeft) AS numTeachers,\n                CourseTerminology.*      \n         FROM Clazz \n              LEFT JOIN HolidayCalendar \n              ON Clazz.clazzHolidayUMCalendarUid = HolidayCalendar.umCalendarUid\n              LEFT JOIN School \n              ON School.schoolUid = Clazz.clazzSchoolUid\n              LEFT JOIN CourseTerminology\n              ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n        WHERE Clazz.clazzUid = :clazzUid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ClazzWithDisplayDetails> getClazzWithDisplayDetails(long clazzUid, long currentTime);
    
    /**
     * Used for scheduling purposes - get a list of classes with the applicable holiday calendar.
     * This might be the holiday calendar specifeid by the class (if any) or the the calendar
     * specified for the associated school.
     */
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT Clazz.*, \n               HolidayCalendar.*, \n               School.*,\n               CourseTerminology.*\n         FROM Clazz \n              LEFT JOIN HolidayCalendar \n              ON ((clazz.clazzHolidayUMCalendarUid != 0 \n                AND HolidayCalendar.umCalendarUid = clazz.clazzHolidayUMCalendarUid)\n                OR clazz.clazzHolidayUMCalendarUid = 0 AND clazz.clazzSchoolUid = 0 \n                AND HolidayCalendar.umCalendarUid = (SELECT schoolHolidayCalendarUid \n                                                       FROM School \n                                                      WHERE schoolUid = clazz.clazzSchoolUid))\n              LEFT JOIN School \n              ON School.schoolUid = Clazz.clazzSchoolUid\n              \n              LEFT JOIN CourseTerminology\n              ON CourseTerminology.ctUid = Clazz.clazzTerminologyUid\n                \n        WHERE :filterUid = 0 \n           OR Clazz.clazzUid = :filterUid\n    ")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ClazzWithHolidayCalendarAndSchoolAndTerminology> findClazzesWithEffectiveHolidayCalendarAndFilter(long filterUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT Clazz.*, School.* FROM Clazz LEFT JOIN School ON School.schoolUid = Clazz.clazzSchoolUid WHERE clazz.clazzUid = :clazzUid")
    public abstract java.lang.Object getClazzWithSchool(long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ClazzWithSchool> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzDao$Companion;", "", "()V", "FILTER_ACTIVE_ONLY", "", "FILTER_CURRENTLY_ENROLLED", "FILTER_PAST_ENROLLMENTS", "SELECT_ACTIVE_CLAZZES", "", "SORT_ATTENDANCE_ASC", "SORT_ATTENDANCE_DESC", "SORT_CLAZZNAME_ASC", "SORT_CLAZZNAME_DESC", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}