package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0011\b\'\u0018\u0000 J2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001JB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\tH\'J\u001f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000f0\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\'JP\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00120\u00052\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\'J#\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\tH\'J\u001b\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ)\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J9\u0010\'\u001a\b\u0012\u0004\u0012\u00020(0\u000b2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u00062\b\b\u0002\u0010+\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\'J\u0011\u00100\u001a\u00020.H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u001b\u00102\u001a\u00020.2\b\b\u0001\u00103\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0019\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J \u00107\u001a\u00020\u00062\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\tH\'J9\u0010<\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J9\u0010@\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\u00062\u0006\u0010C\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010DJ\'\u0010E\u001a\u00020.2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010G\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010HJ)\u0010I\u001a\u00020.2\u0006\u00108\u001a\u00020\t2\u0006\u0010G\u001a\u00020\t2\u0006\u0010C\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006K"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzEnrolmentDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolment;", "()V", "findAllClazzesByPersonWithClazz", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolmentWithClazzAndAttendance;", "personUid", "", "findAllClazzesByPersonWithClazzAsListAsync", "", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolmentWithClazz;", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllEnrolmentsByPersonAndClazzUid", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolmentWithLeavingReason;", "clazzUid", "findByClazzUidAndRole", "Lcom/ustadmobile/lib/db/entities/PersonWithClazzEnrolmentDetails;", "roleId", "sortOrder", "searchText", "", "filter", "accountPersonUid", "currentTime", "findByPersonUidAndClazzUidAsync", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUid", "uid", "findByUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "findEnrolmentWithLeavingReason", "enrolmentUid", "findMaxEndDateForEnrolment", "selectedClazz", "selectedPerson", "selectedEnrolment", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllClazzEnrolledAtTimeAsync", "Lcom/ustadmobile/lib/db/entities/ClazzEnrolmentWithPerson;", "date", "roleFilter", "personUidFilter", "(JJIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertListAsync", "", "entityList", "replicateClazzEnrolmentOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/ClazzEnrolment;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateClazzEnrolmentActiveForClazzEnrolment", "clazzEnrolmentUid", "enrolled", "", "timeChanged", "updateClazzEnrolmentActiveForPersonAndClazz", "active", "changeTime", "(JJIZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateClazzEnrolmentRole", "newRole", "oldRole", "updateTime", "(JJIIJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateDateLeft", "clazzEnrolmentUidList", "endDate", "(Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateDateLeftByUid", "Companion", "lib-database"})
public abstract class ClazzEnrolmentDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ClazzEnrolment> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ClazzEnrolmentDao.Companion Companion = null;
    public static final int SORT_FIRST_NAME_ASC = 1;
    public static final int SORT_FIRST_NAME_DESC = 2;
    public static final int SORT_LAST_NAME_ASC = 3;
    public static final int SORT_LAST_NAME_DESC = 4;
    public static final int SORT_ATTENDANCE_ASC = 5;
    public static final int SORT_ATTENDANCE_DESC = 6;
    public static final int SORT_DATE_REGISTERED_ASC = 7;
    public static final int SORT_DATE_REGISTERED_DESC = 8;
    public static final int SORT_DATE_LEFT_ASC = 9;
    public static final int SORT_DATE_LEFT_DESC = 10;
    public static final int FILTER_ACTIVE_ONLY = 1;
    
    public ClazzEnrolmentDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ClazzEnrolmentReplicate(cePk, ceDestination)\n      SELECT DISTINCT ClazzEnrolment.clazzEnrolmentUid AS ceUid,\n             :newNodeId AS ceDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                   ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    64 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n         \n             JOIN ClazzEnrolment \n                   ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND ClazzEnrolment.clazzEnrolmentLct != COALESCE(\n             (SELECT ceVersionId\n                FROM ClazzEnrolmentReplicate\n               WHERE cePk = ClazzEnrolment.clazzEnrolmentUid\n                 AND ceDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(cePk, ceDestination) DO UPDATE\n             SET cePending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzEnrolment.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ClazzEnrolmentReplicate(cePk, ceDestination)\n  SELECT DISTINCT ClazzEnrolment.clazzEnrolmentUid AS ceUid,\n         UserSession.usClientNodeId AS ceDestination\n    FROM ChangeLog\n         JOIN ClazzEnrolment\n             ON ChangeLog.chTableId = 65\n                AND ChangeLog.chEntityPk = ClazzEnrolment.clazzEnrolmentUid\n         JOIN Clazz\n             ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n             2\n             \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ClazzEnrolment.clazzEnrolmentLct != COALESCE(\n         (SELECT ceVersionId\n            FROM ClazzEnrolmentReplicate\n           WHERE cePk = ClazzEnrolment.clazzEnrolmentUid\n             AND ceDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(cePk, ceDestination) DO UPDATE\n     SET cePending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzEnrolment.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ClazzEnrolment.class})
    public abstract java.lang.Object replicateClazzEnrolmentOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    /**
     * Note: When actually enroling into a class, use UmAppDatbaseExt#processEnrolmentIntoClass
     * to ensure that permissions, group membership, etc. are taken care of
     */
    @androidx.room.Insert()
    public abstract void insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ClazzEnrolment> entityList);
    
    @org.jetbrains.annotations.Nullable()
    public java.lang.Object updateDateLeft(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> clazzEnrolmentUidList, long endDate, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentPersonUid = :personUid \n        AND clazzEnrolmentClazzUid = :clazzUid \n        AND clazzEnrolmentOutcome = 200 LIMIT 1")
    public abstract java.lang.Object findByPersonUidAndClazzUidAsync(long personUid, long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ClazzEnrolment> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ClazzEnrolment.*, LeavingReason.*, \n         COALESCE(Clazz.clazzTimeZone, COALESCE(School.schoolTimeZone, \'UTC\')) as timeZone\n         FROM ClazzEnrolment LEFT JOIN\n        LeavingReason ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n        LEFT JOIN Clazz ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n        LEFT JOIN School ON School.schoolUid = Clazz.clazzSchoolUid\n        WHERE clazzEnrolmentPersonUid = :personUid \n        AND ClazzEnrolment.clazzEnrolmentActive \n        AND clazzEnrolmentClazzUid = :clazzUid ORDER BY clazzEnrolmentDateLeft DESC")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ClazzEnrolmentWithLeavingReason> findAllEnrolmentsByPersonAndClazzUid(long personUid, long clazzUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ClazzEnrolment.*, LeavingReason.*,\n         COALESCE(Clazz.clazzTimeZone, COALESCE(School.schoolTimeZone, \'UTC\')) as timeZone\n         FROM ClazzEnrolment LEFT JOIN\n        LeavingReason ON LeavingReason.leavingReasonUid = ClazzEnrolment.clazzEnrolmentLeavingReasonUid\n        LEFT JOIN Clazz ON Clazz.clazzUid = ClazzEnrolment.clazzEnrolmentClazzUid\n        LEFT JOIN School ON School.schoolUid = Clazz.clazzSchoolUid\n        WHERE ClazzEnrolment.clazzEnrolmentUid = :enrolmentUid")
    public abstract java.lang.Object findEnrolmentWithLeavingReason(long enrolmentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ClazzEnrolmentWithLeavingReason> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ClazzEnrolment \n          SET clazzEnrolmentDateLeft = :endDate,\n              clazzEnrolmentLct = :updateTime\n        WHERE clazzEnrolmentUid = :clazzEnrolmentUid")
    public abstract java.lang.Object updateDateLeftByUid(long clazzEnrolmentUid, long endDate, long updateTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ClazzEnrolment entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    /**
     * Provide a list of the classes a given person is in with the class information itself (e.g.
     * for person detail).
     *
     * @param personUid
     * @param date If this is not 0, then the query will ensure that the registration is current at
     * the given
     */
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.PostgresQuery(value = "SELECT ClazzEnrolment.*, Clazz.*, (SELECT ((CAST(COUNT(DISTINCT CASE WHEN \n        ClazzLogAttendanceRecord.attendanceStatus = 1 THEN \n        ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid ELSE NULL END) AS REAL) / \n        GREATEST(COUNT(ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid),1)) * 100) \n        FROM ClazzLogAttendanceRecord LEFT JOIN ClazzLog ON \n        ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzLogUid = ClazzLog.clazzLogUid WHERE \n        ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = :personUid \n        AND ClazzLog.clazzLogClazzUid = Clazz.clazzUid AND ClazzLog.logDate \n        BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) \n        as attendance\n        FROM ClazzEnrolment\n        LEFT JOIN Clazz ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid\n        WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :personUid\n        AND ClazzEnrolment.clazzEnrolmentActive\n        ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n    ")
    @androidx.room.Query(value = "SELECT ClazzEnrolment.*, Clazz.*, (SELECT ((CAST(COUNT(DISTINCT CASE WHEN \n        ClazzLogAttendanceRecord.attendanceStatus = 1 THEN \n        ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid ELSE NULL END) AS REAL) / \n        MAX(COUNT(ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid),1)) * 100) \n        FROM ClazzLogAttendanceRecord LEFT JOIN ClazzLog ON \n        ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzLogUid = ClazzLog.clazzLogUid WHERE \n        ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = :personUid \n        AND ClazzLog.clazzLogClazzUid = Clazz.clazzUid AND ClazzLog.logDate \n        BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined AND ClazzEnrolment.clazzEnrolmentDateLeft) \n        as attendance\n        FROM ClazzEnrolment\n        LEFT JOIN Clazz ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid\n        WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :personUid\n        AND ClazzEnrolment.clazzEnrolmentActive\n        ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ClazzEnrolmentWithClazzAndAttendance> findAllClazzesByPersonWithClazz(long personUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT COALESCE(MAX(clazzEnrolmentDateLeft),0) FROM ClazzEnrolment WHERE \n        ClazzEnrolment.clazzEnrolmentPersonUid = :selectedPerson \n        AND ClazzEnrolment.clazzEnrolmentActive \n        AND clazzEnrolmentClazzUid = :selectedClazz AND clazzEnrolmentUid != :selectedEnrolment\n    ")
    public abstract java.lang.Object findMaxEndDateForEnrolment(long selectedClazz, long selectedPerson, long selectedEnrolment, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ClazzEnrolment.*, Clazz.* \n        FROM ClazzEnrolment \n        LEFT JOIN Clazz ON ClazzEnrolment.clazzEnrolmentClazzUid = Clazz.clazzUid \n        WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :personUid \n        AND ClazzEnrolment.clazzEnrolmentActive\n        ORDER BY ClazzEnrolment.clazzEnrolmentDateLeft DESC\n    ")
    public abstract java.lang.Object findAllClazzesByPersonWithClazzAsListAsync(long personUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.ClazzEnrolmentWithClazz>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ClazzEnrolment.*, Person.*\n          FROM ClazzEnrolment\n    LEFT JOIN Person ON ClazzEnrolment.clazzEnrolmentPersonUid = Person.personUid\n        WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n              AND :date BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n              AND ClazzEnrolment.clazzEnrolmentDateLeft\n              AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n              AND (:roleFilter = 0 OR ClazzEnrolment.clazzEnrolmentRole = :roleFilter)\n              AND (:personUidFilter = 0 OR ClazzEnrolment.clazzEnrolmentPersonUid = :personUidFilter)\n    ")
    public abstract java.lang.Object getAllClazzEnrolledAtTimeAsync(long clazzUid, long date, int roleFilter, long personUidFilter, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ClazzEnrolmentWithPerson>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = :uid")
    public abstract java.lang.Object findByUid(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ClazzEnrolment> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM ClazzEnrolment WHERE clazzEnrolmentUid = :uid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ClazzEnrolment> findByUidLive(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n                UPDATE ClazzEnrolment\n                   SET clazzEnrolmentActive = :active,\n                       clazzEnrolmentLct= :changeTime\n                WHERE clazzEnrolmentPersonUid = :personUid \n                      AND clazzEnrolmentClazzUid = :clazzUid\n                      AND clazzEnrolmentRole = :roleId")
    public abstract java.lang.Object updateClazzEnrolmentActiveForPersonAndClazz(long personUid, long clazzUid, int roleId, boolean active, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.SqliteOnly()
    @com.ustadmobile.door.annotation.QueryLiveTables(value = {"Clazz", "Person", "ClazzEnrolment", "PersonGroupMember", "ScopedGrant"})
    @androidx.room.Query(value = "\n        SELECT Person.*, \n               (SELECT ((CAST(COUNT(DISTINCT \n                        CASE WHEN ClazzLogAttendanceRecord.attendanceStatus = 1 \n                                  THEN ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid \n                             ELSE NULL \n                             END) \n                        AS REAL) / \n                        MAX(COUNT(ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid),1)) * 100) \n                   FROM ClazzLogAttendanceRecord \n                        JOIN ClazzLog \n                             ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzLogUid = ClazzLog.clazzLogUid \n                  WHERE ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = Person.personUid \n                    AND ClazzLog.clazzLogClazzUid = :clazzUid)  AS attendance, \n        \n    \t       (SELECT MIN(ClazzEnrolment.clazzEnrolmentDateJoined) \n                  FROM ClazzEnrolment \n                 WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS earliestJoinDate, \n        \n    \t      (SELECT MAX(ClazzEnrolment.clazzEnrolmentDateLeft) \n                 FROM ClazzEnrolment \n                WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid) AS latestDateLeft, \n        \n              (SELECT clazzEnrolmentRole \n                 FROM clazzEnrolment \n                WHERE Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid \n                  AND ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n        AND ClazzEnrolment.clazzEnrolmentActive) AS enrolmentRole\n        FROM PersonGroupMember\n        \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions & 64 \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n         \n        \n         WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid\n           AND PersonGroupMember.groupMemberActive \n           AND Person.personUid IN (SELECT clazzEnrolmentPersonUid \n                                      FROM ClazzEnrolment \n                                     WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid \n                                       AND ClazzEnrolment.clazzEnrolmentActive \n                                       AND ClazzEnrolment.clazzEnrolmentRole = :roleId \n                                       AND (:filter != 1 \n                                        OR (:currentTime \n                                            BETWEEN ClazzEnrolment.clazzEnrolmentDateJoined \n                                            AND ClazzEnrolment.clazzEnrolmentDateLeft))) \n          AND Person.firstNames || \' \' || Person.lastName LIKE :searchText\n     GROUP BY Person.personUid\n     ORDER BY CASE(:sortOrder)\n                WHEN 1 THEN Person.firstNames\n                WHEN 3 THEN Person.lastName\n                ELSE \'\'\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 2 THEN Person.firstNames\n                WHEN 4 THEN Person.lastName\n                ELSE \'\'\n            END DESC,\n            CASE(:sortOrder)\n                WHEN 5 THEN attendance\n                WHEN 7 THEN earliestJoinDate\n                WHEN 9 THEN latestDateLeft\n                ELSE 0\n            END ASC,\n            CASE(:sortOrder)\n                WHEN 6 THEN attendance\n                WHEN 8 THEN earliestJoinDate\n                WHEN 10 THEN latestDateLeft\n                ELSE 0\n            END DESC\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.PersonWithClazzEnrolmentDetails> findByClazzUidAndRole(long clazzUid, int roleId, int sortOrder, @org.jetbrains.annotations.Nullable()
    java.lang.String searchText, int filter, long accountPersonUid, long currentTime);
    
    @androidx.room.Query(value = "\n        UPDATE ClazzEnrolment \n          SET clazzEnrolmentActive = :enrolled,\n              clazzEnrolmentLct = :timeChanged\n        WHERE clazzEnrolmentUid = :clazzEnrolmentUid")
    public abstract int updateClazzEnrolmentActiveForClazzEnrolment(long clazzEnrolmentUid, boolean enrolled, long timeChanged);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n            UPDATE ClazzEnrolment \n               SET clazzEnrolmentRole = :newRole,\n                   clazzEnrolmentLct = :updateTime      \n             -- Avoid potential for duplicate approvals if user was previously refused      \n             WHERE clazzEnrolmentUid = COALESCE( \n                    (SELECT clazzEnrolmentUid\n                       FROM ClazzEnrolment\n                      WHERE clazzEnrolmentPersonUid = :personUid \n                            AND clazzEnrolmentClazzUid = :clazzUid\n                            AND clazzEnrolmentRole = :oldRole\n                            AND CAST(clazzEnrolmentActive AS INTEGER) = 1\n                      LIMIT 1), 0)")
    public abstract java.lang.Object updateClazzEnrolmentRole(long personUid, long clazzUid, int newRole, int oldRole, long updateTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzEnrolmentDao$Companion;", "", "()V", "FILTER_ACTIVE_ONLY", "", "SORT_ATTENDANCE_ASC", "SORT_ATTENDANCE_DESC", "SORT_DATE_LEFT_ASC", "SORT_DATE_LEFT_DESC", "SORT_DATE_REGISTERED_ASC", "SORT_DATE_REGISTERED_DESC", "SORT_FIRST_NAME_ASC", "SORT_FIRST_NAME_DESC", "SORT_LAST_NAME_ASC", "SORT_LAST_NAME_DESC", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}