package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\bH\'J\u001f\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\r2\b\b\u0001\u0010\u0013\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\u0014\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzLogAttendanceRecordDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ClazzLogAttendanceRecord;", "()V", "findByClazzLogUid", "", "Lcom/ustadmobile/lib/db/entities/ClazzLogAttendanceRecordWithPerson;", "clazzLogUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUid", "uid", "insertListAsync", "", "entities", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateListAsync", "updateRescheduledClazzLogUids", "oldClazzLogUid", "newClazzLogUid", "changedTime", "lib-database"})
public abstract class ClazzLogAttendanceRecordDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord> {
    
    public ClazzLogAttendanceRecordDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ClazzLogAttendanceRecordReplicate(clarPk, clarDestination)\n      SELECT DISTINCT ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid AS clarUid,\n             :newNodeId AS clarDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                  2048 \n                  \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n             JOIN ClazzLog\n                  ON ClazzLog.clazzLogClazzUid = Clazz.clazzUid\n             JOIN ClazzLogAttendanceRecord \n                  ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzLogUid = ClazzLog.clazzLogUid\n       WHERE ClazzLogAttendanceRecord.clazzLogAttendanceRecordLastChangedTime != COALESCE(\n             (SELECT clarVersionId\n                FROM ClazzLogAttendanceRecordReplicate\n               WHERE clarPk = ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid\n                 AND clarDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(clarPk, clarDestination) DO UPDATE\n             SET clarPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ClazzLogAttendanceRecordReplicate(clarPk, clarDestination)\n  SELECT DISTINCT ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid AS clarUid,\n         UserSession.usClientNodeId AS clarDestination\n    FROM ChangeLog\n         JOIN ClazzLogAttendanceRecord \n              ON ChangeLog.chTableId = 15 \n             AND ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid = ChangeLog.chEntityPk\n         JOIN ClazzLog\n              ON ClazzLog.clazzLogUid = ClazzLogAttendanceRecord.clazzLogAttendanceRecordClazzLogUid\n         JOIN Clazz \n              ON Clazz.clazzUid = ClazzLog.clazzLogClazzUid \n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              2\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ClazzLogAttendanceRecord.clazzLogAttendanceRecordLastChangedTime != COALESCE(\n             (SELECT clarVersionId\n                FROM ClazzLogAttendanceRecordReplicate\n               WHERE clarPk = ClazzLogAttendanceRecord.clazzLogAttendanceRecordUid\n                 AND clarDestination = UserSession.usClientNodeId), 0) \n /*psql ON CONFLICT(clarPk, clarDestination) DO UPDATE\n     SET clarPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord> entities, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * from ClazzLogAttendanceRecord WHERE clazzLogAttendanceRecordUid = :uid")
    public abstract com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord findByUid(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecord> entities, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ClazzLogAttendanceRecord.*, Person.*\n         FROM ClazzLogAttendanceRecord \n         LEFT JOIN Person ON ClazzLogAttendanceRecord.clazzLogAttendanceRecordPersonUid = Person.personUid\n         WHERE clazzLogAttendanceRecordClazzLogUid = :clazzLogUid")
    public abstract java.lang.Object findByClazzLogUid(long clazzLogUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ClazzLogAttendanceRecordWithPerson>> continuation);
    
    @androidx.room.Query(value = "\n        UPDATE ClazzLogAttendanceRecord\n           SET clazzLogAttendanceRecordClazzLogUid = :newClazzLogUid,\n               clazzLogAttendanceRecordLastChangedTime = :changedTime\n        WHERE clazzLogAttendanceRecordClazzLogUid = :oldClazzLogUid\n    ")
    public abstract void updateRescheduledClazzLogUids(long oldClazzLogUid, long newClazzLogUid, long changedTime);
}