package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u000b\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\'J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\'J\'\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J:\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0014\u001a\u00020\nH\'J?\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J4\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\nH\'J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\bH\'J\u001b\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\u001a\u001a\u00020\bH\'J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0002H\'J\u0011\u0010 \u001a\u00020!H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\u00020!2\b\b\u0001\u0010$\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0019\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\'J \u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\bH\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2 = {"Lcom/ustadmobile/core/db/dao/ClazzLogDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ClazzLog;", "()V", "clazzHasScheduleLive", "Lcom/ustadmobile/door/DoorLiveData;", "", "clazzUid", "", "excludeStatusFilter", "", "findByClazzUidAsFactory", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "excludeStatus", "findByClazzUidAsync", "", "(JILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByClazzUidWithinTimeRange", "fromTime", "toTime", "limit", "findByClazzUidWithinTimeRangeAsync", "(JJJIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByClazzUidWithinTimeRangeLive", "statusFilter", "findByUid", "uid", "findByUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidLive", "replace", "entity", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "clazzLog", "(Lcom/ustadmobile/lib/db/entities/ClazzLog;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateStatusByClazzLogUid", "clazzLogUid", "newStatus", "timeChanged", "lib-database"})
public abstract class ClazzLogDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ClazzLog> {
    
    public ClazzLogDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ClazzLogReplicate(clPk, clDestination)\n      SELECT DISTINCT ClazzLog.clazzLogUid AS clUid,\n             :newNodeId AS clDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                  2 \n                  \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n             JOIN ClazzLog\n                  ON ClazzLog.clazzLogClazzUid = Clazz.clazzUid\n       WHERE ClazzLog.clazzLogLastChangedTime != COALESCE(\n             (SELECT clVersionId\n                FROM ClazzLogReplicate\n               WHERE clPk = ClazzLog.clazzLogUid\n                 AND clDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(clPk, clDestination) DO UPDATE\n             SET clPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzLog.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract long replace(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ClazzLog entity);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ClazzLogReplicate(clPk, clDestination)\n  SELECT DISTINCT ClazzLog.clazzLogUid AS clUid,\n         UserSession.usClientNodeId AS clDestination\n    FROM ChangeLog\n         JOIN ClazzLog \n              ON ChangeLog.chTableId = 14 \n             AND ClazzLog.clazzLogUid = ChangeLog.chEntityPk\n         JOIN Clazz \n              ON Clazz.clazzUid = ClazzLog.clazzLogClazzUid \n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              2\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ClazzLog.clazzLogLastChangedTime != COALESCE(\n         (SELECT clVersionId\n            FROM ClazzLogReplicate\n           WHERE clPk = ClazzLog.clazzLogUid\n             AND clDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(clPk, clDestination) DO UPDATE\n     SET clPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ClazzLog.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ClazzLog.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ClazzLog WHERE clazzLogUid = :uid")
    public abstract com.ustadmobile.lib.db.entities.ClazzLog findByUid(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ClazzLog WHERE clazzLogUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ClazzLog> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM ClazzLog WHERE clazzLogUid = :uid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ClazzLog> findByUidLive(long uid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ClazzLog.* FROM ClazzLog \n        WHERE clazzLogClazzUid = :clazzUid\n        AND clazzLog.clazzLogStatusFlag != :excludeStatus\n        ORDER BY ClazzLog.logDate DESC")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ClazzLog> findByClazzUidAsFactory(long clazzUid, int excludeStatus);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ClazzLog.* FROM ClazzLog \n        WHERE clazzLogClazzUid = :clazzUid\n        AND clazzLog.clazzLogStatusFlag != :excludeStatus\n        ORDER BY ClazzLog.logDate ASC")
    public abstract java.lang.Object findByClazzUidAsync(long clazzUid, int excludeStatus, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.ClazzLog>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ClazzLog.* FROM ClazzLog \n        WHERE \n        ClazzLog.clazzLogClazzUid = :clazzUid \n        AND ClazzLog.logDate BETWEEN :fromTime AND :toTime\n        AND (:excludeStatusFilter = 0 OR ((ClazzLog.clazzLogStatusFlag & :excludeStatusFilter) = 0))\n        ORDER BY ClazzLog.logDate DESC\n        LIMIT :limit\n    ")
    public abstract java.lang.Object findByClazzUidWithinTimeRangeAsync(long clazzUid, long fromTime, long toTime, int excludeStatusFilter, int limit, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.ClazzLog>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ClazzLog.* FROM ClazzLog \n        WHERE \n        ClazzLog.clazzLogClazzUid = :clazzUid \n        AND ClazzLog.logDate BETWEEN :fromTime AND :toTime\n        AND (:excludeStatusFilter = 0 OR ((ClazzLog.clazzLogStatusFlag & :excludeStatusFilter) = 0))\n        ORDER BY ClazzLog.logDate DESC\n        LIMIT :limit\n    ")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ClazzLog> findByClazzUidWithinTimeRange(long clazzUid, long fromTime, long toTime, int excludeStatusFilter, int limit);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ClazzLog.* FROM ClazzLog \n        WHERE \n        ClazzLog.clazzLogClazzUid = :clazzUid \n        AND ClazzLog.logDate BETWEEN :fromTime AND :toTime\n        AND (:statusFilter = 0 OR ClazzLog.clazzLogStatusFlag = :statusFilter)\n        ORDER BY ClazzLog.logDate\n    ")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.ClazzLog>> findByClazzUidWithinTimeRangeLive(long clazzUid, long fromTime, long toTime, int statusFilter);
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.QueryLiveTables(value = {"ClazzLog"})
    @androidx.room.Query(value = "\n        SELECT EXISTS(SELECT ClazzLog.clazzLogUid FROM ClazzLog WHERE clazzLogClazzUid = :clazzUid \n        AND (:excludeStatusFilter = 0 OR ((ClazzLog.clazzLogStatusFlag & :excludeStatusFilter) = 0)))\n    ")
    public abstract com.ustadmobile.door.DoorLiveData<java.lang.Boolean> clazzHasScheduleLive(long clazzUid, int excludeStatusFilter);
    
    @androidx.room.Query(value = "UPDATE ClazzLog \n        SET clazzLogStatusFlag = :newStatus,\n        clazzLogLastChangedTime = :timeChanged\n        WHERE clazzLogUid = :clazzLogUid")
    public abstract void updateStatusByClazzLogUid(long clazzLogUid, int newStatus, long timeChanged);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ClazzLog clazzLog, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}