package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\'\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\tH\'J,\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\'J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\tH\'J,\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\'J,\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\'J.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\'J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\tH\'J\u0011\u0010\u001d\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001f\u001a\u00020\u00062\b\b\u0001\u0010 \u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010!J)\u0010\"\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\t2\u0006\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2 = {"Lcom/ustadmobile/core/db/dao/CommentsDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Comments;", "Lcom/ustadmobile/core/db/dao/OneToManyJoinDao;", "()V", "deactivateByUids", "", "uidList", "", "", "changeTime", "(Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidAsync", "uid", "findPrivateByEntityTypeAndUidAndForPersonLive", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/CommentsWithPerson;", "entityType", "entityUid", "personUid", "findPrivateByEntityTypeAndUidAndForPersonLive2", "submitterUid", "findPrivateByEntityTypeAndUidAndPersonLive", "findPrivateCommentsByEntityTypeAndUidAndPersonAndPersonToLive", "personFrom", "findPrivateCommentsByEntityTypeAndUidAndPersonAndPersonToTest", "personTo", "findPublicByEntityTypeAndUidLive", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateInActiveByCommentUid", "inActive", "", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class CommentsDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.Comments>, com.ustadmobile.core.db.dao.OneToManyJoinDao<com.ustadmobile.lib.db.entities.Comments> {
    
    public CommentsDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO CommentsReplicate(commentsPk, commentsDestination)\n      SELECT DISTINCT Comments.commentsUid AS commentsPk,\n             :newNodeId AS commentsDestination\n        FROM Comments\n       WHERE Comments.commentsLct != COALESCE(\n             (SELECT commentsVersionId\n                FROM CommentsReplicate\n               WHERE commentsPk = Comments.commentsUid\n                 AND commentsDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(commentsPk, commentsDestination) DO UPDATE\n             SET commentsPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Comments.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n     REPLACE INTO CommentsReplicate(commentsPk, commentsDestination)\n      SELECT DISTINCT Comments.commentsUid AS commentsPk,\n             UserSession.usClientNodeId AS commentsDestination\n        FROM ChangeLog\n             JOIN Comments\n                 ON ChangeLog.chTableId = 208\n                    AND ChangeLog.chEntityPk = Comments.commentsUid\n             JOIN UserSession \n                  ON UserSession.usStatus = 1\n       WHERE UserSession.usClientNodeId != (\n             SELECT nodeClientId \n               FROM SyncNode\n              LIMIT 1)\n         AND Comments.commentsLct != COALESCE(\n             (SELECT commentsVersionId\n                FROM CommentsReplicate\n               WHERE commentsPk = Comments.commentsUid\n                 AND commentsDestination = UserSession.usClientNodeId), 0)\n     /*psql ON CONFLICT(commentsPk, commentsDestination) DO UPDATE\n         SET commentsPending = true\n      */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Comments.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.Comments.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Comments WHERE commentsUid = :uid  AND CAST(commentsInActive AS INTEGER) = 0")
    public abstract com.ustadmobile.lib.db.entities.Comments findByUidAsync(long uid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT Comments.*, Person.* \n          FROM Comments\n                LEFT JOIN Person \n                ON Person.personUid = Comments.commentsPersonUid \n         WHERE Comments.commentsEntityType = :entityType \n           AND Comments.commentsEntityUid = :entityUid\n           AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n           AND CAST(Comments.commentsInActive AS INTEGER) = 0\n           AND CAST(Comments.commentsPublic AS INTEGER) = 1\n      ORDER BY Comments.commentsDateTimeAdded DESC \n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.CommentsWithPerson> findPublicByEntityTypeAndUidLive(int entityType, long entityUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT Comments.*, Person.* FROM Comments\n        LEFT JOIN Person ON Person.personUid = Comments.commentsPersonUid \n        WHERE Comments.commentsEntityType = :entityType \n        AND Comments.commentsEntityUid = :entityUid\n        AND Comments.commentsPersonUid = :personUid OR Comments.commentsToPersonUid = :personUid \n        AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n        AND CAST(Comments.commentsInActive AS INTEGER) = 0\n        AND CAST(Comments.commentsPublic AS INTEGER) = 0\n        AND Person.personUid = :personUid\n        ORDER BY Comments.commentsDateTimeAdded DESC \n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.CommentsWithPerson> findPrivateByEntityTypeAndUidAndForPersonLive(int entityType, long entityUid, long personUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n            SELECT Comments.*, \n                   Person.* \n              FROM Comments\n                   LEFT JOIN Person \n                   ON Person.personUid = Comments.commentsPersonUid\n             WHERE Comments.commentsEntityType = :entityType \n               AND Comments.commentsEntityUid = :entityUid\n               AND Comments.commentSubmitterUid = :submitterUid  \n               AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n               AND CAST(Comments.commentsInActive AS INTEGER) = 0\n               AND CAST(Comments.commentsPublic AS INTEGER) = 0\n          ORDER BY Comments.commentsDateTimeAdded DESC \n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.CommentsWithPerson> findPrivateByEntityTypeAndUidAndForPersonLive2(int entityType, long entityUid, long submitterUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT Comments.*, Person.* FROM Comments\n        LEFT JOIN Person ON Person.personUid = Comments.commentsPersonUid \n        WHERE Comments.commentsEntityType = :entityType \n        AND Comments.commentsEntityUid = :entityUid\n        AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n        AND CAST(Comments.commentsInActive AS INTEGER) = 0\n        AND CAST(Comments.commentsPublic AS INTEGER) = 0\n        AND Person.personUid = :personUid\n        ORDER BY Comments.commentsDateTimeAdded DESC \n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.CommentsWithPerson> findPrivateByEntityTypeAndUidAndPersonLive(int entityType, long entityUid, long personUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT Comments.*, Person.* FROM Comments\n        LEFT JOIN Person ON Person.personUid = Comments.commentsPersonUid \n        WHERE Comments.commentsEntityType = :entityType \n        AND Comments.commentsEntityUid = :entityUid\n        AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n        AND CAST(Comments.commentsInActive AS INTEGER) = 0\n        AND CAST(Comments.commentsPublic AS INTEGER) = 0\n        AND (Comments.commentsToPersonUid = :personFrom \n         OR Comments.commentsPersonUid = :personFrom)\n        ORDER BY Comments.commentsDateTimeAdded DESC \n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.CommentsWithPerson> findPrivateCommentsByEntityTypeAndUidAndPersonAndPersonToLive(int entityType, long entityUid, long personFrom);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT Comments.*, Person.* FROM Comments\n        LEFT JOIN Person ON Person.personUid = Comments.commentsPersonUid \n        WHERE Comments.commentsEntityType = :entityType \n        AND Comments.commentsEntityUid = :entityUid\n        AND CAST(Comments.commentsFlagged AS INTEGER) = 0\n        AND CAST(Comments.commentsInActive AS INTEGER) = 0\n        AND CAST(Comments.commentsPublic AS INTEGER) = 0\n        AND Comments.commentsPersonUid = :personFrom \n        OR (:personTo = 0 OR Comments.commentsToPersonUid = :personFrom)\n        ORDER BY Comments.commentsDateTimeAdded DESC \n    ")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.CommentsWithPerson> findPrivateCommentsByEntityTypeAndUidAndPersonAndPersonToTest(int entityType, long entityUid, long personFrom, long personTo);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE Comments \n           SET commentsInActive = :inActive,\n               commentsLct = :changeTime\n         WHERE Comments.commentsUid = :uid\n    ")
    public abstract java.lang.Object updateInActiveByCommentUid(long uid, boolean inActive, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @java.lang.Override()
    public java.lang.Object deactivateByUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
}