package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\b\'\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\'J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\u0007H\'J\u001b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\tH\'J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\'J%\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001dH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0007H\'J\u001b\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010!\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0%2\u0006\u0010\u0010\u001a\u00020\u0007H\'J\u001f\u0010&\u001a\u00020\u00052\f\u0010\'\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0002H\'J\u0016\u0010*\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\'J\u0011\u0010,\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u001b\u0010.\u001a\u00020\u00052\b\b\u0001\u0010/\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0018\u00100\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u0007H\'J!\u00102\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u0002062\u0006\u0010\u0006\u001a\u00020\u0007H\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContainerDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Container;", "()V", "deleteByUid", "", "containerUid", "", "findAllPublikContainers", "", "findAllWithId", "findByUid", "uid", "findByUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findContainerWithFilesByContentEntryUid", "contentEntryUid", "findContainersForContentEntryUid", "findKhanContainers", "Lcom/ustadmobile/lib/db/entities/ContainerWithContentEntry;", "findLocalAvailabilityByUid", "findRecentContainerToBeMonitoredWithEntriesUid", "contentEntries", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findSizeByUid", "getContainerSizeByUid", "getMostRecentAvailableContainerUidAndMimeType", "Lcom/ustadmobile/lib/db/entities/ContainerUidAndMimeType;", "downloadRequired", "", "(JZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMostRecentContainerForContentEntry", "getMostRecentContainerForContentEntryAsync", "getMostRecentContainerUidForContentEntryAsync", "getMostRecentDownloadedContainerForContentEntryAsync", "contentEntry", "hasContainerWithFilesToDownload", "Lcom/ustadmobile/door/DoorLiveData;", "insertListAsync", "containerList", "insertWithReplace", "container", "replaceList", "entries", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateContainerSizeAndNumEntries", "changeTime", "updateContainerSizeAndNumEntriesAsync", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateMimeType", "mimeType", "", "Companion", "lib-database"})
public abstract class ContainerDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.Container> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ContainerDao.Companion Companion = null;
    private static final java.lang.String CONTAINER_READY_WHERE_CLAUSE = "\n            Container.fileSize > 0\n        ";
    private static final java.lang.String FROM_CONTAINER_WHERE_MOST_RECENT_AND_READY = "\n            FROM Container\n             WHERE Container.containerContentEntryUid = :contentEntryUid\n               AND \n            Container.fileSize > 0\n             \n          ORDER BY Container.cntLastModified DESC \n          LIMIT 1\n        ";
    private static final java.lang.String SELECT_MOST_RECENT_READY_CONTAINER = "\n            SELECT Container.*\n            \n            FROM Container\n             WHERE Container.containerContentEntryUid = :contentEntryUid\n               AND \n            Container.fileSize > 0\n             \n          ORDER BY Container.cntLastModified DESC \n          LIMIT 1\n        \n        ";
    private static final java.lang.String UPDATE_SIZE_AND_NUM_ENTRIES_SQL = "\n            UPDATE Container \n               SET cntNumEntries = COALESCE(\n                   (SELECT COUNT(*) \n                      FROM ContainerEntry \n                     WHERE ceContainerUid = Container.containerUid), 0),\n                   fileSize = COALESCE(\n                   (SELECT SUM(ContainerEntryFile.ceCompressedSize) AS totalSize \n                      FROM ContainerEntry\n                      JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid\n                     WHERE ContainerEntry.ceContainerUid = Container.containerUid), 0),\n                   cntLct = :changeTime   \n                     \n             WHERE containerUid = :containerUid\n        ";
    
    public ContainerDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n         REPLACE INTO ContainerReplicate(containerPk, containerDestination)\n          SELECT DISTINCT Container.containerUid AS containerPk,\n                 :newNodeId AS containerDestination\n            FROM Container\n           WHERE Container.cntLct != COALESCE(\n                 (SELECT containerVersionId\n                    FROM ContainerReplicate\n                   WHERE containerPk = Container.containerUid\n                     AND containerDestination = :newNodeId), 0) \n          /*psql ON CONFLICT(containerPk, containerDestination) DO UPDATE\n                 SET containerPending = true\n          */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Container.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ContainerReplicate(containerPk, containerDestination)\n  SELECT DISTINCT Container.containerUid AS containerUid,\n         UserSession.usClientNodeId AS containerDestination\n    FROM ChangeLog\n         JOIN Container\n             ON ChangeLog.chTableId = 51\n                AND ChangeLog.chEntityPk = Container.containerUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND Container.cntLct != COALESCE(\n         (SELECT containerVersionId\n            FROM ContainerReplicate\n           WHERE containerPk = Container.containerUid\n             AND containerDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(containerPk, containerDestination) DO UPDATE\n     SET containerPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Container.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.Container.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.Container> containerList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "Select Container.* FROM Container WHERE Container.containerContentEntryUid = :contentEntry ORDER BY Container.cntLastModified DESC LIMIT 1")
    public abstract java.lang.Object getMostRecentDownloadedContainerForContentEntryAsync(long contentEntry, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Container> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n            SELECT Container.*\n            \n            FROM Container\n             WHERE Container.containerContentEntryUid = :contentEntryUid\n               AND \n            Container.fileSize > 0\n             \n          ORDER BY Container.cntLastModified DESC \n          LIMIT 1\n        \n        ")
    public abstract com.ustadmobile.lib.db.entities.Container getMostRecentContainerForContentEntry(long contentEntryUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Container WHERE containerUid = :uid")
    public abstract com.ustadmobile.lib.db.entities.Container findByUid(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT(COALESCE((\n               SELECT fileSize\n                 FROM Container\n                WHERE containerUid = :uid), 0))\n    ")
    public abstract java.lang.Object findSizeByUid(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT recent.* FROM Container recent LEFT JOIN Container old ON (recent.containerContentEntryUid = old.containerContentEntryUid AND recent.cntLastModified < old.cntLastModified) WHERE old.containerUid IS NULL AND recent.containerContentEntryUid IN (:contentEntries)")
    public abstract java.lang.Object findRecentContainerToBeMonitoredWithEntriesUid(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> contentEntries, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.Container>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "Select Container.* FROM Container \n                    WHERE Container.containerContentEntryUid = :contentEntryUid\n                    ORDER BY Container.cntLastModified DESC")
    public abstract java.lang.Object findContainersForContentEntryUid(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.Container>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n          SELECT EXISTS(SELECT 1\n                          FROM Container \n                         WHERE Container.containerContentEntryUid = :contentEntryUid\n                           AND NOT EXISTS (SELECT ContainerEntry.ceUid \n                                         FROM ContainerEntry\n                                        WHERE ContainerEntry.ceContainerUid = Container.containerUid)   \n                      ORDER BY cntLastModified DESC LIMIT 1)\n    ")
    public abstract com.ustadmobile.door.DoorLiveData<java.lang.Boolean> hasContainerWithFilesToDownload(long contentEntryUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n            SELECT Container.*\n              FROM Container\n             WHERE Container.containerContentEntryUid = :contentEntryUid\n               AND EXISTS (SELECT ContainerEntry.ceUid \n                             FROM ContainerEntry\n                            WHERE ContainerEntry.ceContainerUid = Container.containerUid)     \n          ORDER BY Container.cntLastModified DESC LIMIT 1\n    ")
    public abstract java.lang.Object findContainerWithFilesByContentEntryUid(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Container> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT Container.* FROM Container LEFT JOIN ContentEntry ON ContentEntry.contentEntryUid = containerContentEntryUid WHERE ContentEntry.publik")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Container> findAllPublikContainers();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * From Container WHERE Container.containerUid = :containerUid LIMIT 1")
    public abstract java.lang.Object findByUidAsync(long containerUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Container> continuation);
    
    @androidx.room.Query(value = "\n            UPDATE Container \n               SET cntNumEntries = COALESCE(\n                   (SELECT COUNT(*) \n                      FROM ContainerEntry \n                     WHERE ceContainerUid = Container.containerUid), 0),\n                   fileSize = COALESCE(\n                   (SELECT SUM(ContainerEntryFile.ceCompressedSize) AS totalSize \n                      FROM ContainerEntry\n                      JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid\n                     WHERE ContainerEntry.ceContainerUid = Container.containerUid), 0),\n                   cntLct = :changeTime   \n                     \n             WHERE containerUid = :containerUid\n        ")
    public abstract void updateContainerSizeAndNumEntries(long containerUid, long changeTime);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n            UPDATE Container \n               SET cntNumEntries = COALESCE(\n                   (SELECT COUNT(*) \n                      FROM ContainerEntry \n                     WHERE ceContainerUid = Container.containerUid), 0),\n                   fileSize = COALESCE(\n                   (SELECT SUM(ContainerEntryFile.ceCompressedSize) AS totalSize \n                      FROM ContainerEntry\n                      JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid\n                     WHERE ContainerEntry.ceContainerUid = Container.containerUid), 0),\n                   cntLct = :changeTime   \n                     \n             WHERE containerUid = :containerUid\n        ")
    public abstract java.lang.Object updateContainerSizeAndNumEntriesAsync(long containerUid, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @androidx.room.Query(value = "SELECT Container.containerUid FROM Container WHERE Container.containerUid = :containerUid AND (SELECT COUNT(*) FROM ContainerEntry WHERE ceContainerUid = Container.containerUid) = Container.cntNumEntries")
    public abstract long findLocalAvailabilityByUid(long containerUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Container WHERE Container.containerUid = :containerUid")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Container> findAllWithId(long containerUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT Container.*, ContentEntry.entryId, ContentEntry.sourceUrl FROM Container LEFT JOIN ContentEntry ON Container.containerContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntry.publisher LIKE \'%Khan Academy%\' AND Container.mimeType = \'video/mp4\'")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContainerWithContentEntry> findKhanContainers();
    
    @androidx.room.Query(value = "DELETE FROM Container WHERE containerUid = :containerUid")
    public abstract void deleteByUid(long containerUid);
    
    @androidx.room.Query(value = "UPDATE Container SET mimeType = :mimeType WHERE Container.containerUid = :containerUid")
    public abstract void updateMimeType(@org.jetbrains.annotations.NotNull()
    java.lang.String mimeType, long containerUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n            SELECT Container.*\n            \n            FROM Container\n             WHERE Container.containerContentEntryUid = :contentEntryUid\n               AND \n            Container.fileSize > 0\n             \n          ORDER BY Container.cntLastModified DESC \n          LIMIT 1\n        \n        ")
    public abstract java.lang.Object getMostRecentContainerForContentEntryAsync(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Container> continuation);
    
    /**
     * Used by the ContainerDownloadPlugin to find the most recent container to try and download.
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT COALESCE((\n                SELECT containerUid \n                 \n            FROM Container\n             WHERE Container.containerContentEntryUid = :contentEntryUid\n               AND \n            Container.fileSize > 0\n             \n          ORDER BY Container.cntLastModified DESC \n          LIMIT 1\n        ), 0)\n    ")
    public abstract java.lang.Object getMostRecentContainerUidForContentEntryAsync(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    /**
     * Used by the ContentEntryOpener to find the most recent container for which the download has
     * been completed.
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT Container.containerUid, Container.mimeType \n          FROM Container\n         WHERE Container.containerContentEntryUid = :contentEntryUid\n           AND \n            Container.fileSize > 0\n        \n           AND (CAST(:downloadRequired AS INTEGER) = 0\n                OR EXISTS (SELECT ContainerEntry.ceUid \n                             FROM ContainerEntry\n                            WHERE ContainerEntry.ceContainerUid = Container.containerUid))\n      ORDER BY Container.cntLastModified DESC \n         LIMIT 1\n    ")
    public abstract java.lang.Object getMostRecentAvailableContainerUidAndMimeType(long contentEntryUid, boolean downloadRequired, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContainerUidAndMimeType> continuation);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract void replaceList(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.Container> entries);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract void insertWithReplace(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Container container);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT COALESCE(\n               (SELECT fileSize\n                  FROM Container\n                 WHERE containerUid = :containerUid), -1)\n    ")
    public abstract java.lang.Object getContainerSizeByUid(long containerUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContainerDao$Companion;", "", "()V", "CONTAINER_READY_WHERE_CLAUSE", "", "FROM_CONTAINER_WHERE_MOST_RECENT_AND_READY", "SELECT_MOST_RECENT_READY_CONTAINER", "UPDATE_SIZE_AND_NUM_ENTRIES_SQL", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}