package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\'J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0007H\'J\u0016\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\'J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u001f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\'J\u0016\u0010\u0018\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0017J\u001f\u0010\u001a\u001a\u00020\u00052\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ)\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2 = {"Lcom/ustadmobile/core/db/dao/ContainerEntryDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContainerEntry;", "()V", "deleteByContainerUid", "", "containerUid", "", "deleteByContentEntryUid", "contentEntryUid", "deleteContainerEntriesCreatedByJobs", "jobId", "deleteList", "entries", "", "findByContainer", "Lcom/ustadmobile/lib/db/entities/ContainerEntryWithContainerEntryFile;", "findByContainerAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByContainerWithMd5", "Lcom/ustadmobile/lib/db/entities/ContainerEntryWithMd5;", "findByPathInContainer", "pathInContainer", "", "insertAndSetIds", "containerEntryList", "insertListAsync", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertWithMd5SumsAsync", "path", "md5", "(JLjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ContainerEntryDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContainerEntry> {
    
    public ContainerEntryDao() {
        super();
    }
    
    @androidx.room.Transaction()
    public void insertAndSetIds(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ContainerEntry> containerEntryList) {
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ContainerEntry> containerEntryList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContainerEntry.*, ContainerEntryFile.* FROM ContainerEntry LEFT JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = :containerUid")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryWithContainerEntryFile> findByContainer(long containerUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContainerEntry.*, ContainerEntryFile.* FROM ContainerEntry LEFT JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = :containerUid AND ContainerEntry.cePath = :pathInContainer")
    public abstract com.ustadmobile.lib.db.entities.ContainerEntryWithContainerEntryFile findByPathInContainer(long containerUid, @org.jetbrains.annotations.NotNull()
    java.lang.String pathInContainer);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContainerEntry.*, ContainerEntryFile.cefMd5 AS cefMd5 FROM ContainerEntry LEFT JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = :containerUid")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryWithMd5> findByContainerWithMd5(long containerUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContainerEntry.*, ContainerEntryFile.* FROM ContainerEntry LEFT JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = :containerUid")
    public abstract java.lang.Object findByContainerAsync(long containerUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryWithContainerEntryFile>> continuation);
    
    @androidx.room.Query(value = "DELETE FROM ContainerEntry WHERE ceContainerUid = :containerUid")
    public abstract void deleteByContainerUid(long containerUid);
    
    @androidx.room.Delete()
    public abstract void deleteList(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ContainerEntry> entries);
    
    @androidx.room.Query(value = "\n            DELETE FROM ContainerEntry \n             WHERE ceContainerUid \n                IN (SELECT cjiContainerUid \n                      FROM ContentJobItem\n                      JOIN ContentJob \n                           ON ContentJobItem.cjiJobUid = ContentJob.cjUid\n                     WHERE ContentJob.cjUid = :jobId)")
    public abstract void deleteContainerEntriesCreatedByJobs(long jobId);
    
    @androidx.room.Query(value = "\n        DELETE FROM ContainerEntry\n         WHERE ceContainerUid\n            IN (SELECT containerUid\n                  FROM Container\n                 WHERE containerContentEntryUid = :contentEntryUid) \n    ")
    public abstract void deleteByContentEntryUid(long contentEntryUid);
    
    /**
     * This query can be used where we know that a ContainerEntryFile with the given md5 exists,
     * but we don't have the container entry file uid (e.g. because insertList was used)
     *
     * COALESCE has to be used because the query will otherwise fail compile-time query checks.
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        INSERT INTO ContainerEntry(ceContainerUid, cePath, ceCefUid) \n        SELECT :containerUid AS ceContainerUid, :path AS cePath, \n               (SELECT COALESCE(\n                      (SELECT cefUid \n                         FROM ContainerEntryFile\n                        WHERE cefMd5 = :md5\n                        LIMIT 1), 0))  \n    ")
    public abstract java.lang.Object insertWithMd5SumsAsync(long containerUid, @org.jetbrains.annotations.NotNull()
    java.lang.String path, @org.jetbrains.annotations.NotNull()
    java.lang.String md5, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}