package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0010\b\'\u0018\u0000 32\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\'J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\bH\'J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\'J%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0017J-\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018JE\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u001e\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u001bH\u0082\bJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\'J\u001b\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\'\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ1\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\'J\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00072\u0006\u0010%\u001a\u00020\u0016H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&J\u0017\u0010\'\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u001f\u0010)\u001a\u00020\u00052\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bH\'J \u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\bH\'J\u0018\u00101\u001a\u00020\u00052\u0006\u00100\u001a\u00020\b2\u0006\u00102\u001a\u00020\u0010H\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00064"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContainerEntryFileDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContainerEntryFile;", "()V", "deleteByUidList", "", "uidList", "", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteListOfEntryFiles", "entriesToDelete", "findByUid", "uid", "findEntriesByMd5Sums", "md5Sums", "", "findEntriesByMd5SumsAsync", "findEntriesByMd5SumsSafe", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "maxListParamSize", "", "findEntriesByMd5SumsSafeAsync", "(Ljava/util/List;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findEntriesByMd5SumsSafeInternal", "queryFn", "Lkotlin/Function1;", "findEntriesByUids", "findEntryByMd5Sum", "md5Sum", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findExistingMd5SumsByMd5SumsAsync", "findExistingMd5SumsByMd5SumsSafe", "findZombieEntries", "findZombieUidsAndPath", "Lcom/ustadmobile/lib/db/entities/ContainerEntryFileUidAndPath;", "limit", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAllFilesForCompression", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertListAsync", "list", "sumContainerFileEntrySizes", "containerUid", "updateCompressedFile", "compression", "ceCompressedSize", "cefUid", "updateFilePath", "path", "Companion", "lib-database"})
public abstract class ContainerEntryFileDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContainerEntryFile> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ContainerEntryFileDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ENDPOINT_CONCATENATEDFILES = "ConcatenatedContainerFiles";
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ENDPOINT_CONCATENATEDFILES2 = "ConcatenatedContainerFiles2";
    
    public ContainerEntryFileDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile> list, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContainerEntryFile.* FROM ContainerEntryFile WHERE cefMd5 IN (:md5Sums)")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile> findEntriesByMd5Sums(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.String> md5Sums);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContainerEntryFile.* FROM ContainerEntryFile WHERE cefMd5 IN (:md5Sums)")
    public abstract java.lang.Object findEntriesByMd5SumsAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.String> md5Sums, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile>> continuation);
    
    /**
     * Whenever there is a possibility of a list parameter with more than 100 entries, this function
     * should be used so the maximum size of a list parameter is not exceeded (which would result in
     * a Room exception).
     */
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Transaction()
    public java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile> findEntriesByMd5SumsSafe(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.String> md5Sums, int maxListParamSize) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Transaction()
    public java.lang.Object findEntriesByMd5SumsSafeAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.String> md5Sums, int maxListParamSize, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile>> continuation) {
        return null;
    }
    
    private final java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile> findEntriesByMd5SumsSafeInternal(java.util.List<java.lang.String> md5Sums, int maxListParamSize, kotlin.jvm.functions.Function1<? super java.util.List<java.lang.String>, ? extends java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile>> queryFn) {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    public final java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile> findEntriesByMd5SumsSafe(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.String> md5Sums, @org.jetbrains.annotations.NotNull()
    com.ustadmobile.core.db.UmAppDatabase db) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Transaction()
    public java.lang.Object findExistingMd5SumsByMd5SumsSafe(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.String> md5Sums, int maxListParamSize, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.String>> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContainerEntryFile.cefMd5 FROM ContainerEntryFile WHERE cefMd5 IN (:md5Sums)")
    public abstract java.lang.Object findExistingMd5SumsByMd5SumsAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.String> md5Sums, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.String>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContainerEntryFile.* FROM ContainerEntryFile WHERE cefUid IN (:uidList)")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile> findEntriesByUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList);
    
    @androidx.room.Query(value = "UPDATE ContainerEntryFile SET cefPath = :path WHERE cefUid = :cefUid")
    public abstract void updateFilePath(long cefUid, @org.jetbrains.annotations.NotNull()
    java.lang.String path);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContainerEntryFile WHERE cefUid = :uid")
    public abstract com.ustadmobile.lib.db.entities.ContainerEntryFile findByUid(long uid);
    
    @androidx.room.Query(value = "SELECT SUM(ContainerEntryFile.ceCompressedSize) FROM ContainerEntry JOIN ContainerEntryFile ON ContainerEntry.ceCefUid = ContainerEntryFile.cefUid WHERE ContainerEntry.ceContainerUid = :containerUid")
    public abstract long sumContainerFileEntrySizes(long containerUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContainerEntryFile WHERE compression = 0 AND NOT EXISTS(SELECT * FROM ContainerEntry WHERE ceCefUid = ContainerEntryFile.cefUid AND (ContainerEntry.cePath LIKE \'%.webm\' OR ContainerEntry.cePath LIKE \'%.mp4\')) LIMIT 100")
    public abstract java.lang.Object getAllFilesForCompression(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile>> continuation);
    
    @androidx.room.Query(value = "UPDATE ContainerEntryFile SET compression = :compression, ceCompressedSize = :ceCompressedSize WHERE cefUid = :cefUid")
    public abstract void updateCompressedFile(int compression, long ceCompressedSize, long cefUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContainerEntryFile.* \n                      FROM ContainerEntryFile \n                     WHERE NOT EXISTS (SELECT ContainerEntry.ceCefUid \n                                     FROM ContainerEntry \n                                    WHERE ContainerEntryFile.cefUid = ContainerEntry.ceCefUid) \n                     LIMIT 100")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile> findZombieEntries();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT cefUid, cefPath\n          FROM ContainerEntryFile\n         WHERE NOT EXISTS \n               (SELECT ContainerEntry.ceCefUid \n                  FROM ContainerEntry \n                 WHERE ContainerEntry.ceCefUid = ContainerEntryFile.cefUid \n                 LIMIT 1)\n         LIMIT :limit     \n    ")
    public abstract java.lang.Object findZombieUidsAndPath(int limit, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFileUidAndPath>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        DELETE FROM ContainerEntryFile\n              WHERE cefUid IN (:uidList) \n    ")
    public abstract java.lang.Object deleteByUidList(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @androidx.room.Delete()
    public abstract void deleteListOfEntryFiles(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.ContainerEntryFile> entriesToDelete);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContainerEntryFile.* FROM ContainerEntryFile WHERE cefMd5 = :md5Sum")
    public abstract java.lang.Object findEntryByMd5Sum(@org.jetbrains.annotations.NotNull()
    java.lang.String md5Sum, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContainerEntryFile> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContainerEntryFileDao$Companion;", "", "()V", "ENDPOINT_CONCATENATEDFILES", "", "ENDPOINT_CONCATENATEDFILES2", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}