package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0000\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\'J\u0014\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000bH\'J\u0018\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\'J\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\'J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\'J!\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\tH\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2 = {"Lcom/ustadmobile/core/db/dao/ContainerImportJobDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContainerImportJob;", "()V", "findBySessionId", "sessionId", "", "findByUid", "uploadId", "", "findJobs", "Lcom/ustadmobile/door/DoorLiveData;", "", "getImportJobLiveData", "importJobUid", "getTitleOfEntry", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setStatusToQueueAsync", "", "uploadJobId", "updateImportComplete", "importCompleted", "", "containerUid", "updateProgress", "progress", "contentLength", "updateSessionId", "(JLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateStatus", "status", "", "lib-database"})
public abstract class ContainerImportJobDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContainerImportJob> {
    
    public ContainerImportJobDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContainerImportJob WHERE cijSessionId = :sessionId")
    public abstract com.ustadmobile.lib.db.entities.ContainerImportJob findBySessionId(@org.jetbrains.annotations.NotNull()
    java.lang.String sessionId);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContainerImportJob where cijUid = :uploadId")
    public abstract com.ustadmobile.lib.db.entities.ContainerImportJob findByUid(long uploadId);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n            SELECT * \n              FROM ContainerImportJob \n             WHERE cijJobStatus = 4\n                   AND (NOT cijImportCompleted OR \n                   (SELECT connectivityState \n                      FROM ConnectivityStatus)\n                   IN (3, 4))\n             LIMIT 10")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.ContainerImportJob>> findJobs();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "UPDATE ContainerImportJob SET cijJobStatus = 4 WHERE cijUid = :uploadJobId AND cijJobStatus = 0")
    public abstract java.lang.Object setStatusToQueueAsync(long uploadJobId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @androidx.room.Query(value = "UPDATE ContainerImportJob SET cijBytesSoFar = :progress, cijContentLength = :contentLength WHERE cijUid = :uploadJobId")
    public abstract void updateProgress(long progress, long contentLength, long uploadJobId);
    
    @androidx.room.Query(value = "UPDATE ContainerImportJob SET cijJobStatus = :status WHERE cijUid = :uploadJobId")
    public abstract void updateStatus(int status, long uploadJobId);
    
    @androidx.room.Query(value = "UPDATE ContainerImportJob \n                       SET cijImportCompleted = :importCompleted,\n                           cijContainerUid = :containerUid\n                     WHERE cijUid = :importJobUid")
    public abstract void updateImportComplete(boolean importCompleted, long containerUid, long importJobUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContentEntry.title FROM ContainerImportJob LEFT JOIN ContentEntry ON ContainerImportJob.cijContentEntryUid = ContentEntry.contentEntryUid WHERE ContainerImportJob.cijUid = :importJobUid")
    public abstract java.lang.Object getTitleOfEntry(long importJobUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * From  ContainerImportJob WHERE ContainerImportJob.cijUid = :importJobUid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ContainerImportJob> getImportJobLiveData(long importJobUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "UPDATE ContainerImportJob SET cijSessionId = :sessionId WHERE cijUid = :importJobUid")
    public abstract java.lang.Object updateSessionId(long importJobUid, @org.jetbrains.annotations.NotNull()
    java.lang.String sessionId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}