package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\'J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\'J\u0011\u0010\u000b\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\u00020\f2\b\b\u0001\u0010\u000f\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContentCategoryDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContentCategory;", "()V", "findCategoryBySchemaIdAndName", "schemaId", "", "name", "", "publicContentCategories", "", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ContentCategoryDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContentCategory> {
    
    public ContentCategoryDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ContentCategoryReplicate(ccPk, ccDestination)\n      SELECT DISTINCT ContentCategory.contentCategoryUid AS ccPk,\n             :newNodeId AS ccDestination\n        FROM ContentCategory\n       WHERE ContentCategory.contentCategoryLct != COALESCE(\n             (SELECT ccVersionId\n                FROM ContentCategoryReplicate\n               WHERE ccPk = ContentCategory.contentCategoryUid\n                 AND ccDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(ccPk, ccDestination) DO UPDATE\n             SET ccPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentCategory.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ContentCategoryReplicate(ccPk, ccDestination)\n  SELECT DISTINCT ContentCategory.contentCategoryUid AS ccUid,\n         UserSession.usClientNodeId AS ccDestination\n    FROM ChangeLog\n         JOIN ContentCategory\n             ON ChangeLog.chTableId = 1\n                AND ChangeLog.chEntityPk = ContentCategory.contentCategoryUid\n         JOIN UserSession \n              ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ContentCategory.contentCategoryLct != COALESCE(\n         (SELECT ccVersionId\n            FROM ContentCategoryReplicate\n           WHERE ccPk = ContentCategory.contentCategoryUid\n             AND ccDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(ccPk, ccDestination) DO UPDATE\n     SET ccPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentCategory.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ContentCategory.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContentCategory.* FROM ContentCategory")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentCategory> publicContentCategories();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContentCategory WHERE ctnCatContentCategorySchemaUid = :schemaId AND name = :name")
    public abstract com.ustadmobile.lib.db.entities.ContentCategory findCategoryBySchemaIdAndName(long schemaId, @org.jetbrains.annotations.NotNull()
    java.lang.String name);
}