package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\'J\u0011\u0010\t\u001a\u00020\nH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContentCategorySchemaDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContentCategorySchema;", "()V", "findBySchemaUrl", "schemaUrl", "", "publicContentCategorySchemas", "", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ContentCategorySchemaDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContentCategorySchema> {
    
    public ContentCategorySchemaDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ContentCategorySchemaReplicate(ccsPk, ccsDestination)\n      SELECT DISTINCT ContentCategorySchema.contentCategorySchemaUid AS ccsPk,\n             :newNodeId AS ccsDestination\n        FROM ContentCategorySchema\n       WHERE ContentCategorySchema.contentCategorySchemaLct != COALESCE(\n             (SELECT ccsVersionId\n                FROM ContentCategorySchemaReplicate\n               WHERE ccsPk = ContentCategorySchema.contentCategorySchemaUid\n                 AND ccsDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(ccsPk, ccsDestination) DO UPDATE\n             SET ccsPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentCategorySchema.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ContentCategorySchemaReplicate(ccsPk, ccsDestination)\n  SELECT DISTINCT ContentCategorySchema.contentCategorySchemaUid AS ccsUid,\n         UserSession.usClientNodeId AS ccsDestination\n    FROM ChangeLog\n         JOIN ContentCategorySchema\n             ON ChangeLog.chTableId = 2\n                AND ChangeLog.chEntityPk = ContentCategorySchema.contentCategorySchemaUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ContentCategorySchema.contentCategorySchemaLct != COALESCE(\n         (SELECT ccsVersionId\n            FROM ContentCategorySchemaReplicate\n           WHERE ccsPk = ContentCategorySchema.contentCategorySchemaUid\n             AND ccsDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(ccsPk, ccsDestination) DO UPDATE\n     SET ccsPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentCategorySchema.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ContentCategorySchema.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContentCategorySchema.* FROM ContentCategorySchema")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentCategorySchema> publicContentCategorySchemas();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContentCategorySchema WHERE schemaUrl = :schemaUrl")
    public abstract com.ustadmobile.lib.db.entities.ContentCategorySchema findBySchemaUrl(@org.jetbrains.annotations.NotNull()
    java.lang.String schemaUrl);
}