package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0013\b\'\u0018\u0000 t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001tB\u0005\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\f0\u0010H\'J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\'J\u001b\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0014H\'J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u0007H\'J\u001b\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\r\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0\u00102\u0006\u0010\r\u001a\u00020\u0007H\'J\u001b\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010\'\u001a\b\u0012\u0004\u0012\u00020(0\f2\u0006\u0010)\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00102\u0006\u0010)\u001a\u00020\u0007H\'J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\'J\u001b\u0010,\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\f2\u0006\u0010)\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\f2\u0006\u0010)\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u000204022\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u0016\u00105\u001a\b\u0012\u0004\u0012\u0002040\f2\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010)\u001a\u00020\u0007H\'J\u001f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010)\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001c\u00108\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u0002022\u0006\u0010)\u001a\u00020\u0007H\'JL\u00109\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020:022\u0006\u0010)\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u000203H\'J\u001c\u0010A\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020:022\u0006\u0010=\u001a\u00020\u0007H\'J\u001b\u0010B\u001a\u0004\u0018\u00010\u00022\u0006\u0010)\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ%\u0010C\u001a\b\u0012\u0004\u0012\u00020D0\f2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u0010\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u0014H\'J\u001c\u0010I\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020:022\u0006\u0010=\u001a\u00020\u0007H\'J/\u0010J\u001a\b\u0012\u0004\u0012\u00020K0\f2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010L\u001a\u0002032\u0006\u0010M\u001a\u000203H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010NJ\u0019\u0010O\u001a\u0002032\u0006\u0010)\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010R\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u0010\u0010U\u001a\u00020S2\u0006\u0010V\u001a\u00020\u0002H\'J\u0019\u0010W\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ)\u0010X\u001a\u00020\t2\u0006\u0010Y\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010Z\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010[J\u0016\u0010\\\u001a\u00020S2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\'J\u0011\u0010^\u001a\u00020SH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u001b\u0010_\u001a\u00020S2\b\b\u0001\u0010`\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010c\u001a\u0002032\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ/\u0010d\u001a\u00020S2\u0006\u0010e\u001a\u00020\t2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010g\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010hJ\u0010\u0010i\u001a\u00020S2\u0006\u0010j\u001a\u00020\u0002H\'J\u0019\u0010k\u001a\u0002032\u0006\u0010j\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010lJ \u0010m\u001a\u00020S2\u0006\u0010n\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\t2\u0006\u0010g\u001a\u00020\u0007H\'J \u0010p\u001a\u00020S2\u0006\u0010q\u001a\u0002032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010g\u001a\u00020\u0007H\'J \u0010r\u001a\u00020S2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010s\u001a\u00020\t2\u0006\u0010g\u001a\u00020\u0007H\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006u"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "()V", "buttonsToShowForContentEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntryButtonModel;", "contentEntryUid", "", "platformDownloadEnabled", "", "(JZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllLanguageRelatedEntriesAsync", "", "entryUuid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllLive", "Lcom/ustadmobile/door/DoorLiveData;", "Lcom/ustadmobile/lib/db/entities/ContentEntryWithLanguage;", "findBySourceUrl", "sourceUrl", "", "findBySourceUrlWithContentEntryStatusAsync", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByTitle", "title", "findByUid", "entryUid", "findByUidAsync", "findByUidWithLanguageAsync", "uid", "findContentEntriesWhereIsLeafAndLatestContainerHasNoEntriesOrHasZeroFileSize", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findEntryWithBlockAndLanguageByUidAsync", "Lcom/ustadmobile/lib/db/entities/ContentEntryWithBlockAndLanguage;", "entityUid", "findEntryWithContainerByEntryId", "Lcom/ustadmobile/lib/db/entities/ContentEntryWithMostRecentContainer;", "findEntryWithContainerByEntryIdLive", "findEntryWithLanguageByEntryIdAsync", "findListOfCategoriesAsync", "Lcom/ustadmobile/lib/db/entities/DistinctCategorySchema;", "parentUid", "findLiveContentEntry", "findSimilarIdEntryForKhan", "findTitleByUidAsync", "findUniqueLanguageWithParentUid", "Lcom/ustadmobile/lib/db/entities/LangUidAndName;", "findUniqueLanguagesInListAsync", "Lcom/ustadmobile/lib/db/entities/Language;", "getAllEntriesRecursively", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/ContentEntryWithParentChildJoinAndMostRecentContainer;", "getAllEntriesRecursivelyAsList", "getChildrenByAll", "getChildrenByParentAsync", "getChildrenByParentUid", "getChildrenByParentUidWithCategoryFilterOrderByName", "Lcom/ustadmobile/lib/db/entities/ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer;", "langParam", "categoryParam0", "personUid", "showHidden", "onlyFolder", "sortOrder", "getContentByOwner", "getContentByUuidAsync", "getContentEntryFromUids", "Lcom/ustadmobile/lib/db/entities/UidAndLabel;", "contentEntryUids", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getContentEntryUidFromXapiObjectId", "objectId", "getContentFromMyCourses", "getContentJobItemParamsByParentUid", "Lcom/ustadmobile/lib/db/entities/ContentEntryContentJobItemParams;", "limit", "offset", "(JIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCountNumberOfChildrenByParentUUidAsync", "getRecursiveDownloadTotals", "Lcom/ustadmobile/lib/db/entities/DownloadJobSizeInfo;", "insertListAsync", "", "entityList", "insertWithReplace", "entry", "isMeteredAllowedForEntry", "personHasPermissionWithContentEntry", "accountPersonUid", "permission", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replaceList", "entries", "replicateOnChange", "replicateOnNewNode", "newNodeId", "statusForContentEntryList", "Lcom/ustadmobile/lib/db/entities/ContentJobItemProgressAndStatus;", "statusForDownloadDialog", "toggleVisibilityContentEntryItems", "toggleVisibility", "selectedItem", "changedTime", "(ZLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "update", "entity", "updateAsync", "(Lcom/ustadmobile/lib/db/entities/ContentEntry;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateContentEntryActiveByContentJobUid", "jobId", "inactive", "updateContentEntryContentFlag", "contentFlag", "updateContentEntryInActive", "ceInactive", "Companion", "lib-database"})
public abstract class ContentEntryDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContentEntry> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ContentEntryDao.Companion Companion = null;
    public static final int PLUGIN_ID_DOWNLOAD = 10;
    public static final int PLUGIN_ID_DELETE = 14;
    public static final int SORT_TITLE_ASC = 1;
    public static final int SORT_TITLE_DESC = 2;
    private static final java.lang.String LATEST_DOWNLOADED_CONTAINER_CTE_SQL = "\n            LatestDownloadedContainer(containerUid) AS\n             (SELECT COALESCE(\n                     (SELECT containerUid\n                        FROM Container\n                       WHERE Container.containerContentEntryUid = :contentEntryUid \n                         AND EXISTS(\n                             SELECT 1\n                               FROM ContainerEntry\n                              WHERE ContainerEntry.ceContainerUid = Container.containerUid)\n                    ORDER BY cntLastModified DESC\n                       LIMIT 1), 0))\n        ";
    private static final java.lang.String ACTIVE_CONTENT_JOB_ITEMS_CTE_SQL = "\n            ActiveContentJobItems(cjiRecursiveStatus, cjiPluginId) AS\n             (SELECT cjiRecursiveStatus, cjiPluginId\n                FROM ContentJobItem\n               WHERE cjiContentEntryUid = :contentEntryUid\n                 AND cjiStatus BETWEEN 4 AND 20)\n        ";
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ENTITY_PERSONS_WITH_PERMISSION_PT1 = "\n            SELECT DISTINCT Person.PersonUid FROM Person\n            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE \n            CAST(Person.admin AS INTEGER) = 1\n            OR \n            (EntityRole.ertableId = 42 AND \n            EntityRole.erEntityUid = ContentEntry.contentEntryUid AND\n            (Role.rolePermissions &  \n        ";
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ENTITY_PERSONS_WITH_PERMISSION_PT2 = ") > 0)";
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ENTITY_PERSONS_WITH_PERMISSION = "\n            SELECT DISTINCT Person.PersonUid FROM Person\n            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE \n            CAST(Person.admin AS INTEGER) = 1\n            OR \n            (EntityRole.ertableId = 42 AND \n            EntityRole.erEntityUid = ContentEntry.contentEntryUid AND\n            (Role.rolePermissions &  \n         :permission ) > 0)";
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ALL_ENTRIES_RECURSIVE_SQL = "WITH RECURSIVE ContentEntry_recursive(\n            contentEntryUid, title, ceInactive, contentFlags, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, leaf, publik,  completionCriteria, minScore, contentOwner, contentTypeFlag, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct,\n            \n            cepcjUid, cepcjChildContentEntryUid, cepcjParentContentEntryUid, childIndex, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct,\n            \n            containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries, cntLct\n            ) AS (\n            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct,\n            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n            FROM \n            ContentEntry\n            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0))\n            WHERE ContentEntry.contentEntryUid = :contentEntryUid\n            UNION\n            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct, \n            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n            FROM \n            ContentEntry\n            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0)),\n            ContentEntry_recursive\n            WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ContentEntry_recursive.contentEntryUid)\n            SELECT * FROM ContentEntry_recursive";
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String ENTRY_WITH_CONTAINER_QUERY = "\n            SELECT ContentEntry.*, Container.* FROM ContentEntry LEFT \n                JOIN Container ON Container.containerUid = (\n                    SELECT containerUid FROM Container WHERE containerContentEntryUid =  ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1) \n            WHERE ContentEntry.contentEntryUid=:entryUuid\n            ";
    
    public ContentEntryDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n        REPLACE INTO ContentEntryReplicate(cePk, ceDestination)\n         SELECT DISTINCT contentEntryUid AS ceUid,\n                :newNodeId AS siteDestination\n           FROM ContentEntry\n          WHERE ContentEntry.contentEntryLct != COALESCE(\n                (SELECT ceVersionId\n                   FROM ContentEntryReplicate\n                  WHERE cePk = ContentEntry.contentEntryUid\n                    AND ceDestination = :newNodeId), -1) \n         /*psql ON CONFLICT(cePk, ceDestination) DO UPDATE\n                SET cePending = true\n         */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentEntry.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        REPLACE INTO ContentEntryReplicate(cePk, ceDestination)\n         SELECT DISTINCT ContentEntry.contentEntryUid AS cePk,\n                UserSession.usClientNodeId AS siteDestination\n           FROM ChangeLog\n                JOIN ContentEntry\n                    ON ChangeLog.chTableId = 42\n                       AND ChangeLog.chEntityPk = ContentEntry.contentEntryUid\n                JOIN UserSession ON UserSession.usStatus = 1\n          WHERE UserSession.usClientNodeId != (\n                SELECT nodeClientId \n                  FROM SyncNode\n                 LIMIT 1)\n            AND ContentEntry.contentEntryLct != COALESCE(\n                (SELECT ceVersionId\n                   FROM ContentEntryReplicate\n                  WHERE cePk = ContentEntry.contentEntryUid\n                    AND ceDestination = UserSession.usClientNodeId), 0)     \n        /*psql ON CONFLICT(cePk, ceDestination) DO UPDATE\n            SET cePending = true\n         */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentEntry.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ContentEntry.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ContentEntry> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContentEntry.*, Language.* FROM ContentEntry LEFT JOIN Language ON Language.langUid = ContentEntry.primaryLanguageUid WHERE ContentEntry.contentEntryUid=:entryUuid")
    public abstract java.lang.Object findEntryWithLanguageByEntryIdAsync(long entryUuid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntryWithLanguage> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentEntry.*, \n               Language.*,\n               CourseBlock.*\n          FROM ContentEntry\n               LEFT JOIN Language \n               ON Language.langUid = ContentEntry.primaryLanguageUid \n               \n               LEFT JOIN CourseBlock\n               ON CourseBlock.cbType = 104\n               AND CourseBlock.cbEntityUid = :entityUid\n               \n         WHERE ContentEntry.contentEntryUid = :entityUid       \n    ")
    public abstract java.lang.Object findEntryWithBlockAndLanguageByUidAsync(long entityUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntryWithBlockAndLanguage> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n            SELECT ContentEntry.*, Container.* FROM ContentEntry LEFT \n                JOIN Container ON Container.containerUid = (\n                    SELECT containerUid FROM Container WHERE containerContentEntryUid =  ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1) \n            WHERE ContentEntry.contentEntryUid=:entryUuid\n            ")
    public abstract java.lang.Object findEntryWithContainerByEntryId(long entryUuid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntryWithMostRecentContainer> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n            SELECT ContentEntry.*, Container.* FROM ContentEntry LEFT \n                JOIN Container ON Container.containerUid = (\n                    SELECT containerUid FROM Container WHERE containerContentEntryUid =  ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1) \n            WHERE ContentEntry.contentEntryUid=:entryUuid\n            ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ContentEntryWithMostRecentContainer> findEntryWithContainerByEntryIdLive(long entryUuid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContentEntry WHERE sourceUrl = :sourceUrl LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.ContentEntry findBySourceUrl(@org.jetbrains.annotations.NotNull()
    java.lang.String sourceUrl);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT title FROM ContentEntry WHERE contentEntryUid = :contentEntryUid")
    public abstract java.lang.Object findTitleByUidAsync(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContentEntry.* FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ContentEntry> getChildrenByParentUid(long parentUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentEntry.*\n          FROM ContentEntryParentChildJoin\n               JOIN ContentEntry \n                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid\n         WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid\n    ")
    public abstract java.lang.Object getChildrenByParentAsync(long parentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.ContentEntry>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentEntry.contentEntryUid AS contentEntryUid, ContentEntry.leaf AS leaf, \n               COALESCE(Container.containerUid, 0) AS mostRecentContainerUid,\n               COALESCE(Container.fileSize, 0) AS mostRecentContainerSize\n          FROM ContentEntryParentChildJoin\n               JOIN ContentEntry \n                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid\n               LEFT JOIN Container\n                    ON containerUid = \n                        (SELECT COALESCE((\n                                SELECT Container.containerUid \n                                  FROM Container\n                                 WHERE Container.containerContentEntryUid = ContentEntry.contentEntryUid\n                              ORDER BY Container.cntLastModified DESC\n                                 LIMIT 1),0))\n         WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid\n         LIMIT :limit\n        OFFSET :offset \n    ")
    public abstract java.lang.Object getContentJobItemParamsByParentUid(long parentUid, int limit, int offset, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContentEntryContentJobItemParams>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT COUNT(*) FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid")
    public abstract java.lang.Object getCountNumberOfChildrenByParentUUidAsync(long parentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContentEntry where contentEntryUid = :parentUid LIMIT 1")
    public abstract java.lang.Object getContentByUuidAsync(long parentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntry> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryRelatedEntryJoin ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryRelatedEntryJoin.relType = 1 AND ContentEntryRelatedEntryJoin.cerejRelatedEntryUid != :entryUuid")
    public abstract java.lang.Object findAllLanguageRelatedEntriesAsync(long entryUuid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.ContentEntry>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT DISTINCT ContentCategory.contentCategoryUid, ContentCategory.name AS categoryName, ContentCategorySchema.contentCategorySchemaUid, ContentCategorySchema.schemaName FROM ContentEntry LEFT JOIN ContentEntryContentCategoryJoin ON ContentEntryContentCategoryJoin.ceccjContentEntryUid = ContentEntry.contentEntryUid LEFT JOIN ContentCategory ON ContentCategory.contentCategoryUid = ContentEntryContentCategoryJoin.ceccjContentCategoryUid LEFT JOIN ContentCategorySchema ON ContentCategorySchema.contentCategorySchemaUid = ContentCategory.ctnCatContentCategorySchemaUid LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid AND ContentCategory.contentCategoryUid != 0 ORDER BY ContentCategory.name")
    @com.ustadmobile.door.annotation.RepoHttpAccessible()
    @com.ustadmobile.door.annotation.Repository(methodType = 2)
    public abstract java.lang.Object findListOfCategoriesAsync(long parentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.DistinctCategorySchema>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.RepoHttpAccessible()
    @androidx.room.Query(value = "SELECT DISTINCT Language.* from Language LEFT JOIN ContentEntry ON ContentEntry.primaryLanguageUid = Language.langUid LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid ORDER BY Language.name")
    public abstract java.lang.Object findUniqueLanguagesInListAsync(long parentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.Language>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.RepoHttpAccessible()
    @androidx.room.Query(value = "SELECT DISTINCT Language.langUid, Language.name AS langName from Language\n        LEFT JOIN ContentEntry ON ContentEntry.primaryLanguageUid = Language.langUid\n        LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n        WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid ORDER BY Language.name")
    @com.ustadmobile.door.annotation.Repository(methodType = 2)
    public abstract java.lang.Object findUniqueLanguageWithParentUid(long parentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.LangUidAndName>> continuation);
    
    @java.lang.Override()
    @androidx.room.Update()
    public abstract void update(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ContentEntry entity);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContentEntry WHERE contentEntryUid = :entryUid")
    public abstract java.lang.Object findByUidAsync(long entryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntry> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentEntry.*, Language.*\n          FROM ContentEntry\n               LEFT JOIN Language \n                      ON Language.langUid = ContentEntry.primaryLanguageUid \n         WHERE ContentEntry.contentEntryUid = :uid              \n    ")
    public abstract java.lang.Object findByUidWithLanguageAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntryWithLanguage> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContentEntry WHERE contentEntryUid = :entryUid")
    public abstract com.ustadmobile.lib.db.entities.ContentEntry findByUid(long entryUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM ContentEntry WHERE title = :title")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ContentEntry> findByTitle(@org.jetbrains.annotations.NotNull()
    java.lang.String title);
    
    /**
     * For new jobs, if the user is currently on Mobile Data, we will assume that they know what
     * they want to do, and by default, allow the use of mobile data.
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n       SELECT COALESCE((SELECT CAST(cjIsMeteredAllowed AS INTEGER) \n                FROM ContentJobItem \n                JOIN ContentJob\n                    ON ContentJobItem.cjiJobUid = ContentJob.cjUid\n               WHERE cjiContentEntryUid = :contentEntryUid\n                AND cjiRecursiveStatus >= 4\n                AND cjiRecursiveStatus <= 20 LIMIT 1),\n                CAST(((SELECT connectivityState\n                        FROM ConnectivityStatus\n                       LIMIT 1) = 3) AS INTEGER),\n                0) AS Status\n    ")
    public abstract java.lang.Object isMeteredAllowedForEntry(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContentEntry.* FROM ContentEntry WHERE ContentEntry.sourceUrl = :sourceUrl")
    public abstract java.lang.Object findBySourceUrlWithContentEntryStatusAsync(@org.jetbrains.annotations.NotNull()
    java.lang.String sourceUrl, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntry> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n            SELECT ContentEntry.*, ContentEntryParentChildJoin.*, Container.*, \n                COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, \n                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, \n                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, \n                COALESCE(StatementEntity.extensionProgress,0) AS progress, \n                COALESCE(StatementEntity.resultCompletion,\'FALSE\') AS contentComplete,\n                COALESCE(StatementEntity.resultSuccess, 0) AS success,\n                COALESCE((CASE WHEN StatementEntity.resultCompletion \n                THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                0 AS assignmentContentWeight,\n                \n                1 as totalContent, \n                \n                0 as penalty\n            FROM ContentEntry \n                    LEFT JOIN ContentEntryParentChildJoin \n                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n                    \n                    LEFT JOIN StatementEntity\n\t\t\t\t\t\t\tON StatementEntity.statementUid = \n                                (SELECT statementUid \n\t\t\t\t\t\t\t       FROM StatementEntity \n                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid \n\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = :personUid\n\t\t\t\t\t\t\t        AND contentEntryRoot \n                               ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC LIMIT 1)\n                    \n                    LEFT JOIN Container \n                    ON Container.containerUid = \n                        (SELECT containerUid \n                           FROM Container \n                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n                       ORDER BY cntLastModified DESC LIMIT 1)\n            WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid \n            AND (:langParam = 0 OR ContentEntry.primaryLanguageUid = :langParam) \n            AND (NOT ContentEntry.ceInactive OR ContentEntry.ceInactive = :showHidden) \n            AND (NOT ContentEntry.leaf OR NOT ContentEntry.leaf = :onlyFolder) \n            AND (ContentEntry.publik \n                 OR (SELECT username\n                        FROM Person\n                       WHERE personUid = :personUid) IS NOT NULL) \n            AND \n            (:categoryParam0 = 0 OR :categoryParam0 \n                IN (SELECT ceccjContentCategoryUid \n                      FROM ContentEntryContentCategoryJoin \n                     WHERE ceccjContentEntryUid = ContentEntry.contentEntryUid)) \n            ORDER BY ContentEntryParentChildJoin.childIndex,\n                     CASE(:sortOrder)\n                     WHEN 1 THEN ContentEntry.title\n                     ELSE \'\'\n                     END ASC,\n                     CASE(:sortOrder)\n                     WHEN 2 THEN ContentEntry.title\n                     ELSE \'\'\n                     END DESC,             \n                     ContentEntry.contentEntryUid")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> getChildrenByParentUidWithCategoryFilterOrderByName(long parentUid, long langParam, long categoryParam0, long personUid, boolean showHidden, boolean onlyFolder, int sortOrder);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, Container.*, \n                COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, \n                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, \n                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, \n                COALESCE(StatementEntity.extensionProgress,0) AS progress, \n                COALESCE(StatementEntity.resultCompletion,\'FALSE\') AS contentComplete,\n                COALESCE(StatementEntity.resultSuccess, 0) AS success,\n                COALESCE((CASE WHEN StatementEntity.resultCompletion \n                THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                0 AS assignmentContentWeight,\n                \n                1 as totalContent, \n                \n                0 as penalty\n          FROM CourseBlock\n               JOIN ContentEntry \n                    ON CourseBlock.cbType = 104\n                       AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n                       AND CAST(CourseBlock.cbActive AS INTEGER) = 1\n               LEFT JOIN ContentEntryParentChildJoin \n                    ON ContentEntryParentChildJoin.cepcjUid = 0 \n               LEFT JOIN StatementEntity\n\t\t\t\t\t\t\tON StatementEntity.statementUid = \n                                (SELECT statementUid \n\t\t\t\t\t\t\t       FROM StatementEntity \n                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid \n\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = :personUid\n\t\t\t\t\t\t\t        AND contentEntryRoot \n                               ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC LIMIT 1)     \n               LEFT JOIN Container \n                    ON Container.containerUid = \n                        (SELECT containerUid \n                           FROM Container \n                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n                       ORDER BY cntLastModified DESC LIMIT 1)  \n                               \n         WHERE CourseBlock.cbClazzUid IN\n               (SELECT ClazzEnrolment.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :personUid)\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> getContentFromMyCourses(long personUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, Container.*, \n                COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, \n                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, \n                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, \n                COALESCE(StatementEntity.extensionProgress,0) AS progress, \n                COALESCE(StatementEntity.resultCompletion,\'FALSE\') AS contentComplete,\n                COALESCE(StatementEntity.resultSuccess, 0) AS success,\n                COALESCE((CASE WHEN StatementEntity.resultCompletion \n                THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                0 AS assignmentContentWeight,\n                \n                1 as totalContent, \n                \n                0 as penalty\n          FROM ContentEntry\n               LEFT JOIN ContentEntryParentChildJoin \n                    ON ContentEntryParentChildJoin.cepcjUid = 0 \n               LEFT JOIN StatementEntity\n\t\t\t\t\t\t\tON StatementEntity.statementUid = \n                                (SELECT statementUid \n\t\t\t\t\t\t\t       FROM StatementEntity \n                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid \n\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = :personUid\n\t\t\t\t\t\t\t        AND contentEntryRoot \n                               ORDER BY resultScoreScaled DESC, extensionProgress DESC, resultSuccess DESC LIMIT 1)     \n               LEFT JOIN Container \n                    ON Container.containerUid = \n                        (SELECT containerUid \n                           FROM Container \n                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n                       ORDER BY cntLastModified DESC LIMIT 1)  \n         WHERE ContentEntry.contentOwner = :personUid\n           AND NOT EXISTS(\n               SELECT ContentEntryParentChildJoin.cepcjUid \n                 FROM ContentEntryParentChildJoin\n                WHERE ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid)\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndStatusAndMostRecentContainer> getContentByOwner(long personUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ContentEntry entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentEntry> getChildrenByAll(long parentUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM ContentEntry where contentEntryUid = :parentUid LIMIT 1")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ContentEntry> findLiveContentEntry(long parentUid);
    
    @androidx.room.Query(value = "SELECT COALESCE((SELECT contentEntryUid \n                                      FROM ContentEntry \n                                     WHERE entryId = :objectId \n                                     LIMIT 1),0) AS ID")
    public abstract long getContentEntryUidFromXapiObjectId(@org.jetbrains.annotations.NotNull()
    java.lang.String objectId);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM ContentEntry WHERE sourceUrl LIKE :sourceUrl")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentEntry> findSimilarIdEntryForKhan(@org.jetbrains.annotations.NotNull()
    java.lang.String sourceUrl);
    
    /**
     * This query is used to tell the client how big a download job is, even if the client does
     * not yet have the indexes
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        WITH RECURSIVE \n               ContentEntry_recursive(contentEntryUid, containerSize) AS (\n               SELECT contentEntryUid, \n                            (SELECT COALESCE((SELECT fileSize \n                                           FROM Container \n                                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n                                       ORDER BY cntLastModified DESC LIMIT 1), 0)) AS containerSize \n                 FROM ContentEntry \n                WHERE contentEntryUid = :contentEntryUid\n                  AND NOT ceInactive\n        UNION \n            SELECT ContentEntry.contentEntryUid, \n                (SELECT COALESCE((SELECT fileSize \n                                    FROM Container \n                                   WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n                                ORDER BY cntLastModified DESC LIMIT 1), 0)) AS containerSize  \n                  FROM ContentEntry\n             LEFT JOIN ContentEntryParentChildJoin \n                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid,\n                            ContentEntry_recursive\n                  WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ContentEntry_recursive.contentEntryUid\n                    AND NOT ceInactive)\n        SELECT COUNT(*) AS numEntries, \n               SUM(containerSize) AS totalSize \n          FROM ContentEntry_recursive")
    @com.ustadmobile.door.annotation.RepoHttpAccessible()
    @com.ustadmobile.door.annotation.Repository(methodType = 2)
    public abstract java.lang.Object getRecursiveDownloadTotals(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.DownloadJobSizeInfo> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "WITH RECURSIVE ContentEntry_recursive(\n            contentEntryUid, title, ceInactive, contentFlags, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, leaf, publik,  completionCriteria, minScore, contentOwner, contentTypeFlag, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct,\n            \n            cepcjUid, cepcjChildContentEntryUid, cepcjParentContentEntryUid, childIndex, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct,\n            \n            containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries, cntLct\n            ) AS (\n            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct,\n            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n            FROM \n            ContentEntry\n            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0))\n            WHERE ContentEntry.contentEntryUid = :contentEntryUid\n            UNION\n            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct, \n            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n            FROM \n            ContentEntry\n            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0)),\n            ContentEntry_recursive\n            WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ContentEntry_recursive.contentEntryUid)\n            SELECT * FROM ContentEntry_recursive")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndMostRecentContainer> getAllEntriesRecursively(long contentEntryUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "WITH RECURSIVE ContentEntry_recursive(\n            contentEntryUid, title, ceInactive, contentFlags, description, entryId, author, publisher, licenseType, licenseName, licenseUrl, sourceUrl, thumbnailUrl, lastModified, primaryLanguageUid, languageVariantUid, leaf, publik,  completionCriteria, minScore, contentOwner, contentTypeFlag, contentEntryLocalChangeSeqNum, contentEntryMasterChangeSeqNum, contentEntryLastChangedBy, contentEntryLct,\n            \n            cepcjUid, cepcjChildContentEntryUid, cepcjParentContentEntryUid, childIndex, cepcjLocalChangeSeqNum, cepcjMasterChangeSeqNum, cepcjLastChangedBy, cepcjLct,\n            \n            containerUid, cntLocalCsn, cntMasterCsn, cntLastModBy, fileSize, containerContentEntryUid, cntLastModified, mimeType, remarks, mobileOptimized, cntNumEntries, cntLct\n            ) AS (\n            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct,\n            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n            FROM \n            ContentEntry\n            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0))\n            WHERE ContentEntry.contentEntryUid = :contentEntryUid\n            UNION\n            SELECT ContentEntry.contentEntryUid, ContentEntry.title, ContentEntry.ceInactive, ContentEntry.contentFlags, ContentEntry.description, ContentEntry.entryId, ContentEntry.author, ContentEntry.publisher, ContentEntry.licenseType, ContentEntry.licenseName, ContentEntry.licenseUrl, ContentEntry.sourceUrl, ContentEntry.thumbnailUrl, ContentEntry.lastModified, ContentEntry.primaryLanguageUid, ContentEntry.languageVariantUid, ContentEntry.leaf, ContentEntry.publik, ContentEntry.completionCriteria, ContentEntry.minScore, ContentEntry.contentOwner, ContentEntry.contentTypeFlag, ContentEntry.contentEntryLocalChangeSeqNum, ContentEntry.contentEntryMasterChangeSeqNum, ContentEntry.contentEntryLastChangedBy, ContentEntry.contentEntryLct,\n            ContentEntryParentChildJoin.cepcjUid, ContentEntryParentChildJoin.cepcjChildContentEntryUid, ContentEntryParentChildJoin.cepcjParentContentEntryUid, ContentEntryParentChildJoin.childIndex, ContentEntryParentChildJoin.cepcjLocalChangeSeqNum, ContentEntryParentChildJoin.cepcjMasterChangeSeqNum, ContentEntryParentChildJoin.cepcjLastChangedBy, ContentEntryParentChildJoin.cepcjLct, \n            Container.containerUid, Container.cntLocalCsn, Container.cntMasterCsn, Container.cntLastModBy, Container.fileSize, Container.containerContentEntryUid, Container.cntLastModified, Container.mimeType, Container.remarks, Container.mobileOptimized, Container.cntNumEntries, Container.cntLct\n            FROM \n            ContentEntry\n            LEFT JOIN ContentEntryParentChildJoin ON ContentEntry.contentEntryUid = ContentEntryParentChildJoin.cepcjChildContentEntryUid \n            LEFT JOIN Container ON Container.containerUid = (SELECT COALESCE((SELECT containerUid FROM Container WHERE containerContentEntryUid = ContentEntry.contentEntryUid ORDER BY cntLastModified DESC LIMIT 1), 0)),\n            ContentEntry_recursive\n            WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = ContentEntry_recursive.contentEntryUid)\n            SELECT * FROM ContentEntry_recursive")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentEntryWithParentChildJoinAndMostRecentContainer> getAllEntriesRecursivelyAsList(long contentEntryUid);
    
    @androidx.room.Query(value = "\n            UPDATE ContentEntry \n               SET ceInactive = :ceInactive,\n                   contentEntryLct = :changedTime        \n            WHERE ContentEntry.contentEntryUid = :contentEntryUid")
    public abstract void updateContentEntryInActive(long contentEntryUid, boolean ceInactive, long changedTime);
    
    @androidx.room.Query(value = "\n        UPDATE ContentEntry \n           SET contentTypeFlag = :contentFlag,\n               contentEntryLct = :changedTime \n         WHERE ContentEntry.contentEntryUid = :contentEntryUid")
    public abstract void updateContentEntryContentFlag(int contentFlag, long contentEntryUid, long changedTime);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract void replaceList(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.ContentEntry> entries);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "Select ContentEntry.contentEntryUid AS uid, ContentEntry.title As labelName \n                    from ContentEntry WHERE contentEntryUid IN (:contentEntryUids)")
    public abstract java.lang.Object getContentEntryFromUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> contentEntryUids, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.UidAndLabel>> continuation);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract void insertWithReplace(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ContentEntry entry);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContentEntry.*, Language.* FROM ContentEntry LEFT JOIN Language ON Language.langUid = ContentEntry.primaryLanguageUid")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.ContentEntryWithLanguage>> findAllLive();
    
    /**
     * Check if a permission is present on a specific entity e.g. updateState/modify etc
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT EXISTS(SELECT 1 FROM ContentEntry WHERE ContentEntry.contentEntryUid = :contentEntryUid AND :accountPersonUid IN (\n            SELECT DISTINCT Person.PersonUid FROM Person\n            LEFT JOIN PersonGroupMember ON Person.personUid = PersonGroupMember.groupMemberPersonUid\n            LEFT JOIN EntityRole ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n            LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid\n            WHERE \n            CAST(Person.admin AS INTEGER) = 1\n            OR \n            (EntityRole.ertableId = 42 AND \n            EntityRole.erEntityUid = ContentEntry.contentEntryUid AND\n            (Role.rolePermissions &  \n         :permission ) > 0)))")
    public abstract java.lang.Object personHasPermissionWithContentEntry(long accountPersonUid, long contentEntryUid, long permission, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    @androidx.room.Query(value = "\n        UPDATE ContentEntry\n           SET ceInactive = :inactive,\n               contentEntryLct = :changedTime\n         WHERE contentEntryUid IN \n               (SELECT cjiContentEntryUid \n                  FROM ContentJobItem\n                 WHERE cjiJobUid = :jobId\n                   AND CAST(ContentJobItem.cjiContentDeletedOnCancellation AS INTEGER) = 1)\n    ")
    public abstract void updateContentEntryActiveByContentJobUid(long jobId, boolean inactive, long changedTime);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentEntry \n           SET ceInactive = :toggleVisibility, \n               contentEntryLct = :changedTime \n         WHERE contentEntryUid IN (:selectedItem)")
    public abstract java.lang.Object toggleVisibilityContentEntryItems(boolean toggleVisibility, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> selectedItem, long changedTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\nSELECT ContentEntry.*\n  FROM ContentEntry\n       JOIN Container ON Container.containerUid = \n       (SELECT containerUid \n          FROM Container\n         WHERE Container.containercontententryUid = ContentEntry.contentEntryUid\n           AND Container.cntLastModified = \n               (SELECT MAX(ContainerInternal.cntLastModified)\n                  FROM Container ContainerInternal\n                 WHERE ContainerInternal.containercontententryUid = ContentEntry.contentEntryUid))\n WHERE ContentEntry.leaf \n   AND NOT ContentEntry.ceInactive\n   AND (NOT EXISTS \n       (SELECT ContainerEntry.ceUid\n          FROM ContainerEntry\n         WHERE ContainerEntry.ceContainerUid = Container.containerUid)\n        OR Container.fileSize = 0)   \n    ")
    public abstract java.lang.Object findContentEntriesWhereIsLeafAndLatestContainerHasNoEntriesOrHasZeroFileSize(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.ContentEntry>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        WITH ContentEntryContainerUids AS \n             (SELECT Container.containerUid\n                FROM Container\n               WHERE Container.containerContentEntryUid = :contentEntryUid\n                   AND Container.fileSize > 0),\n                   \n             \n            LatestDownloadedContainer(containerUid) AS\n             (SELECT COALESCE(\n                     (SELECT containerUid\n                        FROM Container\n                       WHERE Container.containerContentEntryUid = :contentEntryUid \n                         AND EXISTS(\n                             SELECT 1\n                               FROM ContainerEntry\n                              WHERE ContainerEntry.ceContainerUid = Container.containerUid)\n                    ORDER BY cntLastModified DESC\n                       LIMIT 1), 0))\n        ,\n                            \n             \n            ActiveContentJobItems(cjiRecursiveStatus, cjiPluginId) AS\n             (SELECT cjiRecursiveStatus, cjiPluginId\n                FROM ContentJobItem\n               WHERE cjiContentEntryUid = :contentEntryUid\n                 AND cjiStatus BETWEEN 4 AND 20)\n        ,\n                  \n            ShowDownload(showDownload) AS \n            (SELECT CAST(:platformDownloadEnabled AS INTEGER) = 1\n                AND (SELECT containerUid FROM LatestDownloadedContainer) = 0\n                AND (SELECT COUNT(*) FROM ActiveContentJobItems) = 0\n                AND (SELECT COUNT(*) FROM ContentEntryContainerUids) > 0)\n                   \n        SELECT (SELECT showDownload FROM ShowDownload)\n               AS showDownloadButton,\n        \n               CAST(:platformDownloadEnabled AS INTEGER) = 0\n               OR (SELECT containerUid FROM LatestDownloadedContainer) != 0          \n               AS showOpenButton,\n       \n               (SELECT NOT showDownload FROM ShowDownload)\n           AND (SELECT COUNT(*) FROM ActiveContentJobItems) = 0    \n           AND (SELECT COALESCE(\n                       (SELECT cntLastModified\n                          FROM Container\n                         WHERE containerContentEntryUid = :contentEntryUid\n                           AND fileSize > 0\n                      ORDER BY cntLastModified DESC), 0)) \n               > (SELECT COALESCE(\n                         (SELECT cntLastModified\n                            FROM Container\n                           WHERE Container.containerUid = \n                                 (SELECT LatestDownloadedContainer.containerUid\n                                    FROM LatestDownloadedContainer)), 0)) \n               AS showUpdateButton,\n               \n               CAST(:platformDownloadEnabled AS INTEGER) = 1\n           AND (SELECT containerUid FROM LatestDownloadedContainer) != 0\n           AND (SELECT COUNT(*) FROM ActiveContentJobItems) = 0    \n               AS showDeleteButton,\n               \n               (SELECT COUNT(*) \n                  FROM ActiveContentJobItems \n                 WHERE cjiPluginId = 10) > 0\n               AS showManageDownloadButton\n    ")
    public abstract java.lang.Object buttonsToShowForContentEntry(long contentEntryUid, boolean platformDownloadEnabled, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntryButtonModel> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentJobItem.cjiRecursiveStatus AS status\n         FROM ContentJobItem\n        WHERE ContentJobItem.cjiContentEntryUid = :contentEntryUid\n          AND ContentJobItem.cjiPluginId != 14\n          AND ContentJobItem.cjiStatus BETWEEN 4 AND 25\n          AND NOT EXISTS(\n              SELECT 1\n                FROM ContentJobItem ContentJobItemInternal\n               WHERE ContentJobItemInternal.cjiContentEntryUid = :contentEntryUid\n                 AND ContentJobItemInternal.cjiPluginId = 14\n                 AND ContentJobItemInternal.cjiFinishTime > ContentJobItem.cjiStartTime)\n     ORDER BY ContentJobItem.cjiFinishTime DESC\n        LIMIT 1\n    ")
    public abstract java.lang.Object statusForDownloadDialog(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentJobItem.cjiRecursiveStatus AS status, \n               ContentJobItem.cjiRecursiveProgress AS progress,\n               ContentJobItem.cjiRecursiveTotal AS total\n         FROM ContentJobItem\n        WHERE ContentJobItem.cjiContentEntryUid = :contentEntryUid\n          AND ContentJobItem.cjiPluginId != 14\n          AND ContentJobItem.cjiStatus BETWEEN 4 AND 25\n          AND NOT EXISTS(\n              SELECT 1\n                FROM ContentJobItem ContentJobItemInternal\n               WHERE ContentJobItemInternal.cjiContentEntryUid = :contentEntryUid\n                 AND ContentJobItemInternal.cjiPluginId = 14\n                 AND ContentJobItemInternal.cjiFinishTime > ContentJobItem.cjiStartTime)\n     ORDER BY ContentJobItem.cjiFinishTime DESC\n        LIMIT 1\n    ")
    public abstract java.lang.Object statusForContentEntryList(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentJobItemProgressAndStatus> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContentEntryDao$Companion;", "", "()V", "ACTIVE_CONTENT_JOB_ITEMS_CTE_SQL", "", "ALL_ENTRIES_RECURSIVE_SQL", "ENTITY_PERSONS_WITH_PERMISSION", "ENTITY_PERSONS_WITH_PERMISSION_PT1", "ENTITY_PERSONS_WITH_PERMISSION_PT2", "ENTRY_WITH_CONTAINER_QUERY", "LATEST_DOWNLOADED_CONTAINER_CTE_SQL", "PLUGIN_ID_DELETE", "", "PLUGIN_ID_DOWNLOAD", "SORT_TITLE_ASC", "SORT_TITLE_DESC", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}