package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\'J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\'J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\'J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\f\u001a\u00020\bH\'J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\bH\'J\u001f\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0002H\'J/\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u0017\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\'J\u0016\u0010\u001a\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\'J\u0011\u0010\u001c\u001a\u00020\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001e\u001a\u00020\u000f2\b\b\u0001\u0010\u001f\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001d\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContentEntryParentChildJoinDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContentEntryParentChildJoin;", "()V", "all", "", "findJoinByParentChildUuids", "parentUid", "", "childUid", "findListOfChildsByParentUuid", "findListOfParentsByChildUuid", "childEntryContentUid", "findParentByChildUuids", "insertListAsync", "", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertWithReplace", "parentChildJoinDao", "moveListOfEntriesToNewParent", "contentEntryUid", "selectedItems", "updateTime", "(JLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publicContentEntryParentChildJoins", "replaceList", "entries", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selectTopEntries", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "lib-database"})
public abstract class ContentEntryParentChildJoinDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin> {
    
    public ContentEntryParentChildJoinDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ContentEntryParentChildJoinReplicate(cepcjPk, cepcjDestination)\n      SELECT DISTINCT ContentEntryParentChildJoin.cepcjUid AS cepcjUid,\n             :newNodeId AS cepcjDestination\n        FROM ContentEntryParentChildJoin\n       WHERE ContentEntryParentChildJoin.cepcjLct != COALESCE(\n             (SELECT cepcjVersionId\n                FROM ContentEntryParentChildJoinReplicate\n               WHERE cepcjPk = ContentEntryParentChildJoin.cepcjUid\n                 AND cepcjDestination = :newNodeId), -1) \n      /*psql ON CONFLICT(cepcjPk, cepcjDestination) DO UPDATE\n             SET cepcjPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n    REPLACE INTO ContentEntryParentChildJoinReplicate(cepcjPk, cepcjDestination)\n    SELECT DISTINCT ContentEntryParentChildJoin.cepcjUid AS cepcjUid,\n         UserSession.usClientNodeId AS cepcjDestination\n    FROM ChangeLog\n         JOIN ContentEntryParentChildJoin\n             ON ChangeLog.chTableId = 7\n                AND ChangeLog.chEntityPk = ContentEntryParentChildJoin.cepcjUid\n         JOIN UserSession ON UserSession.usStatus = 1\n    WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ContentEntryParentChildJoin.cepcjLct != COALESCE(\n         (SELECT cepcjVersionId\n            FROM ContentEntryParentChildJoinReplicate\n           WHERE cepcjPk = ContentEntryParentChildJoin.cepcjUid\n             AND cepcjDestination = UserSession.usClientNodeId), 0)\n    /*psql ON CONFLICT(cepcjPk, cepcjDestination) DO UPDATE\n     SET cepcjPending = true\n    */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContentEntryParentChildJoin.* FROM ContentEntryParentChildJoin LEFT JOIN ContentEntry parentEntry ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = parentEntry.contentEntryUid LEFT JOIN ContentEntry childEntry ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = childEntry.contentEntryUid WHERE parentEntry.publik AND childEntry.publik")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin> publicContentEntryParentChildJoins();
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM ContentEntryParentChildJoin")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin> all();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = :childEntryContentUid LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin findParentByChildUuids(long childEntryContentUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = :childEntryContentUid")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin> findListOfParentsByChildUuid(long childEntryContentUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = :parentUid")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin> findListOfChildsByParentUuid(long parentUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = :parentUid AND cepcjChildContentEntryUid = :childUid LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin findJoinByParentChildUuids(long parentUid, long childUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContentEntry.* FROM ContentEntry WHERE NOT EXISTS(SELECT cepcjUid FROM ContentEntryParentChildJoin WHERE cepcjChildContentEntryUid = ContentEntry.contentEntryUid) AND EXISTS(SELECT cepcjUid FROM ContentEntryParentChildJoin WHERE cepcjParentContentEntryUid = ContentEntry.contentEntryUid)")
    public abstract java.lang.Object selectTopEntries(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.ContentEntry>> continuation);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract void replaceList(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin> entries);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract void insertWithReplace(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ContentEntryParentChildJoin parentChildJoinDao);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentEntryParentChildJoin \n           SET cepcjParentContentEntryUid = :contentEntryUid, \n               cepcjLct = :updateTime \n               WHERE cepcjUid IN (:selectedItems)\n    ")
    public abstract java.lang.Object moveListOfEntriesToNewParent(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> selectedItems, long updateTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}