package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u0011\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\r\u001a\u00020\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContentEntryPictureDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContentEntryPicture;", "()V", "findByContentEntryUidAsync", "entryUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByContentEntryUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "ContentEntryPicture", "(Lcom/ustadmobile/lib/db/entities/ContentEntryPicture;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ContentEntryPictureDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContentEntryPicture> {
    
    public ContentEntryPictureDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ContentEntryPictureReplicate(cepPk, cepDestination)\n         SELECT DISTINCT cepUid AS cepPK,\n                :newNodeId AS siteDestination\n           FROM ContentEntryPicture\n          WHERE ContentEntryPicture.cepTimestamp != COALESCE(\n                (SELECT cepVersionId\n                   FROM ContentEntryPictureReplicate\n                  WHERE cepPk = ContentEntryPicture.cepUid\n                    AND cepDestination = :newNodeId), -1) \n         /*psql ON CONFLICT(cepPk, cepDestination) DO UPDATE\n                SET cepPending = true\n         */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentEntryPicture.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n  REPLACE INTO ContentEntryPictureReplicate(cepPk, cepDestination)\n         SELECT DISTINCT ContentEntryPicture.cepUid AS cepPk,\n                UserSession.usClientNodeId AS siteDestination\n           FROM ChangeLog\n                JOIN ContentEntryPicture\n                    ON ChangeLog.chTableId = 138\n                       AND ChangeLog.chEntityPk = ContentEntryPicture.cepUid\n                JOIN UserSession ON UserSession.usStatus = 1\n          WHERE UserSession.usClientNodeId != (\n                SELECT nodeClientId \n                  FROM SyncNode\n                 LIMIT 1)\n            AND ContentEntryPicture.cepTimestamp != COALESCE(\n                (SELECT cepVersionId\n                   FROM ContentEntryPictureReplicate\n                  WHERE cepPk = ContentEntryPicture.cepUid\n                    AND cepDestination = UserSession.usClientNodeId), 0)     \n        /*psql ON CONFLICT(cepPk, cepDestination) DO UPDATE\n            SET cepPending = true\n         */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentEntryPicture.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ContentEntryPicture.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM ContentEntryPicture \n         WHERE cepContentEntryUid = :entryUid\n           AND cepActive\n      ORDER BY cepTimestamp DESC \n         LIMIT 1\n         ")
    public abstract java.lang.Object findByContentEntryUidAsync(long entryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentEntryPicture> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n         SELECT * \n          FROM ContentEntryPicture \n         WHERE cepContentEntryUid = :entryUid\n           AND cepActive\n      ORDER BY cepTimestamp DESC \n         LIMIT 1\n         ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ContentEntryPicture> findByContentEntryUidLive(long entryUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ContentEntryPicture ContentEntryPicture, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}