package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\'J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\'J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\'J\u0011\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u00020\u00112\b\b\u0001\u0010\u0014\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0002H\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContentEntryRelatedEntryJoinDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContentEntryRelatedEntryJoin;", "()V", "findAllTranslationsForContentEntryAsync", "", "Lcom/ustadmobile/lib/db/entities/ContentEntryRelatedEntryJoinWithLangName;", "contentEntryUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllTranslationsWithContentEntryUid", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/ContentEntryRelatedEntryJoinWithLanguage;", "findPrimaryByTranslation", "publicContentEntryRelatedEntryJoins", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "update", "entity", "lib-database"})
public abstract class ContentEntryRelatedEntryJoinDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin> {
    
    public ContentEntryRelatedEntryJoinDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO ContentEntryRelatedEntryJoinReplicate(cerejPk, cerejDestination)\n      SELECT DISTINCT ContentEntryRelatedEntryJoin.cerejUid AS cerejPk,\n             :newNodeId AS cerejDestination\n        FROM ContentEntryRelatedEntryJoin\n       WHERE ContentEntryRelatedEntryJoin.cerejLct != COALESCE(\n             (SELECT cerejVersionId\n                FROM ContentEntryRelatedEntryJoinReplicate\n               WHERE cerejPk = ContentEntryRelatedEntryJoin.cerejUid\n                 AND cerejDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(cerejPk, cerejDestination) DO UPDATE\n             SET cerejPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ContentEntryRelatedEntryJoinReplicate(cerejPk, cerejDestination)\n  SELECT DISTINCT ContentEntryRelatedEntryJoin.cerejUid AS cerejUid,\n         UserSession.usClientNodeId AS cerejDestination\n    FROM ChangeLog\n         JOIN ContentEntryRelatedEntryJoin\n             ON ChangeLog.chTableId = 8\n                AND ChangeLog.chEntityPk = ContentEntryRelatedEntryJoin.cerejUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ContentEntryRelatedEntryJoin.cerejLct != COALESCE(\n         (SELECT cerejVersionId\n            FROM ContentEntryRelatedEntryJoinReplicate\n           WHERE cerejPk = ContentEntryRelatedEntryJoin.cerejUid\n             AND cerejDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(cerejPk, cerejDestination) DO UPDATE\n     SET cerejPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContentEntryRelatedEntryJoin.* FROM ContentEntryRelatedEntryJoin LEFT JOIN ContentEntry ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntry.publik")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin> publicContentEntryRelatedEntryJoins();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = :contentEntryUid LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin findPrimaryByTranslation(long contentEntryUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT ContentEntryRelatedEntryJoin.cerejContentEntryUid, ContentEntryRelatedEntryJoin.cerejRelatedEntryUid, CASE ContentEntryRelatedEntryJoin.cerejRelatedEntryUid WHEN :contentEntryUid THEN (SELECT name FROM Language WHERE langUid = (SELECT primaryLanguageUid FROM ContentEntry WHERE contentEntryUid = ContentEntryRelatedEntryJoin.cerejContentEntryUid)) ELSE Language.name END languageName FROM ContentEntryRelatedEntryJoin LEFT JOIN Language ON ContentEntryRelatedEntryJoin.cerejRelLanguageUid = Language.langUid WHERE (ContentEntryRelatedEntryJoin.cerejContentEntryUid = :contentEntryUid OR ContentEntryRelatedEntryJoin.cerejContentEntryUid IN (SELECT cerejContentEntryUid FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = :contentEntryUid)) AND ContentEntryRelatedEntryJoin.relType = 1")
    @java.lang.Deprecated()
    public abstract java.lang.Object findAllTranslationsForContentEntryAsync(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLangName>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT ContentEntryRelatedEntryJoin.*, Language.* FROM ContentEntryRelatedEntryJoin\n        LEFT JOIN Language ON ContentEntryRelatedEntryJoin.cerejRelLanguageUid = Language.langUid\n        WHERE (ContentEntryRelatedEntryJoin.cerejContentEntryUid = :contentEntryUid\n        OR ContentEntryRelatedEntryJoin.cerejContentEntryUid IN\n        (SELECT cerejContentEntryUid FROM ContentEntryRelatedEntryJoin WHERE cerejRelatedEntryUid = :contentEntryUid))\n        AND ContentEntryRelatedEntryJoin.relType = 1\n        ORDER BY Language.name")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoinWithLanguage> findAllTranslationsWithContentEntryUid(long contentEntryUid);
    
    @java.lang.Override()
    @androidx.room.Update()
    public abstract void update(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ContentEntryRelatedEntryJoin entity);
}