package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u001b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\n2\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u0006H\'J\u0019\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0004H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ!\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContentJobDao;", "", "()V", "findByUid", "Lcom/ustadmobile/lib/db/entities/ContentJob;", "cjUid", "", "findByUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findLiveDataByUid", "Lcom/ustadmobile/door/DoorLiveData;", "findMeteredAllowedLiveData", "", "contentJobId", "insertAsync", "contentJob", "(Lcom/ustadmobile/lib/db/entities/ContentJob;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isConnectivityAcceptableForJob", "jobId", "updateDestinationDir", "", "toUri", "", "(JLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateMeteredAllowedForEntry", "contentEntryUid", "meteredAllowed", "(JZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ContentJobDao {
    
    public ContentJobDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ContentJob contentJob, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentJob.*\n          FROM ContentJob\n         WHERE cjUid = :cjUid \n    ")
    public abstract com.ustadmobile.lib.db.entities.ContentJob findByUid(long cjUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentJob.*\n          FROM ContentJob\n         WHERE cjUid = :cjUid \n    ")
    public abstract java.lang.Object findByUidAsync(long cjUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentJob> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT ContentJob.*\n          FROM ContentJob\n         WHERE cjUid = :cjUid\n    ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ContentJob> findLiveDataByUid(long cjUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJob\n           SET toUri = :toUri\n         WHERE cjUid = :cjUid\n    ")
    public abstract java.lang.Object updateDestinationDir(long cjUid, @org.jetbrains.annotations.NotNull()
    java.lang.String toUri, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.PostgresQuery(value = "\n        SELECT COALESCE((SELECT ContentJob.cjIsMeteredAllowed\n          FROM ContentJob\n         WHERE cjUid = :contentJobId\n         LIMIT 1), FALSE)\n    ")
    @androidx.room.Query(value = "\n        SELECT COALESCE((SELECT ContentJob.cjIsMeteredAllowed\n          FROM ContentJob\n         WHERE cjUid = :contentJobId\n         LIMIT 1), 0)\n    ")
    public abstract com.ustadmobile.door.DoorLiveData<java.lang.Boolean> findMeteredAllowedLiveData(long contentJobId);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJob \n           SET cjIsMeteredAllowed = :meteredAllowed\n         WHERE cjUid IN (SELECT cjiJobUid \n                           FROM ContentJobItem\n                          WHERE cjiContentEntryUid = :contentEntryUid\n                             OR cjiParentContentEntryUid = :contentEntryUid)\n    ")
    public abstract java.lang.Object updateMeteredAllowedForEntry(long contentEntryUid, boolean meteredAllowed, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    /**
     * This query is only called when connectivity IS needed, so there is no need for the job item id.
     * It's only purpose is to check if the connectivity is acceptable for the job
     * e.g. connectivity == unmetered or (connectivity == metered and meteredNetworkAllowed == true)
     */
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n          WITH ConnectivityStateCte(state) AS \n             (SELECT COALESCE(\n                     (SELECT connectivityState \n                        FROM ConnectivityStatus \n                       LIMIT 1), 0))\n   \n           SELECT COALESCE((\n                  SELECT 1 \n                    FROM ContentJob \n                   WHERE cjUid = :jobId\n                    AND ((cjIsMeteredAllowed \n                         AND (SELECT state FROM ConnectivityStateCte) = 3)\n\t\t\t             OR (SELECT state FROM ConnectivityStateCte) = 4)\n                  ) ,0)\n    ")
    public abstract java.lang.Object isConnectivityAcceptableForJob(long jobId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
}