package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u000b\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\u0006\u0010\u0012\u001a\u00020\fH\'J\u001f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\u0014\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\'\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00062\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\fH\'J\u0019\u0010\u001e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0018\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\"2\u0006\u0010 \u001a\u00020\fH\'J\u0019\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u001f\u0010&\u001a\u00020\u00042\f\u0010\'\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0019\u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ!\u0010*\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010+\u001a\u00020\u001bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ!\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020)H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J!\u00100\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\f2\u0006\u00101\u001a\u00020)H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J!\u00102\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J!\u00104\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u00105\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J!\u00106\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u00107\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J)\u00108\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J!\u0010<\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010=\u001a\u00020\u001bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ)\u0010>\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010@J!\u0010A\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010B\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J!\u0010C\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010D\u001a\u00020EH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010F\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006G"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContentJobItemDao;", "", "()V", "commitProgressUpdates", "", "updates", "", "Lcom/ustadmobile/lib/db/entities/ContentJobItemProgressUpdate;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findActiveContentJobItems", "Lcom/ustadmobile/lib/db/entities/ContentJobItemProgress;", "contentEntryUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAll", "Lcom/ustadmobile/lib/db/entities/ContentJobItem;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllByJobId", "jobId", "findAllContainersByJobUid", "jobUid", "findByUidAsync", "cjiUid", "findNextItemsInQueue", "Lcom/ustadmobile/lib/db/entities/ContentJobItemAndContentJob;", "contentJobUid", "limit", "", "(JILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findRootJobItemByJobId", "getActiveContentJobIdByContentEntryUid", "getContainerUidByJobItemUid", "uid", "getJobItemByUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "insertJobItem", "jobItem", "(Lcom/ustadmobile/lib/db/entities/ContentJobItem;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertJobItems", "jobItems", "isJobDone", "", "updateAllStatusesByJobUid", "newStatus", "updateConnectivityNeeded", "contentJobItemId", "connectivityNeeded", "(JZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateContainerProcessed", "cjiContainerProcessed", "updateContentEntryUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateContentJobItemContainer", "containerUid", "updateFinishTimeForJob", "finishTime", "updateItemProgress", "cjiProgress", "cjiTotal", "(JJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateItemStatus", "status", "updateJobItemAttemptCountAndStatus", "attemptCount", "(JIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateStartTimeForJob", "startTime", "updateUploadSessionUuid", "uploadSessionUuid", "", "(JLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ContentJobItemDao {
    
    public ContentJobItemDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        WITH ConnectivityStateCte(state) AS \n             (SELECT COALESCE(\n                     (SELECT connectivityState \n                        FROM ConnectivityStatus \n                       LIMIT 1), 0))\n                       \n        SELECT ContentJobItem.*, ContentJob.*\n          FROM ContentJobItem\n               JOIN ContentJob\n               ON ContentJobItem.cjiJobUid = ContentJob.cjUid\n         WHERE ContentJobItem.cjiJobUid = :contentJobUid\n           AND (ContentJobItem.cjiStatus = 4 OR \n                ContentJobItem.cjiStatus = 5)\n           AND (\n                NOT cjiConnectivityNeeded \n                OR ((SELECT state FROM ConnectivityStateCte) = 4) \n                OR (cjIsMeteredAllowed \n                    AND (SELECT state FROM ConnectivityStateCte) = 3)\n                )\n         LIMIT :limit\n    ")
    public abstract java.lang.Object findNextItemsInQueue(long contentJobUid, int limit, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContentJobItemAndContentJob>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT cjiRecursiveProgress AS progress, \n               cjiRecursiveTotal AS total, \n               cjNotificationTitle as progressTitle,\n               ContentJobItem.cjiUid\n          FROM ContentJobItem\n          JOIN ContentJob\n            ON ContentJob.cjUid = ContentJobItem.cjiJobUid\n         WHERE cjiContentEntryUid = :contentEntryUid\n           AND cjiRecursiveStatus >= 4\n           AND cjiRecursiveStatus <= 20\n      ORDER BY cjiStartTime DESC\n    ")
    public abstract java.lang.Object findActiveContentJobItems(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContentJobItemProgress>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertJobItem(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ContentJobItem jobItem, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertJobItems(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.ContentJobItem> jobItems, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem \n           SET cjiStatus = :status\n         WHERE cjiUid= :cjiUid  \n    ")
    public abstract java.lang.Object updateItemStatus(long cjiUid, int status, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT NOT EXISTS(\n               SELECT cjiUid \n                 FROM ContentJobItem\n                WHERE cjiJobUid = :jobUid\n                  AND cjiStatus < 21) \n    ")
    public abstract java.lang.Object isJobDone(long jobUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM ContentJobItem\n         WHERE cjiJobUid = :jobUid \n           AND cjiParentCjiUid = 0 \n         LIMIT 1\n    ")
    public abstract com.ustadmobile.lib.db.entities.ContentJobItem findRootJobItemByJobId(long jobUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem\n           SET cjiItemProgress = :cjiProgress,\n               cjiItemTotal = :cjiTotal\n         WHERE cjiUid = :cjiUid     \n    ")
    public abstract java.lang.Object updateItemProgress(long cjiUid, long cjiProgress, long cjiTotal, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem\n           SET cjiConnectivityNeeded = :connectivityNeeded\n         WHERE cjiUid = :contentJobItemId     \n    ")
    public abstract java.lang.Object updateConnectivityNeeded(long contentJobItemId, boolean connectivityNeeded, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem\n           SET cjiContainerProcessed = :cjiContainerProcessed\n         WHERE cjiUid = :contentJobItemId   \n    ")
    public abstract java.lang.Object updateContainerProcessed(long contentJobItemId, boolean cjiContainerProcessed, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Transaction()
    public java.lang.Object commitProgressUpdates(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.ContentJobItemProgressUpdate> updates, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem\n           SET cjiStatus = :status,\n               cjiAttemptCount = :attemptCount\n         WHERE cjiUid = :cjiUid      \n    ")
    public abstract java.lang.Object updateJobItemAttemptCountAndStatus(long cjiUid, int attemptCount, int status, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem\n           SET cjiStartTime = :startTime\n         WHERE cjiUid = :cjiUid      \n    ")
    public abstract java.lang.Object updateStartTimeForJob(long cjiUid, long startTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem\n           SET cjiFinishTime = :finishTime\n         WHERE cjiUid = :cjiUid      \n    ")
    public abstract java.lang.Object updateFinishTimeForJob(long cjiUid, long finishTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobITem\n           SET cjiContentEntryUid = :contentEntryUid\n         WHERE cjiUid = :cjiUid  \n    ")
    public abstract java.lang.Object updateContentEntryUid(long cjiUid, long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem\n           SET cjiContainerUid = :containerUid\n         WHERE cjiUid = :cjiUid  \n    ")
    public abstract java.lang.Object updateContentJobItemContainer(long cjiUid, long containerUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM ContentJobItem\n    ")
    public abstract java.lang.Object findAll(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ContentJobItem>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentJobItem.*\n          FROM ContentJobItem\n         WHERE cjiUid = :cjiUid \n    ")
    public abstract java.lang.Object findByUidAsync(long cjiUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ContentJobItem> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT COALESCE(\n               (SELECT ContentJobItem.cjiJobUid\n                  FROM ContentJobItem\n                 WHERE cjiContentEntryUid = :contentEntryUid\n                   AND cjiStatus BETWEEN 4 AND 20\n              ORDER BY cjiFinishTime DESC), 0)\n    ")
    public abstract java.lang.Object getActiveContentJobIdByContentEntryUid(long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem\n           SET cjiUploadSessionUid = :uploadSessionUuid\n         WHERE cjiUid = :cjiUid  \n    ")
    public abstract java.lang.Object updateUploadSessionUuid(long cjiUid, @org.jetbrains.annotations.NotNull()
    java.lang.String uploadSessionUuid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM ContentJobItem\n         WHERE cjiJobUid = :jobId \n    ")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.ContentJobItem> findAllByJobId(long jobId);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT *\n          FROM ContentJobItem\n         WHERE cjiUid = :uid   \n    ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.ContentJobItem> getJobItemByUidLive(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT cjiContainerUid\n          FROM ContentJobItem\n         WHERE cjiUid = :uid \n    ")
    public abstract java.lang.Object getContainerUidByJobItemUid(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE ContentJobItem\n           SET cjiStatus = :newStatus\n         WHERE cjiJobUid = :jobUid\n           AND cjiStatus != :newStatus\n    ")
    public abstract java.lang.Object updateAllStatusesByJobUid(long jobUid, int newStatus, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ContentJobItem.cjiContainerUid\n          FROM ContentJobItem\n         WHERE cjiJobUid = :jobUid \n    ")
    public abstract java.lang.Object findAllContainersByJobUid(long jobUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.Long>> continuation);
}