package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\'\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\'J\u0011\u0010\b\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000b\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContextXObjectStatementJoinDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContextXObjectStatementJoin;", "()V", "findByStatementAndObjectUid", "statementUid", "", "objectUid", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class ContextXObjectStatementJoinDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.ContextXObjectStatementJoinDao.Companion Companion = null;
    public static final int CONTEXT_FLAG_PARENT = 0;
    public static final int CONTEXT_FLAG_CATEGORY = 1;
    public static final int CONTEXT_FLAG_GROUPING = 2;
    public static final int CONTEXT_FLAG_OTHER = 3;
    
    public ContextXObjectStatementJoinDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n    REPLACE INTO ContextXObjectStatementJoinReplicate(cxosjPk, cxosjDestination)\n    SELECT DISTINCT ContextXObjectStatementJoin.contextXObjectStatementJoinUid AS cxosjPk,\n         UserSession.usClientNodeId AS cxosjDestination\n    FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             JOIN ScopedGrant\n                  ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                     AND (ScopedGrant.sgPermissions & 549755813888) > 0\n             JOIN StatementEntity\n                  ON \n            ((ScopedGrant.sgTableId = -2\n                AND ScopedGrant.sgEntityUid = -2)\n             OR (ScopedGrant.sgTableId = 9\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n             OR (ScopedGrant.sgTableId = 6\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n             OR (ScopedGrant.sgTableId = 164\n                AND ScopedGrant.sgEntityUid = (\n                    SELECT clazzSchoolUid\n                      FROM Clazz \n                     WHERE clazzUid = StatementEntity.statementClazzUid))\n            )         \n        \n             JOIN ContextXObjectStatementJoin\n                  ON ContextXObjectStatementJoin.contextStatementUid = StatementEntity.statementUid\n   WHERE UserSession.usClientNodeId = :newNodeId\n     -- Temporary measure to prevent admin user getting clogged up\n     -- Restrict to the last 30 days of data\n     AND StatementEntity.timestamp > ( \n   --notpsql\n   strftime(\'%s\', \'now\') * 1000\n   --endnotpsql\n   /*psql\n   ROUND(EXTRACT(epoch from NOW())*1000)\n   */\n   - (30 * CAST(86400000 AS BIGINT)))   \n    --notpsql \n     AND ContextXObjectStatementJoin.contextXObjectLct != COALESCE(\n         (SELECT cxosjVersionId\n            FROM ContextXObjectStatementJoinReplicate\n           WHERE cxosjPk = ContextXObjectStatementJoin.contextXObjectStatementJoinUid\n             AND cxosjDestination = UserSession.usClientNodeId), 0) \n    --endnotpsql         \n    /*psql ON CONFLICT(cxosjPk, cxosjDestination) DO UPDATE\n     SET cxosjPending = (SELECT ContextXObjectStatementJoin.contextXObjectLct\n                           FROM ContextXObjectStatementJoin\n                          WHERE ContextXObjectStatementJoin.contextXObjectStatementJoinUid = EXCLUDED.cxosjPk ) \n                                != ContextXObjectStatementJoinReplicate.cxosjVersionId             \n    */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n    REPLACE INTO ContextXObjectStatementJoinReplicate(cxosjPk, cxosjDestination)\n    SELECT DISTINCT ContextXObjectStatementJoin.contextXObjectStatementJoinUid AS cxosjUid,\n         UserSession.usClientNodeId AS cxosjDestination\n    FROM ChangeLog\n         JOIN ContextXObjectStatementJoin\n             ON ChangeLog.chTableId = 66\n                AND ChangeLog.chEntityPk = ContextXObjectStatementJoin.contextXObjectStatementJoinUid\n         JOIN StatementEntity\n               ON ContextXObjectStatementJoin.contextStatementUid = StatementEntity.statementUid\n         JOIN ScopedGrant\n              ON \n            ((ScopedGrant.sgTableId = -2\n                AND ScopedGrant.sgEntityUid = -2)\n             OR (ScopedGrant.sgTableId = 9\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementPersonUid)\n             OR (ScopedGrant.sgTableId = 6\n                AND ScopedGrant.sgEntityUid = StatementEntity.statementClazzUid)\n             OR (ScopedGrant.sgTableId = 164\n                AND ScopedGrant.sgEntityUid = (\n                    SELECT clazzSchoolUid\n                      FROM Clazz\n                     WHERE clazzUid = StatementEntity.statementClazzUid))\n             )\n        \n                 AND (ScopedGrant.sgPermissions & 549755813888) > 0\n         JOIN PersonGroupMember\n              ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n         JOIN UserSession\n              ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n                 AND UserSession.usStatus = 1\n    WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n   --notpsql       \n     AND ContextXObjectStatementJoin.contextXObjectLct != COALESCE(\n         (SELECT cxosjVersionId\n            FROM ContextXObjectStatementJoinReplicate\n           WHERE cxosjPk = ContextXObjectStatementJoin.contextXObjectStatementJoinUid\n             AND cxosjDestination = UserSession.usClientNodeId), 0)\n    --endnotpsql\n    /*psql ON CONFLICT(cxosjPk, cxosjDestination) DO UPDATE\n     SET cxosjPending = (SELECT ContextXObjectStatementJoin.contextXObjectLct\n                           FROM ContextXObjectStatementJoin\n                          WHERE ContextXObjectStatementJoin.contextXObjectStatementJoinUid = EXCLUDED.cxosjPk ) \n                                != ContextXObjectStatementJoinReplicate.cxosjVersionId             \n    */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM ContextXObjectStatementJoin where contextStatementUid = :statementUid and contextXObjectUid = :objectUid")
    public abstract com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin findByStatementAndObjectUid(long statementUid, long objectUid);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2 = {"Lcom/ustadmobile/core/db/dao/ContextXObjectStatementJoinDao$Companion;", "", "()V", "CONTEXT_FLAG_CATEGORY", "", "CONTEXT_FLAG_GROUPING", "CONTEXT_FLAG_OTHER", "CONTEXT_FLAG_PARENT", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}