package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\'J \u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\'J\u0011\u0010\f\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000f\u001a\u00020\r2\b\b\u0001\u0010\u0010\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2 = {"Lcom/ustadmobile/core/db/dao/CourseAssignmentMarkDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseAssignmentMark;", "()V", "findNextSubmitterToMarkForAssignment", "", "assignmentUid", "submitterUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMarkOfAssignmentForStudent", "getMarkOfAssignmentForSubmitterLiveData", "Lcom/ustadmobile/door/DoorLiveData;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class CourseAssignmentMarkDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.CourseAssignmentMark> {
    
    public CourseAssignmentMarkDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO CourseAssignmentMarkReplicate(camPk, camDestination)\n      SELECT DISTINCT CourseAssignmentMark.camUid AS camPk,\n             :newNodeId AS camDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    8388608 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n               JOIN ClazzAssignment\n                    ON ClazzAssignment.caClazzUid = Clazz.clazzUid                \n             JOIN CourseAssignmentMark\n                    ON CourseAssignmentMark.camAssignmentUid = ClazzAssignment.caUid\n                    \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND CourseAssignmentMark.camLct != COALESCE(\n             (SELECT camVersionId\n                FROM CourseAssignmentMarkReplicate\n               WHERE camPk = CourseAssignmentMark.camUid\n                 AND camDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(camPk, camDestination) DO UPDATE\n             SET camPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseAssignmentMark.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO CourseAssignmentMarkReplicate(camPk, camDestination)\n  SELECT DISTINCT CourseAssignmentMark.camUid AS camPk,\n         UserSession.usClientNodeId AS camDestination\n    FROM ChangeLog\n         JOIN CourseAssignmentMark\n             ON ChangeLog.chTableId = 523\n                AND ChangeLog.chEntityPk = CourseAssignmentMark.camUid\n             JOIN ClazzAssignment\n                    ON CourseAssignmentMark.camAssignmentUid = ClazzAssignment.caUid\n             JOIN Clazz\n                    ON  Clazz.clazzUid = ClazzAssignment.caClazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              8388608\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n          \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND CourseAssignmentMark.camLct != COALESCE(\n         (SELECT camVersionId\n            FROM CourseAssignmentMarkReplicate\n           WHERE camPk = CourseAssignmentMark.camUid\n             AND camDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(camPk, camDestination) DO UPDATE\n     SET camPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseAssignmentMark.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.CourseAssignmentMark.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM CourseAssignmentMark               \n         WHERE camAssignmentUid = :assignmentUid\n           AND camSubmitterUid = :submitterUid\n      ORDER BY camLct DESC\n         LIMIT 1\n    ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.CourseAssignmentMark> getMarkOfAssignmentForSubmitterLiveData(long assignmentUid, long submitterUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM CourseAssignmentMark\n         WHERE camAssignmentUid = :assignmentUid\n           AND camSubmitterUid = :submitterUid\n      ORDER BY camLct DESC\n         LIMIT 1\n    ")
    public abstract com.ustadmobile.lib.db.entities.CourseAssignmentMark getMarkOfAssignmentForStudent(long assignmentUid, long submitterUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n         SELECT COALESCE((\n            SELECT casSubmitterUid\n              FROM CourseAssignmentSubmission\n              \n                   LEFT JOIN CourseAssignmentMark\n                   ON CourseAssignmentMark.camSubmitterUid = CourseAssignmentSubmission.casSubmitterUid\n                   AND CourseAssignmentMark.camAssignmentUid = :assignmentUid\n                   \n             WHERE CourseAssignmentSubmission.casSubmitterUid != :submitterUid\n               AND CourseAssignmentMark.camUid IS NULL\n          GROUP BY casSubmitterUid\n         LIMIT 1),0)\n    ")
    public abstract java.lang.Object findNextSubmitterToMarkForAssignment(long assignmentUid, long submitterUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
}