package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\t\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000b\u001a\u00020\u00052\b\b\u0001\u0010\f\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2 = {"Lcom/ustadmobile/core/db/dao/CourseAssignmentSubmissionAttachmentDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseAssignmentSubmissionAttachment;", "()V", "insertListAsync", "", "entityList", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class CourseAssignmentSubmissionAttachmentDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment> {
    
    public CourseAssignmentSubmissionAttachmentDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO CourseAssignmentSubmissionAttachmentReplicate(casaPk, casaDestination)\n      SELECT DISTINCT CourseAssignmentSubmissionAttachment.casaUid AS casaPk,\n             :newNodeId AS casaDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    8388608 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n             JOIN ClazzAssignment\n                  ON ClazzAssignment.caClazzUid = Clazz.clazzUid                \n             JOIN CourseAssignmentSubmission\n                  ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n             JOIN CourseAssignmentSubmissionAttachment\n                  ON CourseAssignmentSubmissionAttachment.casaSubmissionUid = CourseAssignmentSubmission.casUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND CourseAssignmentSubmissionAttachment.casaTimestamp != COALESCE(\n             (SELECT casaVersionId\n                FROM CourseAssignmentSubmissionAttachmentReplicate\n               WHERE casaPk = CourseAssignmentSubmissionAttachment.casaUid\n                 AND casaDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(casaPk, casaDestination) DO UPDATE\n             SET casaPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO CourseAssignmentSubmissionAttachmentReplicate(casaPk, casaDestination)\n  SELECT DISTINCT CourseAssignmentSubmissionAttachment.casaUid AS casaPk,\n         UserSession.usClientNodeId AS casaDestination\n    FROM ChangeLog\n         JOIN CourseAssignmentSubmissionAttachment\n             ON ChangeLog.chTableId = 90\n                AND ChangeLog.chEntityPk = CourseAssignmentSubmissionAttachment.casaUid\n             JOIN CourseAssignmentSubmission\n                  ON CourseAssignmentSubmissionAttachment.casaSubmissionUid = CourseAssignmentSubmission.casUid   \n             JOIN ClazzAssignment\n                    ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n             JOIN Clazz\n                    ON  Clazz.clazzUid = ClazzAssignment.caClazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              8388608\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n          \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND CourseAssignmentSubmissionAttachment.casaTimestamp != COALESCE(\n         (SELECT casaVersionId\n            FROM CourseAssignmentSubmissionAttachmentReplicate\n           WHERE casaPk = CourseAssignmentSubmissionAttachment.casaUid\n             AND casaDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(casaPk, casaDestination) DO UPDATE\n     SET casaPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionAttachment> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}