package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\b\'\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\'J!\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ!\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ#\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\'J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\'J\u001f\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0011\u0010\u0018\u001a\u00020\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u001b\u0010\u001a\u001a\u00020\u00142\b\b\u0001\u0010\u001b\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2 = {"Lcom/ustadmobile/core/db/dao/CourseAssignmentSubmissionDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseAssignmentSubmission;", "()V", "checkNoSubmissionsMade", "Lcom/ustadmobile/door/DoorLiveData;", "", "assignmentUid", "", "countFileSubmissionFromStudent", "", "submitterUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "countSubmissionsFromSubmitter", "findLastSubmissionFromStudent", "getAllSubmissionsFromSubmitter", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "Lcom/ustadmobile/lib/db/entities/CourseAssignmentSubmissionWithAttachment;", "getStatusOfAssignmentForSubmitter", "insertListAsync", "", "entityList", "", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class CourseAssignmentSubmissionDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.CourseAssignmentSubmission> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.CourseAssignmentSubmissionDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String GET_SUBMITTERID_FROM_STUDENT = "\n             (CASE WHEN ClazzAssignment.caGroupUid = 0\n                                       THEN :studentUid\n                                       ELSE COALESCE((SELECT cgmGroupNumber \n                                                       FROM CourseGroupMember\n                                                      WHERE cgmSetUid = ClazzAssignment.caGroupUid\n                                                        AND cgmPersonUid = :studentUid\n                                                      LIMIT 1),0))\n        ";
    
    public CourseAssignmentSubmissionDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO CourseAssignmentSubmissionReplicate(casPk, casDestination)\n      SELECT DISTINCT CourseAssignmentSubmission.casUid AS casPk,\n             :newNodeId AS casDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    8388608 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n               JOIN ClazzAssignment\n                    ON ClazzAssignment.caClazzUid = Clazz.clazzUid                \n             JOIN CourseAssignmentSubmission\n                    ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND CourseAssignmentSubmission.casTimestamp != COALESCE(\n             (SELECT casVersionId\n                FROM CourseAssignmentSubmissionReplicate\n               WHERE casPk = CourseAssignmentSubmission.casUid\n                 AND casDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(casPk, casDestination) DO UPDATE\n             SET casPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseAssignmentSubmission.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO CourseAssignmentSubmissionReplicate(casPk, casDestination)\n  SELECT DISTINCT CourseAssignmentSubmission.casUid AS casPk,\n         UserSession.usClientNodeId AS casDestination\n    FROM ChangeLog\n         JOIN CourseAssignmentSubmission\n             ON ChangeLog.chTableId = 522\n                AND ChangeLog.chEntityPk = CourseAssignmentSubmission.casUid\n             JOIN ClazzAssignment\n                    ON CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n             JOIN Clazz\n                    ON  Clazz.clazzUid = ClazzAssignment.caClazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              8388608\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n          \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND CourseAssignmentSubmission.casTimestamp != COALESCE(\n         (SELECT casVersionId\n            FROM CourseAssignmentSubmissionReplicate\n           WHERE casPk = CourseAssignmentSubmission.casUid\n             AND casDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(casPk, casDestination) DO UPDATE\n     SET casPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseAssignmentSubmission.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.CourseAssignmentSubmission.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.CourseAssignmentSubmission> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM CourseAssignmentSubmission\n          \n               LEFT JOIN CourseAssignmentSubmissionAttachment\n               ON CourseAssignmentSubmissionAttachment.casaSubmissionUid = CourseAssignmentSubmission.casUid\n               \n         WHERE casAssignmentUid = :assignmentUid\n           AND casSubmitterUid = :submitterUid\n      ORDER BY casTimestamp DESC\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.CourseAssignmentSubmissionWithAttachment> getAllSubmissionsFromSubmitter(long assignmentUid, long submitterUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT Count(casUid)\n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = :assignmentUid\n           AND casSubmitterUid = :submitterUid\n           AND casType = 2\n    ")
    public abstract java.lang.Object countFileSubmissionFromStudent(long assignmentUid, long submitterUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT Count(casUid)\n          FROM CourseAssignmentSubmission\n         WHERE casAssignmentUid = :assignmentUid\n           AND casSubmitterUid = :submitterUid\n    ")
    public abstract java.lang.Object countSubmissionsFromSubmitter(long assignmentUid, long submitterUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n           SELECT COALESCE((\n                SELECT (CASE WHEN CourseAssignmentMark.camAssignmentUid IS NOT NULL \n                             THEN 2\n                             ELSE 1 \n                             END) AS status\n                  FROM CourseAssignmentSubmission\n                       \n                       LEFT JOIN CourseAssignmentMark\n                       ON CourseAssignmentMark.camAssignmentUid = :assignmentUid\n                       AND CourseAssignmentMark.camSubmitterUid = :submitterUid\n                       \n                 WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n                   AND CourseAssignmentSubmission.casSubmitterUid = :submitterUid\n                 LIMIT 1\n           ),0) AS Status\n    ")
    public abstract com.ustadmobile.door.DoorLiveData<java.lang.Integer> getStatusOfAssignmentForSubmitter(long assignmentUid, long submitterUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM CourseAssignmentSubmission\n         WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n           AND CourseAssignmentSubmission.casSubmitterUid = :submitterUid\n      ORDER BY casTimestamp DESC\n         LIMIT 1\n    ")
    public abstract java.lang.Object findLastSubmissionFromStudent(long submitterUid, long assignmentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.CourseAssignmentSubmission> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n         SELECT NOT EXISTS(SELECT 1\n                        FROM CourseAssignmentSubmission\n                       WHERE CourseAssignmentSubmission.casAssignmentUid = :assignmentUid\n                       LIMIT 1)\n    ")
    public abstract com.ustadmobile.door.DoorLiveData<java.lang.Boolean> checkNoSubmissionsMade(long assignmentUid);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2 = {"Lcom/ustadmobile/core/db/dao/CourseAssignmentSubmissionDao$Companion;", "", "()V", "GET_SUBMITTERID_FROM_STUDENT", "", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}