package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0006\b\'\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0004J\'\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b2\u0006\u0010\u000e\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ:\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0016\u001a\u00020\tH\'J\u001b\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0019\u001a\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0011\u0010\u001c\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001e\u001a\u00020\u00062\b\b\u0001\u0010\u001f\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ)\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\n\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0019\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2 = {"Lcom/ustadmobile/core/db/dao/CourseBlockDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseBlock;", "Lcom/ustadmobile/core/db/dao/OneToManyJoinDao;", "()V", "deactivateByUids", "", "uidList", "", "", "changeTime", "(Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllCourseBlockByClazzUidAsync", "Lcom/ustadmobile/lib/db/entities/CourseBlockWithEntityDb;", "clazzUid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findAllCourseBlockByClazzUidLive", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/CourseBlockWithCompleteEntity;", "personUid", "collapseList", "currentTime", "findByUidAsync", "uid", "replaceListAsync", "list", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateActiveByUid", "cbUid", "active", "", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/CourseBlock;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class CourseBlockDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.CourseBlock>, com.ustadmobile.core.db.dao.OneToManyJoinDao<com.ustadmobile.lib.db.entities.CourseBlock> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.CourseBlockDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String SUBMITTER_LIST_IN_CLAZZ_CTE = "\n            SubmitterList (submitterId, assignmentUid)\n            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId,\n                       ClazzAssignment.caUid AS assignmentUid\n                  \n                  FROM ClazzEnrolment\n                  \n                       JOIN Person \n                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                        \n                       JOIN ClazzAssignment\n                       ON ClazzAssignment.caClazzUid = :clazzUid\n\n                       JOIN CourseBlock\n                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n                       AND CourseBlock.cbType = 103\n                       \n                 WHERE ClazzAssignment.caGroupUid = 0\n                   AND clazzEnrolmentClazzUid = :clazzUid\n                   AND clazzEnrolmentActive\n                   AND clazzEnrolmentRole = 1000\n                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft\n                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate\n              GROUP BY submitterId, assignmentUid\n            UNION                 \n             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                    ClazzAssignment.caUid AS assignmentUid\n               FROM CourseGroupMember\n                    JOIN ClazzAssignment\n                    ON ClazzAssignment.caClazzUid = :clazzUid\n              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid\n                AND ClazzAssignment.caGroupUid != 0\n                AND CourseGroupMember.cgmGroupNumber != 0\n           GROUP BY submitterId, assignmentUid\n            )\n        ";
    
    public CourseBlockDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n    REPLACE INTO CourseBlockReplicate(cbPk, cbDestination)\n      SELECT DISTINCT CourseBlock.cbUid AS cbPk,\n             :newNodeId AS cbDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    2 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n               JOIN CourseBlock\n                    ON CourseBlock.cbClazzUid = Clazz.clazzUid                \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND CourseBlock.cbLct != COALESCE(\n             (SELECT cbVersionId\n                FROM CourseBlockReplicate\n               WHERE cbPk = CourseBlock.cbUid\n                 AND cbDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(cbPk, cbDestination) DO UPDATE\n             SET cbPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseBlock.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n         REPLACE INTO CourseBlockReplicate(cbPk, cbDestination)\n  SELECT DISTINCT CourseBlock.cbUid AS cbPk,\n         UserSession.usClientNodeId AS cbDestination\n    FROM ChangeLog\n         JOIN CourseBlock\n             ON ChangeLog.chTableId = 124\n                AND ChangeLog.chEntityPk = CourseBlock.cbUid\n             JOIN Clazz\n                    ON  Clazz.clazzUid = CourseBlock.cbClazzUid\n         \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              2\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n          \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND CourseBlock.cbLct != COALESCE(\n         (SELECT cbVersionId\n            FROM CourseBlockReplicate\n           WHERE cbPk = CourseBlock.cbUid\n             AND cbDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(cbPk, cbDestination) DO UPDATE\n     SET cbPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseBlock.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.CourseBlock.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM CourseBlock WHERE cbUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.CourseBlock> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.CourseBlock entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Object replaceListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.CourseBlock> list, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM CourseBlock \n               LEFT JOIN ClazzAssignment as assignment\n               ON assignment.caUid = CourseBlock.cbEntityUid\n               AND CourseBlock.cbType = 103\n               LEFT JOIN CourseDiscussion as courseDiscussion\n               ON CourseDiscussion.courseDiscussionUid = CourseBlock.cbEntityUid\n               AND CourseBlock.cbType = 105\n               LEFT JOIN ContentEntry as entry\n               ON entry.contentEntryUid = CourseBlock.cbEntityUid\n               AND CourseBlock.cbType = 104\n               \n               LEFT JOIN Language\n               ON Language.langUid = entry.primaryLanguageUid\n                AND CourseBlock.cbType = 104\n               \n         WHERE cbClazzUid = :clazzUid\n           AND cbActive\n      ORDER BY cbIndex\n          ")
    public abstract java.lang.Object findAllCourseBlockByClazzUidAsync(long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.CourseBlockWithEntityDb>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @com.ustadmobile.door.annotation.QueryLiveTables(value = {"CourseBlock", "ClazzAssignment", "CourseDiscussion", "ContentEntry", "CourseAssignmentMark", "StatementEntity", "Container", "ContentEntryParentChildJoin", "PersonGroupMember", "Clazz", "ScopedGrant", "ClazzEnrolment", "CourseAssignmentSubmission", "CourseGroupMember"})
    @androidx.room.Query(value = "\n         WITH CtePermissionCheck (hasPermission) \n            AS (SELECT EXISTS( \n               SELECT PrsGrpMbr.groupMemberPersonUid\n                  FROM Clazz\n                       \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                          549755813888\n                          \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n        \n                 WHERE Clazz.clazzUid = :clazzUid\n                   AND PrsGrpMbr.groupMemberPersonUid = :personUid)), \n                   \n        \n            SubmitterList (submitterId, assignmentUid)\n            AS (SELECT DISTINCT ClazzEnrolment.clazzEnrolmentPersonUid AS submitterId,\n                       ClazzAssignment.caUid AS assignmentUid\n                  \n                  FROM ClazzEnrolment\n                  \n                       JOIN Person \n                       ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n                        \n                       JOIN ClazzAssignment\n                       ON ClazzAssignment.caClazzUid = :clazzUid\n\n                       JOIN CourseBlock\n                       ON CourseBlock.cbEntityUid = ClazzAssignment.caUid\n                       AND CourseBlock.cbType = 103\n                       \n                 WHERE ClazzAssignment.caGroupUid = 0\n                   AND clazzEnrolmentClazzUid = :clazzUid\n                   AND clazzEnrolmentActive\n                   AND clazzEnrolmentRole = 1000\n                   AND CourseBlock.cbGracePeriodDate <= ClazzEnrolment.clazzEnrolmentDateLeft\n                   AND ClazzEnrolment.clazzEnrolmentDateJoined <= CourseBlock.cbGracePeriodDate\n              GROUP BY submitterId, assignmentUid\n            UNION                 \n             SELECT DISTINCT CourseGroupMember.cgmGroupNumber AS submitterId,\n                    ClazzAssignment.caUid AS assignmentUid\n               FROM CourseGroupMember\n                    JOIN ClazzAssignment\n                    ON ClazzAssignment.caClazzUid = :clazzUid\n              WHERE CourseGroupMember.cgmSetUid = ClazzAssignment.caGroupUid\n                AND ClazzAssignment.caGroupUid != 0\n                AND CourseGroupMember.cgmGroupNumber != 0\n           GROUP BY submitterId, assignmentUid\n            )\n                   \n                   \n\n        SELECT CourseBlock.*, ClazzAssignment.*, ContentEntry.*, CourseDiscussion.*, ContentEntryParentChildJoin.*, \n               Container.*, CourseAssignmentMark.*, (CourseBlock.cbUid NOT IN (:collapseList)) AS expanded,\n               \n               COALESCE(StatementEntity.resultScoreMax,0) AS resultMax, \n                COALESCE(StatementEntity.resultScoreRaw,0) AS resultScore, \n                COALESCE(StatementEntity.resultScoreScaled,0) AS resultScaled, \n                COALESCE(StatementEntity.extensionProgress,0) AS progress, \n                COALESCE(StatementEntity.resultCompletion,\'FALSE\') AS contentComplete,\n                COALESCE(StatementEntity.resultSuccess, 0) AS success,\n                \n                COALESCE((CASE WHEN StatementEntity.resultCompletion \n                THEN 1 ELSE 0 END),0) AS totalCompletedContent,\n                \n                0 AS assignmentContentWeight,\n                1 as totalContent, \n                0 as penalty,\n                \n                (SELECT hasPermission FROM CtePermissionCheck) AS hasMetricsPermission,\n                \n             \n                 (SELECT COUNT(*) \n                    FROM SubmitterList \n                   WHERE SubmitterList.assignmentUid = ClazzAssignment.caUid) \n                        AS totalStudents, \n \n               0 AS notSubmittedStudents,\n               \n               (CASE WHEN (SELECT hasPermission \n                          FROM CtePermissionCheck)\n                     THEN (SELECT COUNT(DISTINCT CourseAssignmentSubmission.casSubmitterUid) \n                             FROM CourseAssignmentSubmission\n                                   LEFT JOIN CourseAssignmentMark\n                                   ON CourseAssignmentSubmission.casSubmitterUid = CourseAssignmentMark.camSubmitterUid\n                                   AND CourseAssignmentMark.camAssignmentUid = CourseAssignmentSubmission.casAssignmentUid\n                            WHERE CourseAssignmentMark.camUid IS NULL\n                              AND CourseAssignmentSubmission.casAssignmentUid = ClazzAssignment.caUid\n                              AND CourseAssignmentSubmission.casSubmitterUid IN \n                                                    (SELECT submitterId \n                                                      FROM SubmitterList\n                                                     WHERE SubmitterList.assignmentUid = ClazzAssignment.caUid))  \n                      ELSE 0 END) AS submittedStudents,         \n               \n                (CASE WHEN (SELECT hasPermission \n                           FROM CtePermissionCheck)       \n                   THEN (SELECT COUNT(DISTINCT CourseAssignmentMark.camSubmitterUid) \n                           FROM CourseAssignmentMark\n                            \n                             JOIN CourseAssignmentSubmission\n                             ON CourseAssignmentSubmission.casSubmitterUid = CourseAssignmentMark.camSubmitterUid\n                             AND CourseAssignmentSubmission.casAssignmentUid = CourseAssignmentMark.camAssignmentUid\n                             \n                          WHERE CourseAssignmentMark.camAssignmentUid = ClazzAssignment.caUid \n                            AND CourseAssignmentMark.camSubmitterUid IN (SELECT submitterId \n                                                                            FROM SubmitterList\n                                                                           WHERE SubmitterList.assignmentUid = ClazzAssignment.caUid))\n                   ELSE 0 END) AS markedStudents,\n                   \n                   COALESCE((CASE WHEN CourseAssignmentMark.camUid IS NOT NULL \n                          THEN 2 \n                          WHEN CourseAssignmentSubmission.casUid IS NOT NULL \n                          THEN 1 \n                          ELSE 0 END), \n                               0) AS fileSubmissionStatus\n                \n                \n          FROM CourseBlock \n          \n               LEFT JOIN CourseBlock AS parentBlock\n               ON CourseBlock.cbModuleParentBlockUid = parentBlock.cbUid\n               AND CourseBlock.cbTYpe != 100\n          \n               LEFT JOIN ClazzAssignment\n               ON ClazzAssignment.caUid = CourseBlock.cbEntityUid\n               AND CourseBlock.cbType = 103\n               \n               LEFT JOIN ContentEntry\n               ON ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n               AND NOT ceInactive\n               AND CourseBlock.cbType = 104\n               \n               LEFT JOIN CourseDiscussion \n                      ON CourseDiscussion.courseDiscussionUid = CourseBlock.cbEntityUid\n                     AND CourseBlock.cbType = 105\n               \n               LEFT JOIN ContentEntryParentChildJoin \n               ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid\n               \n               LEFT JOIN Container \n                    ON Container.containerUid = \n                        (SELECT containerUid \n                           FROM Container \n                          WHERE containerContentEntryUid = ContentEntry.contentEntryUid \n                       ORDER BY cntLastModified DESC LIMIT 1)\n                       \n              LEFT JOIN StatementEntity\n\t\t\t\t     ON StatementEntity.statementUid = \n                                (SELECT statementUid \n\t\t\t\t\t\t\t       FROM StatementEntity \n                                  WHERE statementContentEntryUid = ContentEntry.contentEntryUid \n\t\t\t\t\t\t\t        AND StatementEntity.statementPersonUid = :personUid\n\t\t\t\t\t\t\t        AND contentEntryRoot \n                               ORDER BY resultScoreScaled DESC, \n                                        extensionProgress DESC, \n                                        resultSuccess DESC \n                                  LIMIT 1) \n                                  \n               LEFT JOIN CourseAssignmentSubmission\n                ON casUid = (SELECT casUid \n                                     FROM CourseAssignmentSubmission\n                                    WHERE casAssignmentUid = ClazzAssignment.caUid\n                                      AND casSubmitterUid = (SELECT (CASE WHEN ref.caGroupUid = 0 \n                                                                          THEN :personUid \n                                                                          WHEN CourseGroupMember.cgmUid IS NULL \n                                                                          THEN 0 \n                                                                          ELSE CourseGroupMember.cgmGroupNumber \n                                                                          END) as submitterUid\n                                                               FROM ClazzAssignment AS ref\n                                                                    LEFT JOIN CourseGroupMember\n                                                                     ON cgmSetUid = ClazzAssignment.caGroupUid\n                                                                     AND cgmPersonUid = :personUid\n                                                              WHERE ref.caUid = ClazzAssignment.caUid)\n                                 ORDER BY casTimestamp DESC\n                                    LIMIT 1)\n                                          \n               LEFT JOIN CourseAssignmentMark\n                      ON camUid = (SELECT camUid \n                                     FROM CourseAssignmentMark\n                                    WHERE camAssignmentUid = ClazzAssignment.caUid\n                                      AND camSubmitterUid = (SELECT (CASE WHEN ref.caGroupUid = 0 \n                                                                          THEN :personUid \n                                                                          WHEN CourseGroupMember.cgmUid IS NULL \n                                                                          THEN 0 \n                                                                          ELSE CourseGroupMember.cgmGroupNumber \n                                                                          END) as submitterUid\n                                                               FROM ClazzAssignment AS ref\n                                                                    LEFT JOIN CourseGroupMember\n                                                                     ON cgmSetUid = ClazzAssignment.caGroupUid\n                                                                     AND cgmPersonUid = :personUid\n                                                              WHERE ref.caUid = ClazzAssignment.caUid)\n                                 ORDER BY camLct DESC\n                                    LIMIT 1)       \n         WHERE CourseBlock.cbClazzUid = :clazzUid\n           AND CourseBlock.cbActive\n           AND NOT CourseBlock.cbHidden\n           AND :currentTime > CourseBlock.cbHideUntilDate\n           AND :currentTime > COALESCE(parentBlock.cbHideUntilDate,0)\n           AND CourseBlock.cbModuleParentBlockUid NOT IN (:collapseList)\n      ORDER BY CourseBlock.cbIndex\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.CourseBlockWithCompleteEntity> findAllCourseBlockByClazzUidLive(long clazzUid, long personUid, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> collapseList, long currentTime);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE CourseBlock \n           SET cbActive = :active, \n               cbLct = :changeTime\n         WHERE cbUid = :cbUid")
    public abstract java.lang.Object updateActiveByUid(long cbUid, boolean active, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @java.lang.Override()
    public java.lang.Object deactivateByUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2 = {"Lcom/ustadmobile/core/db/dao/CourseBlockDao$Companion;", "", "()V", "SUBMITTER_LIST_IN_CLAZZ_CTE", "", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}