package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\'\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\'J\u001f\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010\u0012\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\u00020\u00062\b\b\u0001\u0010\u0015\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J)\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2 = {"Lcom/ustadmobile/core/db/dao/CourseDiscussionDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseDiscussion;", "Lcom/ustadmobile/core/db/dao/OneToManyJoinDao;", "()V", "deactivateByUids", "", "uidList", "", "", "changeTime", "(Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCourseDiscussionByUid", "Lcom/ustadmobile/door/DoorLiveData;", "courseDiscussionUid", "replaceListAsync", "list", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateActiveByUid", "cbUid", "active", "", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class CourseDiscussionDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.CourseDiscussion>, com.ustadmobile.core.db.dao.OneToManyJoinDao<com.ustadmobile.lib.db.entities.CourseDiscussion> {
    
    public CourseDiscussionDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO CourseDiscussionReplicate(courseDiscussionPk, courseDiscussionDestination)\n      SELECT DISTINCT CourseDiscussion.courseDiscussionUid AS courseDiscussionPk,\n             :newNodeId AS courseDiscussionDestination\n             \n       FROM UserSession\n             JOIN PersonGroupMember \n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                  2 \n                  \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n                  \n             JOIN CourseDiscussion \n                  ON CourseDiscussion.courseDiscussionClazzUid = Clazz.clazzUid\n                  \n       WHERE CourseDiscussion.courseDiscussionLct != COALESCE(\n             (SELECT courseDiscussionVersionId\n                FROM courseDiscussionReplicate\n               WHERE courseDiscussionPk = CourseDiscussion.courseDiscussionUid\n                 AND courseDiscussionDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(courseDiscussionPk, courseDiscussionDestination) DO UPDATE\n             SET courseDiscussionPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseDiscussion.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        REPLACE INTO CourseDiscussionReplicate(courseDiscussionPk, courseDiscussionDestination)\n          SELECT DISTINCT CourseDiscussion.courseDiscussionUid AS courseDiscussionUid,\n                 UserSession.usClientNodeId AS courseDiscussionDestination\n            FROM ChangeLog\n                 JOIN CourseDiscussion\n                     ON ChangeLog.chTableId = 130\n                        AND ChangeLog.chEntityPk = CourseDiscussion.courseDiscussionUid\n                 JOIN Clazz\n                      ON Clazz.clazzUid = CourseDiscussion.courseDiscussionClazzUid\n                 \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                  2\n                 \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n                 \n           WHERE UserSession.usClientNodeId != (\n                 SELECT nodeClientId \n                   FROM SyncNode\n                  LIMIT 1)\n             AND CourseDiscussion.courseDiscussionLct != COALESCE(\n                 (SELECT courseDiscussionVersionId\n                    FROM courseDiscussionReplicate\n                   WHERE courseDiscussionPk = CourseDiscussion.courseDiscussionUid\n                     AND courseDiscussionDestination = UserSession.usClientNodeId), 0)\n         /*psql ON CONFLICT(courseDiscussionPk, courseDiscussionDestination) DO UPDATE\n             SET courseDiscussionPending = true\n          */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseDiscussion.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.CourseDiscussion.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE CourseDiscussion \n           SET courseDiscussionActive = :active, \n               courseDiscussionLct = :changeTime\n         WHERE courseDiscussionUid = :cbUid")
    public abstract java.lang.Object updateActiveByUid(long cbUid, boolean active, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @java.lang.Override()
    public java.lang.Object deactivateByUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT CourseDiscussion.* \n          FROM CourseDiscussion\n         WHERE CourseDiscussion.courseDiscussionUid = :courseDiscussionUid \n           AND CAST(CourseDiscussion.courseDiscussionActive AS INTEGER) = 1 \n         \n         ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.CourseDiscussion> getCourseDiscussionByUid(long courseDiscussionUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Object replaceListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.CourseDiscussion> list, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}