package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\'\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\'\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ#\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\u001f\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0011\u0010\u0013\u001a\u00020\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\u00020\u00102\b\b\u0001\u0010\u0016\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2 = {"Lcom/ustadmobile/core/db/dao/CourseGroupMemberDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseGroupMember;", "()V", "findByGroupSetAsync", "", "Lcom/ustadmobile/lib/db/entities/CourseGroupMemberPerson;", "setUid", "", "clazzUid", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByGroupSetOrderedAsync", "findByPersonUid", "groupSetUid", "studentUid", "insertListAsync", "", "entityList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateListAsync", "lib-database"})
public abstract class CourseGroupMemberDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.CourseGroupMember> {
    
    public CourseGroupMemberDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO CourseGroupMemberReplicate(cgmPk, cgmDestination)\n      SELECT DISTINCT CourseGroupMember.cgmUid AS cgmUid,\n             :newNodeId AS cgmDestination\n        FROM UserSession\n             JOIN PersonGroupMember \n                    ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    2 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n             JOIN CourseGroupSet\n                    ON CourseGroupSet.cgsClazzUid = Clazz.clazzUid\n             JOIN CourseGroupMember\n                    ON CourseGroupMember.cgmSetUid = CourseGroupSet.cgsUid       \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND CourseGroupMember.cgmLct != COALESCE(\n             (SELECT cgmVersionId\n                FROM CourseGroupMemberReplicate\n               WHERE cgmPk = CourseGroupMember.cgmUid\n                 AND cgmDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(cgmPk, cgmDestination) DO UPDATE\n             SET cgmPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseGroupMember.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO CourseGroupMemberReplicate(cgmPk, cgmDestination)\n  SELECT DISTINCT CourseGroupMember.cgmUid AS cgmUid,\n         UserSession.usClientNodeId AS cgmDestination\n    FROM ChangeLog\n         JOIN CourseGroupMember\n               ON ChangeLog.chTableId = 243\n                  AND ChangeLog.chEntityPk = CourseGroupMember.cgmUid\n          JOIN CourseGroupSet\n               ON CourseGroupSet.cgsUid = CourseGroupMember.cgmSetUid       \n          JOIN Clazz \n               ON Clazz.clazzUid = CourseGroupSet.cgsClazzUid \n          \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n              2\n              \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n          \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND CourseGroupMember.cgmLct != COALESCE(\n         (SELECT cgmVersionId\n            FROM CourseGroupMemberReplicate\n           WHERE cgmPk = CourseGroupMember.cgmUid\n             AND cgmDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(cgmPk, cgmDestination) DO UPDATE\n     SET cgmPending = true\n  */               \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseGroupMember.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.CourseGroupMember.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT Person.*, CourseGroupMember.* \n          FROM Person\n               JOIN ClazzEnrolment \n               ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n               AND ClazzEnrolment.clazzEnrolmentRole = 1000\n               AND ClazzEnrolment.clazzEnrolmentOutcome = 200\n               \n               LEFT JOIN CourseGroupMember\n               ON CourseGroupMember.cgmPersonUid = ClazzEnrolment.clazzEnrolmentPersonUid\n               AND CourseGroupMember.cgmSetUid = :setUid\n               \n         WHERE clazzEnrolmentClazzUid = :clazzUid\n      ORDER BY Person.firstNames\n    ")
    public abstract java.lang.Object findByGroupSetAsync(long setUid, long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.CourseGroupMemberPerson>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT Person.*, CourseGroupMember.* \n          FROM Person\n               JOIN ClazzEnrolment \n               ON Person.personUid = ClazzEnrolment.clazzEnrolmentPersonUid\n               AND ClazzEnrolment.clazzEnrolmentRole = 1000 \n               AND ClazzEnrolment.clazzEnrolmentOutcome = 200\n               \n               LEFT JOIN CourseGroupMember\n               ON CourseGroupMember.cgmPersonUid = ClazzEnrolment.clazzEnrolmentPersonUid\n               AND CourseGroupMember.cgmSetUid = :setUid\n               \n         WHERE clazzEnrolmentClazzUid = :clazzUid\n      ORDER BY CourseGroupMember.cgmGroupNumber, Person.firstNames\n    ")
    public abstract java.lang.Object findByGroupSetOrderedAsync(long setUid, long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.CourseGroupMemberPerson>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n          FROM CourseGroupMember\n         WHERE cgmPersonUid = :studentUid \n          AND cgmSetUid = :groupSetUid\n         LIMIT 1\n    ")
    public abstract java.lang.Object findByPersonUid(long groupSetUid, long studentUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.CourseGroupMember> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.CourseGroupMember> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.CourseGroupMember> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}