package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\'\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u0011\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\r\u001a\u00020\u000b2\b\b\u0001\u0010\u000e\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2 = {"Lcom/ustadmobile/core/db/dao/CoursePictureDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CoursePicture;", "()V", "findByClazzUidAsync", "clazzUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByClazzUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "coursePicture", "(Lcom/ustadmobile/lib/db/entities/CoursePicture;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class CoursePictureDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.CoursePicture> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.CoursePictureDao.Companion Companion = null;
    
    public CoursePictureDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO CoursePictureReplicate(cpPk, cpDestination)\n      SELECT DISTINCT CoursePicture.coursePictureUid AS cpPk,\n             :newNodeId AS cpDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n                 \n              \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                    2 \n                    \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n                 \n             JOIN CoursePicture\n                  ON CoursePicture.coursePictureClazzUid = Clazz.clazzUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND CoursePicture.coursePictureLct != COALESCE(\n             (SELECT cpVersionId\n                FROM CoursePictureReplicate\n               WHERE cpPk = CoursePicture.coursePictureUid\n                 AND cpDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(cpPk, cpDestination) DO UPDATE\n             SET cpPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CoursePicture.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO CoursePictureReplicate(cpPk, cpDestination)\n  SELECT DISTINCT CoursePicture.coursePictureUid AS cpUid,\n         UserSession.usClientNodeId AS cpDestination\n    FROM ChangeLog\n         JOIN CoursePicture\n              ON ChangeLog.chTableId = 125\n                 AND ChangeLog.chEntityPk = CoursePicture.coursePictureUid\n        JOIN Clazz \n            ON CoursePicture.coursePictureClazzUid = Clazz.clazzUid\n  \n        \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                    2 \n                    \n           \n        \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n        \n \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND CoursePicture.coursePictureLct != COALESCE(\n         (SELECT cpVersionId\n            FROM CoursePictureReplicate\n           WHERE cpPk = CoursePicture.coursePictureUid\n             AND cpDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(cpPk, cpDestination) DO UPDATE\n     SET cpPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CoursePicture.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.CoursePicture.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM CoursePicture \n        WHERE coursePictureClazzUid = :clazzUid\n        AND CAST(coursePictureActive AS INTEGER) = 1\n        ORDER BY coursePictureTimestamp DESC LIMIT 1")
    public abstract java.lang.Object findByClazzUidAsync(long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.CoursePicture> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM CoursePicture where coursePictureClazzUid = :clazzUid ORDER BY  coursePictureTimestamp DESC LIMIT 1")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.CoursePicture> findByClazzUidLive(long clazzUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.CoursePicture coursePicture, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2 = {"Lcom/ustadmobile/core/db/dao/CoursePictureDao$Companion;", "", "()V", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}