package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005H\'J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\'J\u001b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u001b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u000f\u001a\u00020\u0010H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\u00102\b\b\u0001\u0010\u0013\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2 = {"Lcom/ustadmobile/core/db/dao/CourseTerminologyDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/CourseTerminology;", "()V", "findAllCourseTerminology", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "findAllCourseTerminologyList", "", "findByUidAsync", "uid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTerminologyForClazz", "clazzUid", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/CourseTerminology;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class CourseTerminologyDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.CourseTerminology> {
    
    public CourseTerminologyDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO CourseTerminologyReplicate(ctPk, ctDestination)\n      SELECT DISTINCT CourseTerminology.ctUid AS ctPk,\n             :newNodeId AS ctDestination\n        FROM CourseTerminology\n       WHERE CourseTerminology.ctLct != COALESCE(\n             (SELECT ctVersionId\n                FROM CourseTerminologyReplicate\n               WHERE ctPk = CourseTerminology.ctUid\n                 AND ctDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(ctPk, ctDestination) DO UPDATE\n             SET ctPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseTerminology.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO CourseTerminologyReplicate(ctPk, ctDestination)\n  SELECT DISTINCT CourseTerminology.ctUid AS ctUid,\n         UserSession.usClientNodeId AS ctDestination\n    FROM ChangeLog\n         JOIN CourseTerminology\n             ON ChangeLog.chTableId = 450\n                AND ChangeLog.chEntityPk = CourseTerminology.ctUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND CourseTerminology.ctLct != COALESCE(\n         (SELECT ctVersionId\n            FROM CourseTerminologyReplicate\n           WHERE ctPk = CourseTerminology.ctUid\n             AND ctDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(ctPk, ctDestination) DO UPDATE\n     SET ctPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.CourseTerminology.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.CourseTerminology.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT *\n         FROM CourseTerminology\n     ORDER BY ctTitle   \n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.CourseTerminology> findAllCourseTerminology();
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT *\n         FROM CourseTerminology\n     ORDER BY ctTitle   \n    ")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.CourseTerminology> findAllCourseTerminologyList();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT *\n          FROM CourseTerminology\n               JOIN Clazz \n               ON Clazz.clazzTerminologyUid = CourseTerminology.ctUid\n         WHERE Clazz.clazzUid = :clazzUid\n    ")
    public abstract java.lang.Object getTerminologyForClazz(long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.CourseTerminology> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n         FROM CourseTerminology \n        WHERE ctUid = :uid\n        ")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.CourseTerminology> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.CourseTerminology entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
}