package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u001b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u0012\u001a\u00020\u0006H\'J\u0011\u0010\u0013\u001a\u00020\u0014H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\u00020\u00142\b\b\u0001\u0010\u0017\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0019\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001a\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2 = {"Lcom/ustadmobile/core/db/dao/DiscussionPostDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/DiscussionPost;", "()V", "findByUid", "uid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findWithDetailsByUid", "Lcom/ustadmobile/lib/db/entities/DiscussionPostWithDetails;", "findWithDetailsByUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "getPostTitle", "", "postUid", "getPostsByDiscussionTopic", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "discussionTopicUid", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/DiscussionPost;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class DiscussionPostDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.DiscussionPost> {
    
    public DiscussionPostDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO DiscussionPostReplicate(discussionPostPk, discussionPostDestination)\n      SELECT DISTINCT DiscussionPost.discussionPostUid AS discussionPostPk,\n             :newNodeId AS discussionPostDestination\n             \n       FROM UserSession\n             JOIN PersonGroupMember \n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                  2 \n                  \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n                  \n            JOIN DiscussionPost \n                 ON DiscussionPost.discussionPostClazzUid = Clazz.clazzUid\n                 \n       WHERE DiscussionPost.discussionPostLct != COALESCE(\n             (SELECT discussionPostVersionId\n                FROM discussionPostReplicate\n               WHERE discussionPostPk = DiscussionPost.discussionPostUid\n                 AND discussionPostDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(discussionPostPk, discussionPostDestination) DO UPDATE\n             SET discussionPostPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.DiscussionPost.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        REPLACE INTO DiscussionPostReplicate(discussionPostPk, discussionPostDestination)\n          SELECT DISTINCT DiscussionPost.discussionPostUid AS discussionPostUid,\n                 UserSession.usClientNodeId AS discussionPostDestination\n            FROM ChangeLog\n                 JOIN DiscussionPost\n                     ON ChangeLog.chTableId = 132\n                        AND ChangeLog.chEntityPk = DiscussionPost.discussionPostUid\n                        \n                        \n                 JOIN Clazz \n                      ON Clazz.clazzUid = DiscussionPost.discussionPostClazzUid\n                      \n                 \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                  2\n                 \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n                 \n           WHERE UserSession.usClientNodeId != (\n                 SELECT nodeClientId \n                   FROM SyncNode\n                  LIMIT 1)\n             AND DiscussionPost.discussionPostLct != COALESCE(\n                 (SELECT discussionPostVersionId\n                    FROM discussionPostReplicate\n                   WHERE discussionPostPk = DiscussionPost.discussionPostUid\n                     AND DiscussionPostDestination = UserSession.usClientNodeId), 0)\n         /*psql ON CONFLICT(discussionPostPk, discussionPostDestination) DO UPDATE\n             SET discussionPostPending = true\n          */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.DiscussionPost.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.DiscussionPost.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT DiscussionPost.*,\n            Person.firstNames as authorPersonFirstNames,\n            Person.lastName as authorPersonLastName,\n            (\n                SELECT Message.messageText \n                  FROM Message \n                 WHERE Message.messageTableId = 132\n                   AND Message.messageEntityUid = DiscussionPost.discussionPostUid \n                 ORDER BY messageTimestamp \n                  DESC LIMIT 1\n            ) AS postLatestMessage,\n            (\n                SELECT COUNT(*) \n                  FROM Message\n                 WHERE Message.messageTableId = 132\n                   AND Message.messageEntityUid = DiscussionPost.discussionPostUid \n                   \n            ) AS postRepliesCount, \n            \n            (\n                SELECT Message.messageTimestamp \n                  FROM Message \n                 WHERE Message.messageTableId = 132\n                   AND Message.messageEntityUid = DiscussionPost.discussionPostUid \n                 ORDER BY messageTimestamp \n                  DESC LIMIT 1\n            ) AS postLatestMessageTimestamp\n             \n          FROM DiscussionPost     \n          LEFT JOIN Person ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n         WHERE DiscussionPost.discussionPostDiscussionTopicUid = :discussionTopicUid\n           AND CAST(DiscussionPost.discussionPostVisible AS INTEGER) = 1\n           AND CAST(DiscussionPost.discussionPostArchive AS INTEGER) = 0\n      ORDER BY DiscussionPost.discussionPostStartDate DESC\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.DiscussionPostWithDetails> getPostsByDiscussionTopic(long discussionTopicUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT DiscussionPost.discussionPostTitle \n          FROM DiscussionPost \n         WHERE DiscussionPost.discussionPostUid = :postUid\n    ")
    public abstract java.lang.Object getPostTitle(long postUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT * \n         FROM DiscussionPost\n        WHERE DiscussionPost.discussionPostUid = :uid\n    ")
    public abstract java.lang.Object findByUid(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.DiscussionPost> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT DiscussionPost.*,\n            Person.firstNames as authorPersonFirstNames,\n            Person.lastName as authorPersonLastName,\n            \'\' AS postLatestMessage,\n            0 AS postRepliesCount, \n            DiscussionPost.discussionPostLct AS postLatestMessageTimestamp\n             \n          FROM DiscussionPost     \n          LEFT JOIN Person ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n         WHERE DiscussionPost.discussionPostUid = :uid\n           \n    ")
    public abstract java.lang.Object findWithDetailsByUid(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.DiscussionPostWithDetails> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT DiscussionPost.*,\n            Person.firstNames as authorPersonFirstNames,\n            Person.lastName as authorPersonLastName,\n            \'\' AS postLatestMessage,\n            0 AS postRepliesCount, \n            DiscussionPost.discussionPostLct AS postLatestMessageTimestamp\n             \n          FROM DiscussionPost     \n          LEFT JOIN Person ON Person.personUid = DiscussionPost.discussionPostStartedPersonUid\n         WHERE DiscussionPost.discussionPostUid = :uid\n           \n    ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.DiscussionPostWithDetails> findWithDetailsByUidLive(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.DiscussionPost entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
}