package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\'\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\'J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\tH\'J\u001f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u0015\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\u0011\u0010\u001a\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u00020\u00062\b\b\u0001\u0010\u001d\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J)\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2 = {"Lcom/ustadmobile/core/db/dao/DiscussionTopicDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/DiscussionTopic;", "Lcom/ustadmobile/core/db/dao/OneToManyJoinDao;", "()V", "deactivateByUids", "", "uidList", "", "", "changeTime", "(Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDiscussionTopicByUid", "Lcom/ustadmobile/door/DoorLiveData;", "discussionTopicUid", "getListOfTopicsByDiscussion", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/DiscussionTopicListDetail;", "discussionUid", "getTopicsByClazz", "clazzUid", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replaceListAsync", "list", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateActiveByUid", "uid", "active", "", "(JZJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class DiscussionTopicDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.DiscussionTopic>, com.ustadmobile.core.db.dao.OneToManyJoinDao<com.ustadmobile.lib.db.entities.DiscussionTopic> {
    
    public DiscussionTopicDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO DiscussionTopicReplicate(discussionTopicPk, discussionTopicDestination)\n      SELECT DISTINCT DiscussionTopic.discussionTopicUid AS discussionTopicPk,\n             :newNodeId AS discussionTopicDestination\n             \n       FROM UserSession\n             JOIN PersonGroupMember \n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n               JOIN ScopedGrant\n                    ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                        AND (ScopedGrant.sgPermissions & \n        \n                  2 \n                  \n                       ) > 0\n               JOIN Clazz \n                    ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n        \n                  \n             JOIN DiscussionTopic \n                  ON DiscussionTopic.discussionTopicClazzUid = Clazz.clazzUid\n                  \n       WHERE DiscussionTopic.discussionTopicLct != COALESCE(\n             (SELECT discussionTopicVersionId\n                FROM discussionTopicReplicate\n               WHERE discussionTopicPk = DiscussionTopic.discussionTopicUid\n                 AND discussionTopicDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(discussionTopicPk, discussionTopicDestination) DO UPDATE\n             SET discussionTopicPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.DiscussionTopic.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        REPLACE INTO DiscussionTopicReplicate(discussionTopicPk, discussionTopicDestination)\n          SELECT DISTINCT DiscussionTopic.discussionTopicUid AS discussionTopicUid,\n                 UserSession.usClientNodeId AS discussionTopicDestination\n            FROM ChangeLog\n                 JOIN DiscussionTopic\n                     ON ChangeLog.chTableId = 131\n                        AND ChangeLog.chEntityPk = DiscussionTopic.discussionTopicUid\n                        \n                        \n                 JOIN Clazz\n                      ON Clazz.clazzUid = DiscussionTopic.discussionTopicClazzUid\n                 \n            JOIN ScopedGrant\n                 ON \n            ((ScopedGrant.sgTableId = -2\n                                AND ScopedGrant.sgEntityUid = -2)\n                            OR (ScopedGrant.sgTableId = 6\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzUid)\n                            OR (ScopedGrant.sgTableId = 164\n                                AND ScopedGrant.sgEntityUid = Clazz.clazzSchoolUid))\n        \n                    AND (ScopedGrant.sgPermissions & \n        \n                  2\n                 \n              \n                                                       ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n                                               \n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n             \n                 \n           WHERE UserSession.usClientNodeId != (\n                 SELECT nodeClientId \n                   FROM SyncNode\n                  LIMIT 1)\n             AND DiscussionTopic.discussionTopicLct != COALESCE(\n                 (SELECT discussionTopicVersionId\n                    FROM discussionTopicReplicate\n                   WHERE discussionTopicPk = DiscussionTopic.discussionTopicUid\n                     AND DiscussionTopicDestination = UserSession.usClientNodeId), 0)\n         /*psql ON CONFLICT(discussionTopicPk, discussionTopicDestination) DO UPDATE\n             SET discussionTopicPending = true\n          */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.DiscussionTopic.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.DiscussionTopic.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT DiscussionTopic.*,\n                ( \n                    SELECT COUNT(*) \n                      FROM DiscussionPost \n                     WHERE DiscussionPost.discussionPostDiscussionTopicUid = DiscussionTopic.discussionTopicUid\n                ) as numPosts,\n                (\n                    0\n                )as lastActiveTimestamp\n          FROM DiscussionTopic     \n         WHERE DiscussionTopic.discussionTopicCourseDiscussionUid = :discussionUid \n           AND CAST(DiscussionTopic.discussionTopicVisible AS INTEGER) = 1\n           AND CAST(DiscussionTopic.discussionTopicArchive AS INTEGER) = 0\n      ORDER BY DiscussionTopic.discussionTopicIndex\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.DiscussionTopicListDetail> getListOfTopicsByDiscussion(long discussionUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT DiscussionTopic.*\n          FROM DiscussionTopic\n         WHERE DiscussionTopic.discussionTopicCourseDiscussionUid IN \n                (SELECT CourseDiscussion.courseDiscussionUid \n                   FROM CourseDiscussion\n                  WHERE CourseDiscussion.courseDiscussionClazzUid = :clazzUid ) \n          AND CAST(DiscussionTopic.discussionTopicVisible AS INTEGER) = 1\n          AND CAST(DiscussionTopic.discussionTopicArchive AS INTEGER)  = 0\n                        \n    ")
    public abstract java.lang.Object getTopicsByClazz(long clazzUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.DiscussionTopic>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT DiscussionTopic.*\n          FROM DiscussionTopic\n         WHERE DiscussionTopic.discussionTopicUid = :discussionTopicUid\n         \n         ")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.DiscussionTopic> getDiscussionTopicByUid(long discussionTopicUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE DiscussionTopic \n           SET discussionTopicVisible = :active, \n               discussionTopicLct = :changeTime\n         WHERE discussionTopicUid = :uid")
    public abstract java.lang.Object updateActiveByUid(long uid, boolean active, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @java.lang.Override()
    public java.lang.Object deactivateByUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Object replaceListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.DiscussionTopic> list, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}