package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\'\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\bH\'J\u001f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ7\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00162\u0006\u0010\u0014\u001a\u00020\bH\'J\u0019\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2 = {"Lcom/ustadmobile/core/db/dao/EntityRoleDao;", "", "()V", "filterByPersonWithExtra", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/EntityRoleWithNameAndRole;", "personGroupUid", "", "filterByPersonWithExtraAsList", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByEntitiyAndPersonGroupAndRole", "Lcom/ustadmobile/lib/db/entities/EntityRole;", "tableId", "entityUid", "groupUid", "roleUid", "(IJJJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidAsync", "uid", "findByUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "insertOrReplace", "", "entity", "(Lcom/ustadmobile/lib/db/entities/EntityRole;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "userHasTableLevelPermission", "", "accountPersonUid", "permission", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class EntityRoleDao {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.EntityRoleDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String FILTER_BY_PERSON_UID2 = "\n                    SELECT  \n                    (CASE \n                        WHEN EntityRole.erTableId = 6\tTHEN (SELECT Clazz.clazzName FROM Clazz WHERE Clazz.clazzUid = EntityRole.erEntityUid)\n                        WHEN EntityRole.erTableId = 9\tTHEN (SELECT Person.firstNames||\' \'||Person.lastName FROM Person WHERE Person.personUid = EntityRole.erEntityUid)\n                        WHEN EntityRole.erTableId = 164\tTHEN (SELECT School.schoolName FROM School WHERE School.schoolUid = EntityRole.erEntityUid)\n                        ELSE \'\' \n                    END) as entityRoleScopeName,\n                    Role.*, EntityRole.* FROM EntityRole\n                    LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid \n                    WHERE EntityRole.erGroupUid = :personGroupUid\n                    AND CAST(EntityRole.erActive AS INTEGER) = 1 \n                ";
    
    public EntityRoleDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.PostgresQuery(value = "\n        SELECT COALESCE((\n               SELECT admin \n                 FROM Person \n                WHERE personUid = :accountPersonUid), false)\n            OR EXISTS(SELECT EntityRole.erUid FROM EntityRole \n               JOIN Role \n                    ON EntityRole.erRoleUid = Role.roleUid \n               JOIN PersonGroupMember \n                    ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n         WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid \n               AND (Role.rolePermissions & :permission) > 0) AS hasPermission\n    ")
    @androidx.room.Query(value = "\n        SELECT COALESCE((\n               SELECT admin \n                 FROM Person \n                WHERE personUid = :accountPersonUid), 0)\n            OR EXISTS(SELECT EntityRole.erUid FROM EntityRole \n               JOIN Role \n                    ON EntityRole.erRoleUid = Role.roleUid \n               JOIN PersonGroupMember \n                    ON EntityRole.erGroupUid = PersonGroupMember.groupMemberGroupUid\n         WHERE PersonGroupMember.groupMemberPersonUid = :accountPersonUid \n               AND (Role.rolePermissions & :permission) > 0) AS hasPermission")
    public abstract java.lang.Object userHasTableLevelPermission(long accountPersonUid, long permission, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Boolean> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM EntityRole WHERE erTableId = :tableId  AND erEntityUid = :entityUid AND erGroupUid = :groupUid  AND erRoleUid = :roleUid ")
    public abstract java.lang.Object findByEntitiyAndPersonGroupAndRole(int tableId, long entityUid, long groupUid, long roleUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<? extends com.ustadmobile.lib.db.entities.EntityRole>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n                    SELECT  \n                    (CASE \n                        WHEN EntityRole.erTableId = 6\tTHEN (SELECT Clazz.clazzName FROM Clazz WHERE Clazz.clazzUid = EntityRole.erEntityUid)\n                        WHEN EntityRole.erTableId = 9\tTHEN (SELECT Person.firstNames||\' \'||Person.lastName FROM Person WHERE Person.personUid = EntityRole.erEntityUid)\n                        WHEN EntityRole.erTableId = 164\tTHEN (SELECT School.schoolName FROM School WHERE School.schoolUid = EntityRole.erEntityUid)\n                        ELSE \'\' \n                    END) as entityRoleScopeName,\n                    Role.*, EntityRole.* FROM EntityRole\n                    LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid \n                    WHERE EntityRole.erGroupUid = :personGroupUid\n                    AND CAST(EntityRole.erActive AS INTEGER) = 1 \n                ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.EntityRoleWithNameAndRole> filterByPersonWithExtra(long personGroupUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n                    SELECT  \n                    (CASE \n                        WHEN EntityRole.erTableId = 6\tTHEN (SELECT Clazz.clazzName FROM Clazz WHERE Clazz.clazzUid = EntityRole.erEntityUid)\n                        WHEN EntityRole.erTableId = 9\tTHEN (SELECT Person.firstNames||\' \'||Person.lastName FROM Person WHERE Person.personUid = EntityRole.erEntityUid)\n                        WHEN EntityRole.erTableId = 164\tTHEN (SELECT School.schoolName FROM School WHERE School.schoolUid = EntityRole.erEntityUid)\n                        ELSE \'\' \n                    END) as entityRoleScopeName,\n                    Role.*, EntityRole.* FROM EntityRole\n                    LEFT JOIN Role ON EntityRole.erRoleUid = Role.roleUid \n                    WHERE EntityRole.erGroupUid = :personGroupUid\n                    AND CAST(EntityRole.erActive AS INTEGER) = 1 \n                ")
    public abstract java.lang.Object filterByPersonWithExtraAsList(long personGroupUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.EntityRoleWithNameAndRole>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM EntityRole WHERE erUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.EntityRole> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM EntityRole WHERE erUid = :uid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.EntityRole> findByUidLive(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.EntityRole entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Object insertOrReplace(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.EntityRole entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2 = {"Lcom/ustadmobile/core/db/dao/EntityRoleDao$Companion;", "", "()V", "FILTER_BY_PERSON_UID2", "", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}