package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2 = {"Lcom/ustadmobile/core/db/dao/ErrorReportDao;", "", "()V", "findByErrorCode", "", "Lcom/ustadmobile/lib/db/entities/ErrorReport;", "errCode", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidAsync", "errUid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertAsync", "errorReport", "(Lcom/ustadmobile/lib/db/entities/ErrorReport;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class ErrorReportDao {
    
    public ErrorReportDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO ErrorReportReplicate(erPk, erDestination)\n  SELECT DISTINCT ErrorReport.errUid AS erUid,\n           UserSession.usClientNodeId AS erDestination\n    FROM ChangeLog\n         JOIN ErrorReport\n             ON ChangeLog.chTableId = 419\n                AND ChangeLog.chEntityPk = ErrorReport.errUid\n         JOIN UserSession ON UserSession.usSessionType = 2\n    WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND ErrorReport.errLct != COALESCE(\n         (SELECT erVersionId\n            FROM ErrorReportReplicate\n           WHERE erPk = ErrorReport.errUid\n             AND erDestination = UserSession.usClientNodeId), 0)\n    /*psql ON CONFLICT(erPk, erDestination) DO UPDATE\n     SET erPending = true\n    */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.ErrorReport.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.ErrorReport.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.ErrorReport errorReport, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ErrorReport.* \n          FROM ErrorReport\n         WHERE errUid = :errUid\n    ")
    public abstract java.lang.Object findByUidAsync(long errUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.ErrorReport> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        SELECT ErrorReport.*\n          FROM ErrorReport\n         WHERE errorCode = :errCode  \n    ")
    public abstract java.lang.Object findByErrorCode(int errCode, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.ErrorReport>> continuation);
}