package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0005H\'J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\'J\u001b\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\'J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\'J\u0011\u0010\u0014\u001a\u00020\u0012H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\u00020\u00122\b\b\u0001\u0010\u0017\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001a\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2 = {"Lcom/ustadmobile/core/db/dao/HolidayCalendarDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/HolidayCalendar;", "()V", "findAllHolidaysLiveData", "Lcom/ustadmobile/door/DoorLiveData;", "", "findAllHolidaysWithEntriesCount", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/HolidayCalendarWithNumEntries;", "findByUid", "uid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidAsync", "findByUidLive", "replaceList", "", "list", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/HolidayCalendar;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class HolidayCalendarDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.HolidayCalendar> {
    
    public HolidayCalendarDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO HolidayCalendarReplicate(hcPk, hcDestination)\n      SELECT DISTINCT HolidayCalendar.umCalendarUid AS hcPk,\n             :newNodeId AS hcDestination\n        FROM HolidayCalendar\n             JOIN UserSession\n                  ON UserSession.usClientNodeId = :newNodeId\n        --notpsql \n       WHERE HolidayCalendar.umCalendarLct != COALESCE(\n             (SELECT hcVersionId\n                FROM HolidayCalendarReplicate\n               WHERE hcPk = HolidayCalendar.umCalendarUid\n                 AND hcDestination = UserSession.usClientNodeId), 0) \n         --endnotpsql        \n      /*psql ON CONFLICT(hcPk, hcDestination) DO UPDATE\n             SET hcPending = (SELECT HolidayCalendar.umCalendarLct\n                                FROM HolidayCalendar\n                               WHERE HolidayCalendar.umCalendarUid = EXCLUDED.hcPk ) \n                                     != HolidayCalendarReplicate.hcPk\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.HolidayCalendar.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO HolidayCalendarReplicate(hcPk, hcDestination)\n  SELECT DISTINCT HolidayCalendar.umCalendarUid AS hcUid,\n         UserSession.usClientNodeId AS hcDestination\n    FROM ChangeLog\n         JOIN HolidayCalendar\n             ON ChangeLog.chTableId = 28\n                AND ChangeLog.chEntityPk = HolidayCalendar.umCalendarUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     --notpsql \n      AND HolidayCalendar.umCalendarLct != COALESCE(\n             (SELECT hcVersionId\n                FROM HolidayCalendarReplicate\n               WHERE hcPk = HolidayCalendar.umCalendarUid\n                 AND hcDestination = UserSession.usClientNodeId), 0) \n         --endnotpsql    \n   /*psql ON CONFLICT(hcPk, hcDestination) DO UPDATE\n             SET hcPending = (SELECT HolidayCalendar.umCalendarLct\n                                FROM HolidayCalendar\n                               WHERE HolidayCalendar.umCalendarUid = EXCLUDED.hcPk ) \n                                     != HolidayCalendarReplicate.hcPk     \n        */                                           \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.HolidayCalendar.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.HolidayCalendar.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT HolidayCalendar.* ,\n            (SELECT COUNT(*) FROM Holiday \n               WHERE holHolidayCalendarUid = HolidayCalendar.umCalendarUid \n               AND CAST(holActive AS INTEGER) = 1) AS numEntries \n             FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND \n             umCalendarCategory = 1")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.HolidayCalendarWithNumEntries> findAllHolidaysWithEntriesCount();
    
    @androidx.room.Insert(onConflict = 1)
    public abstract void replaceList(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.HolidayCalendar> list);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM HolidayCalendar WHERE CAST(umCalendarActive AS INTEGER) = 1 AND umCalendarCategory = 1")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.HolidayCalendar>> findAllHolidaysLiveData();
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = :uid AND CAST(umCalendarActive AS INTEGER) = 1")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.HolidayCalendar> findByUidLive(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.HolidayCalendar entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = :uid")
    public abstract java.lang.Object findByUid(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.HolidayCalendar> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM HolidayCalendar WHERE umCalendarUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.HolidayCalendar> continuation);
}