package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\'\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\r\u001a\u00020\tH\'J\u001f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\r\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0010\u001a\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\u00062\b\b\u0001\u0010\u0013\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\tH\'J\u0019\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001a\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2 = {"Lcom/ustadmobile/core/db/dao/HolidayDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Holiday;", "Lcom/ustadmobile/core/db/dao/OneToManyJoinDao;", "()V", "deactivateByUids", "", "uidList", "", "", "changeTime", "(Ljava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByHolidayCalendaUid", "holidayCalendarUid", "findByHolidayCalendaUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "updateActiveByUid", "holidayUid", "active", "", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/Holiday;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class HolidayDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.Holiday>, com.ustadmobile.core.db.dao.OneToManyJoinDao<com.ustadmobile.lib.db.entities.Holiday> {
    
    public HolidayDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO HolidayReplicate(holidayPk, holidayDestination)\n      SELECT DISTINCT Holiday.holUid AS holidayPk,\n             :newNodeId AS holidayDestination\n        FROM Holiday\n       WHERE Holiday.holLct != COALESCE(\n             (SELECT holidayVersionId\n                FROM HolidayReplicate\n               WHERE holidayPk = Holiday.holUid\n                 AND holidayDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(holidayPk, holidayDestination) DO UPDATE\n             SET holidayPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Holiday.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO HolidayReplicate(holidayPk, holidayDestination)\n  SELECT DISTINCT Holiday.holUid AS holidayUid,\n         UserSession.usClientNodeId AS holidayDestination\n    FROM ChangeLog\n         JOIN Holiday\n             ON ChangeLog.chTableId = 99\n                AND ChangeLog.chEntityPk = Holiday.holUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND Holiday.holLct != COALESCE(\n         (SELECT holidayVersionId\n            FROM HolidayReplicate\n           WHERE holidayPk = Holiday.holUid\n             AND holidayDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(holidayPk, holidayDestination) DO UPDATE\n     SET holidayPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Holiday.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.Holiday.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = :holidayCalendarUid")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Holiday> findByHolidayCalendaUid(long holidayCalendarUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Holiday WHERE holHolidayCalendarUid = :holidayCalendarUid")
    public abstract java.lang.Object findByHolidayCalendaUidAsync(long holidayCalendarUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.Holiday>> continuation);
    
    @androidx.room.Query(value = "\n        UPDATE Holiday \n           SET holActive = :active, \n               holLct = :changeTime\n         WHERE holUid = :holidayUid")
    public abstract void updateActiveByUid(long holidayUid, boolean active, long changeTime);
    
    @org.jetbrains.annotations.Nullable()
    @java.lang.Override()
    public java.lang.Object deactivateByUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, long changeTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Holiday entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}