package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\b\'\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0005H\'J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\'J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\tH\'J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\tH\'J\u001b\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\'J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006H\'J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\tH\'J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\'J\u0006\u0010\u001c\u001a\u00020\u001dJ\u001f\u0010\u001e\u001a\u00020\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u0016\u0010!\u001a\u00020\u001d2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\'J\u0011\u0010#\u001a\u00020\u001dH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u001b\u0010%\u001a\u00020\u001d2\b\b\u0001\u0010&\u001a\u00020\u0011H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J/\u0010\'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\u0006\u0010+\u001a\u00020\u0011H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020\u0018H\'J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u0002H\'J\u0019\u00100\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00063"}, d2 = {"Lcom/ustadmobile/core/db/dao/LanguageDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/Language;", "()V", "findAllLanguageLive", "Lcom/ustadmobile/door/DoorLiveData;", "", "findByName", "name", "", "findByThreeCode", "langCode", "findByTwoCode", "findByTwoCodeAsync", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUid", "primaryLanguageUid", "", "findByUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidList", "uidList", "findLanguagesAsSource", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "sortOrder", "searchText", "findLanguagesList", "initPreloadedLanguages", "", "insertListAsync", "languageList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replaceList", "entityList", "replicateOnChange", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "toggleVisibilityLanguage", "toggleVisibility", "", "selectedItem", "updateTime", "(ZLjava/util/List;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "totalLanguageCount", "update", "entity", "updateAsync", "(Lcom/ustadmobile/lib/db/entities/Language;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class LanguageDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.Language> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.LanguageDao.Companion Companion = null;
    public static final int SORT_LANGNAME_ASC = 1;
    public static final int SORT_LANGNAME_DESC = 2;
    public static final int SORT_TWO_LETTER_ASC = 3;
    public static final int SORT_TWO_LETTER_DESC = 4;
    public static final int SORT_THREE_LETTER_ASC = 5;
    public static final int SORT_THREE_LETTER_DESC = 6;
    
    public LanguageDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO LanguageReplicate(languagePk, languageDestination)\n      SELECT DISTINCT Language.langUid AS languagePk,\n             :newNodeId AS languageDestination\n        FROM Language\n       WHERE Language.langLct != COALESCE(\n             (SELECT languageVersionId\n                FROM LanguageReplicate\n               WHERE languagePk = Language.langUid\n                 AND languageDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(languagePk, languageDestination) DO UPDATE\n             SET languagePending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Language.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO LanguageReplicate(languagePk, languageDestination)\n  SELECT DISTINCT Language.langUid AS languageUid,\n         UserSession.usClientNodeId AS languageDestination\n    FROM ChangeLog\n         JOIN Language\n             ON ChangeLog.chTableId = 13\n                AND ChangeLog.chEntityPk = Language.langUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND Language.langLct != COALESCE(\n         (SELECT languageVersionId\n            FROM LanguageReplicate\n           WHERE languagePk = Language.langUid\n             AND languageDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(languagePk, languageDestination) DO UPDATE\n     SET languagePending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.Language.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.Language.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert()
    public abstract java.lang.Object insertListAsync(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.Language> languageList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "\n        SELECT Language.* \n        FROM Language\n        WHERE name LIKE :searchText\n        ORDER BY CASE(:sortOrder)\n            WHEN 1 THEN Language.name \n            WHEN 3 THEN Language.iso_639_1_standard \n            WHEN 5 THEN Language.iso_639_2_standard \n            ELSE \'\'\n        END ASC,\n        CASE(:sortOrder)\n            WHEN 2 THEN Language.name \n            WHEN 4 THEN Language.iso_639_1_standard \n            WHEN 6 THEN Language.iso_639_2_standard \n            ELSE \'\'\n        END DESC\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.Language> findLanguagesAsSource(int sortOrder, @org.jetbrains.annotations.NotNull()
    java.lang.String searchText);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM Language")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.Language> findLanguagesList();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Language WHERE name = :name LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.Language findByName(@org.jetbrains.annotations.NotNull()
    java.lang.String name);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Language WHERE iso_639_1_standard = :langCode LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.Language findByTwoCode(@org.jetbrains.annotations.NotNull()
    java.lang.String langCode);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Language WHERE iso_639_1_standard = :langCode LIMIT 1")
    public abstract java.lang.Object findByTwoCodeAsync(@org.jetbrains.annotations.NotNull()
    java.lang.String langCode, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Language> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM LANGUAGE WHERE iso_639_3_standard = :langCode OR iso_639_2_standard = :langCode LIMIT 1 ")
    public abstract com.ustadmobile.lib.db.entities.Language findByThreeCode(@org.jetbrains.annotations.NotNull()
    java.lang.String langCode);
    
    @androidx.room.Query(value = "SELECT COUNT(*) FROM LANGUAGE")
    public abstract int totalLanguageCount();
    
    @java.lang.Override()
    @androidx.room.Update()
    public abstract void update(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Language entity);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT *  FROM LANGUAGE where langUid = :primaryLanguageUid LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.Language findByUid(long primaryLanguageUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT *  FROM LANGUAGE where langUid = :primaryLanguageUid LIMIT 1")
    public abstract java.lang.Object findByUidAsync(long primaryLanguageUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.Language> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.Language entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM LANGUAGE")
    public abstract com.ustadmobile.door.DoorLiveData<java.util.List<com.ustadmobile.lib.db.entities.Language>> findAllLanguageLive();
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT langUid FROM LANGUAGE WHERE langUid IN (:uidList)")
    public abstract java.util.List<java.lang.Long> findByUidList(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n        UPDATE Language \n           SET languageActive = :toggleVisibility, \n               langLct = :updateTime\n         WHERE langUid IN (:selectedItem)")
    public abstract java.lang.Object toggleVisibilityLanguage(boolean toggleVisibility, @org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> selectedItem, long updateTime, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract void replaceList(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.Language> entityList);
    
    public final void initPreloadedLanguages() {
    }
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2 = {"Lcom/ustadmobile/core/db/dao/LanguageDao$Companion;", "", "()V", "SORT_LANGNAME_ASC", "", "SORT_LANGNAME_DESC", "SORT_THREE_LETTER_ASC", "SORT_THREE_LETTER_DESC", "SORT_TWO_LETTER_ASC", "SORT_TWO_LETTER_DESC", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}