package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\'J\u0011\u0010\u0007\u001a\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\n\u001a\u00020\b2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2 = {"Lcom/ustadmobile/core/db/dao/LanguageVariantDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/LanguageVariant;", "()V", "findByCode", "countryCode", "", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class LanguageVariantDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.LanguageVariant> {
    
    public LanguageVariantDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO LanguageVariantReplicate(lvPk, lvDestination)\n      SELECT DISTINCT LanguageVariant.langVariantUid AS lvPk,\n             :newNodeId AS lvDestination\n        FROM LanguageVariant\n       WHERE LanguageVariant.langVariantLct != COALESCE(\n             (SELECT lvVersionId\n                FROM LanguageVariantReplicate\n               WHERE lvPk = LanguageVariant.langVariantUid\n                 AND lvDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(lvPk, lvDestination) DO UPDATE\n             SET lvPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.LanguageVariant.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO LanguageVariantReplicate(lvPk, lvDestination)\n  SELECT DISTINCT LanguageVariant.langVariantUid AS lvUid,\n         UserSession.usClientNodeId AS lvDestination\n    FROM ChangeLog\n         JOIN LanguageVariant\n             ON ChangeLog.chTableId = 10\n                AND ChangeLog.chEntityPk = LanguageVariant.langVariantUid\n         JOIN UserSession ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND LanguageVariant.langVariantLct != COALESCE(\n         (SELECT lvVersionId\n            FROM LanguageVariantReplicate\n           WHERE lvPk = LanguageVariant.langVariantUid\n             AND lvDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(lvPk, lvDestination) DO UPDATE\n     SET lvPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.LanguageVariant.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.LanguageVariant.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM LanguageVariant WHERE countryCode = :countryCode LIMIT 1")
    public abstract com.ustadmobile.lib.db.entities.LanguageVariant findByCode(@org.jetbrains.annotations.NotNull()
    java.lang.String countryCode);
}