package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u0011\u0010\u000b\u001a\u00020\fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u001b\u0010\u000e\u001a\u00020\f2\b\b\u0001\u0010\u000f\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2 = {"Lcom/ustadmobile/core/db/dao/LearnerGroupDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/LearnerGroup;", "()V", "findGroupListForEntry", "", "contentEntryUid", "", "findGroupsForEntryAsync", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class LearnerGroupDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.LearnerGroup> {
    
    public LearnerGroupDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO LearnerGroupReplicate(lgPk, lgDestination)\n      SELECT DISTINCT LearnerGroup.learnerGroupUid AS lgPk,\n             :newNodeId AS lgDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                  64\n                  \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN LearnerGroupMember\n                  ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid\n             JOIN LearnerGroup\n                  ON LearnerGroup.learnerGroupUid = LearnerGroupMember.learnerGroupMemberLgUid\n            WHERE UserSession.usClientNodeId = :newNodeId\n              AND UserSession.usStatus = 1\n              AND LearnerGroup.learnerGroupLct != COALESCE(\n                  (SELECT lgVersionId\n                     FROM LearnerGroupReplicate\n                    WHERE lgPk = LearnerGroup.learnerGroupUid\n                      AND lgDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(lgPk, lgDestination) DO UPDATE\n             SET lgPending = true\n      */       \n ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.LearnerGroup.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO LearnerGroupReplicate(lgPk, lgDestination)\n  SELECT DISTINCT LearnerGroup.learnerGroupUid AS lgUid,\n         UserSession.usClientNodeId AS lgDestination\n    FROM ChangeLog\n         JOIN LearnerGroup\n              ON ChangeLog.chTableId = 301\n                 AND ChangeLog.chEntityPk = LearnerGroup.learnerGroupUid\n         JOIN LearnerGroupMember\n              ON LearnerGroupMember.learnerGroupMemberLgUid = LearnerGroup.learnerGroupUid\n         JOIN Person\n              ON Person.personUid = LearnerGroupMember.learnerGroupMemberPersonUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              64\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n /*psql ON CONFLICT(lgPk, lgDestination) DO UPDATE\n     SET lgPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.LearnerGroup.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.LearnerGroup.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT LearnerGroup.* FROM LearnerGroup \n            LEFT JOIN GroupLearningSession ON \n            GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroup.learnerGroupUid \n            WHERE GroupLearningSession.groupLearningSessionContentUid = :contentEntryUid")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.LearnerGroup> findGroupsForEntryAsync(long contentEntryUid);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT LearnerGroup.* FROM LearnerGroup \n            LEFT JOIN GroupLearningSession ON \n            GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroup.learnerGroupUid \n            WHERE GroupLearningSession.groupLearningSessionContentUid = :contentEntryUid")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.LearnerGroup> findGroupListForEntry(long contentEntryUid);
}