package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\'J\'\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u000e\u001a\u00020\u000fH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u001b\u0010\u0011\u001a\u00020\u000f2\b\b\u0001\u0010\u0012\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2 = {"Lcom/ustadmobile/core/db/dao/LearnerGroupMemberDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/LearnerGroupMember;", "()V", "findLearnerGroupMembersByGroupIdAndEntry", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "Lcom/ustadmobile/lib/db/entities/LearnerGroupMemberWithPerson;", "learnerGroupUid", "", "contentEntryUid", "findLearnerGroupMembersByGroupIdAndEntryList", "", "(JJLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNode", "newNodeId", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class LearnerGroupMemberDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.LearnerGroupMember> {
    
    public LearnerGroupMemberDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO LearnerGroupMemberReplicate(lgmPk, lgmDestination)\n      SELECT DISTINCT LearnerGroupMember.learnerGroupMemberUid AS lgmPk,\n             :newNodeId AS lgmDestination\n        FROM UserSession\n             JOIN PersonGroupMember\n                  ON UserSession.usPersonUid = PersonGroupMember.groupMemberPersonUid\n             \n            JOIN ScopedGrant\n                 ON ScopedGrant.sgGroupUid = PersonGroupMember.groupMemberGroupUid\n                    AND (ScopedGrant.sgPermissions &\n                  64\n                  \n                                                    ) > 0\n            JOIN Person \n                 ON \n                ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND Person.personUid IN (\n                        SELECT DISTINCT clazzEnrolmentPersonUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentClazzUid =ScopedGrant.sgEntityUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND Person.personUid IN (\n                        SELECT DISTINCT schoolMemberPersonUid\n                          FROM SchoolMember\n                         WHERE schoolMemberSchoolUid = ScopedGrant.sgEntityUid\n                           AND schoolMemberActive))\n                           )    \n        \n        \n             JOIN LearnerGroupMember\n                  ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid\n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND LearnerGroupMember.learnerGroupMemberLct != COALESCE(\n             (SELECT lgmVersionId\n                FROM LearnerGroupMemberReplicate\n               WHERE lgmPk = LearnerGroupMember.learnerGroupMemberUid\n                 AND lgmDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(lgmPk, lgmDestination) DO UPDATE\n             SET lgmPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.LearnerGroupMember.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO LearnerGroupMemberReplicate(lgmPk, lgmDestination)\n  SELECT DISTINCT LearnerGroupMember.learnerGroupMemberUid AS lgmUid,\n         UserSession.usClientNodeId AS lgmDestination\n    FROM ChangeLog\n         JOIN LearnerGroupMember\n              ON ChangeLog.chTableId = 300\n                 AND ChangeLog.chEntityPk = LearnerGroupMember.learnerGroupMemberUid\n         JOIN Person\n              ON Person.personUid = LearnerGroupMember.learnerGroupMemberPersonUid\n         \n            JOIN ScopedGrant \n                   ON \n            ((ScopedGrant.sgTableId = -2\n                    AND ScopedGrant.sgEntityUid = -2)\n                 OR (ScopedGrant.sgTableId = 9\n                    AND ScopedGrant.sgEntityUid = Person.personUid)\n                 OR (ScopedGrant.sgTableId = 6       \n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT clazzEnrolmentClazzUid\n                          FROM ClazzEnrolment\n                         WHERE clazzEnrolmentPersonUid = Person.personUid \n                           AND ClazzEnrolment.clazzEnrolmentActive))\n                 OR (ScopedGrant.sgTableId = 164\n                    AND ScopedGrant.sgEntityUid IN (\n                        SELECT DISTINCT schoolMemberSchoolUid\n                          FROM SchoolMember\n                         WHERE schoolMemberPersonUid = Person.personUid\n                           AND schoolMemberActive))\n                           )\n        \n                   AND (ScopedGrant.sgPermissions & \n        \n              64\n              \n                                                     ) > 0\n             JOIN PersonGroupMember AS PrsGrpMbr\n                   ON ScopedGrant.sgGroupUid = PrsGrpMbr.groupMemberGroupUid\n              JOIN UserSession\n                   ON UserSession.usPersonUid = PrsGrpMbr.groupMemberPersonUid\n                      AND UserSession.usStatus = 1\n        \n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId\n           FROM SyncNode\n          LIMIT 1)\n     AND LearnerGroupMember.learnerGroupMemberLct != COALESCE(\n         (SELECT lgmVersionId\n            FROM LearnerGroupMemberReplicate\n           WHERE lgmPk = LearnerGroupMember.learnerGroupMemberUid\n             AND lgmDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(lgmPk, lgmDestination) DO UPDATE\n     SET lgmPending = true\n  */\n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.LearnerGroupMember.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.LearnerGroupMember.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT LearnerGroupMember.*, Person.* FROM LearnerGroupMember \n        LEFT JOIN Person ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid \n        LEFT JOIN GroupLearningSession ON \n    GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroupMember.learnerGroupMemberLgUid \n    WHERE GroupLearningSession.groupLearningSessionLearnerGroupUid = :learnerGroupUid \n    AND GroupLearningSession.groupLearningSessionContentUid = :contentEntryUid \n    ORDER BY learnerGroupMemberRole ASC\n    ")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.LearnerGroupMemberWithPerson> findLearnerGroupMembersByGroupIdAndEntry(long learnerGroupUid, long contentEntryUid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT LearnerGroupMember.*, Person.* FROM LearnerGroupMember \n        LEFT JOIN Person ON LearnerGroupMember.learnerGroupMemberPersonUid = Person.personUid \n        LEFT JOIN GroupLearningSession ON \n    GroupLearningSession.groupLearningSessionLearnerGroupUid = LearnerGroupMember.learnerGroupMemberLgUid \n    WHERE GroupLearningSession.groupLearningSessionLearnerGroupUid = :learnerGroupUid \n    AND GroupLearningSession.groupLearningSessionContentUid = :contentEntryUid \n    ORDER BY learnerGroupMemberRole ASC\n    ")
    public abstract java.lang.Object findLearnerGroupMembersByGroupIdAndEntryList(long learnerGroupUid, long contentEntryUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.LearnerGroupMemberWithPerson>> continuation);
}