package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@com.ustadmobile.door.annotation.Repository()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005H\'J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\'J\u001b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ%\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\'J%\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0011\u0010\u0019\u001a\u00020\u0015H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u001a\u001a\u00020\u00152\b\b\u0001\u0010\u001b\u001a\u00020\u000bH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2 = {"Lcom/ustadmobile/core/db/dao/LeavingReasonDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/LeavingReason;", "()V", "findAllReasons", "Lcom/ustadmobile/door/DoorDataSourceFactory;", "", "findAllReasonsLive", "", "findByUidAsync", "uid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidList", "uidList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUidLive", "Lcom/ustadmobile/door/DoorLiveData;", "getReasonsFromUids", "Lcom/ustadmobile/lib/db/entities/UidAndLabel;", "initPreloadedLeavingReasons", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replaceList", "entityList", "replicateOnChange", "replicateOnNewNode", "newNodeId", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/LeavingReason;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class LeavingReasonDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.LeavingReason> {
    
    public LeavingReasonDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n         REPLACE INTO LeavingReasonReplicate(lrPk, lrDestination)\n          SELECT DISTINCT LeavingReason.leavingReasonUid AS lrPk,\n                 :newNodeId AS lrDestination\n            FROM LeavingReason\n           WHERE LeavingReason.leavingReasonLct != COALESCE(\n                 (SELECT lrVersionId\n                    FROM LeavingReasonReplicate\n                   WHERE lrPk = LeavingReason.leavingReasonUid\n                     AND lrDestination = :newNodeId), 0) \n          /*psql ON CONFLICT(lrPk, lrDestination) DO UPDATE\n                 SET lrPending = true\n          */       \n     ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.LeavingReason.class})
    public abstract java.lang.Object replicateOnNewNode(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n REPLACE INTO LeavingReasonReplicate(lrPk, lrDestination)\n  SELECT DISTINCT LeavingReason.leavingReasonUid AS lrUid,\n         UserSession.usClientNodeId AS lrDestination\n    FROM ChangeLog\n         JOIN LeavingReason\n              ON ChangeLog.chTableId = 410\n                 AND ChangeLog.chEntityPk = LeavingReason.leavingReasonUid\n         JOIN UserSession \n              ON UserSession.usStatus = 1\n   WHERE UserSession.usClientNodeId != (\n         SELECT nodeClientId \n           FROM SyncNode\n          LIMIT 1)\n     AND LeavingReason.leavingReasonLct != COALESCE(\n         (SELECT lrVersionId\n            FROM LeavingReasonReplicate\n           WHERE lrPk = LeavingReason.leavingReasonUid\n             AND lrDestination = UserSession.usClientNodeId), 0)\n /*psql ON CONFLICT(lrPk, lrDestination) DO UPDATE\n     SET lrPending = true\n  */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.LeavingReason.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.LeavingReason.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM LeavingReason")
    public abstract com.ustadmobile.door.DoorDataSourceFactory<java.lang.Integer, com.ustadmobile.lib.db.entities.LeavingReason> findAllReasons();
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM LeavingReason")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.LeavingReason> findAllReasonsLive();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM LeavingReason WHERE leavingReasonUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.LeavingReason> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT leavingReasonUid FROM LeavingReason WHERE leavingReasonUid IN (:uidList)")
    public abstract java.lang.Object findByUidList(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<java.lang.Long>> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM LeavingReason WHERE leavingReasonUid = :uid")
    public abstract com.ustadmobile.door.DoorLiveData<com.ustadmobile.lib.db.entities.LeavingReason> findByUidLive(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT LeavingReason.leavingReasonUid AS uid, \n            LeavingReason.leavingReasonTitle As labelName  \n            FROM LeavingReason WHERE leavingReasonUid IN (:uidList)")
    public abstract java.lang.Object getReasonsFromUids(@org.jetbrains.annotations.NotNull()
    java.util.List<java.lang.Long> uidList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.util.List<com.ustadmobile.lib.db.entities.UidAndLabel>> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Object replaceList(@org.jetbrains.annotations.NotNull()
    java.util.List<com.ustadmobile.lib.db.entities.LeavingReason> entityList, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.LeavingReason entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    public final java.lang.Object initPreloadedLeavingReasons(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
}