package com.ustadmobile.core.db.dao;

import java.lang.System;

@com.ustadmobile.door.annotation.Repository()
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u00020\u00052\b\b\u0001\u0010\b\u001a\u00020\tH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2 = {"Lcom/ustadmobile/core/db/dao/MessageReadDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/MessageRead;", "()V", "replicateOnChange", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replicateOnNewNodeChats", "newNodeId", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "lib-database"})
public abstract class MessageReadDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.MessageRead> {
    
    public MessageReadDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.ReplicationRunOnNewNode()
    @androidx.room.Query(value = "\n     REPLACE INTO MessageReadReplicate(messageReadPk, messageReadDestination)\n      SELECT DISTINCT MessageRead.messageReadUid AS messageReadPk,\n             :newNodeId AS messageReadDestination\n        FROM UserSession \n              JOIN Message ON\n                  ((    Message.messageTableId = 127\n                    AND Message.messageEntityUid IN\n                        (SELECT ChatMember.chatMemberChatUid \n                          FROM ChatMember\n                         WHERE ChatMember.chatMemberPersonUid = UserSession.usPersonUid))\n                  OR UserSession.usSessionType = 2)\n                  \n              JOIN MessageRead \n                   ON MessageRead.messageReadMessageUid = Message.messageUid\n                   \n       WHERE UserSession.usClientNodeId = :newNodeId\n         AND UserSession.usStatus = 1\n         AND MessageRead.messageReadLct != COALESCE(\n             (SELECT messageReadVersionId\n                FROM MessageReadReplicate\n               WHERE messageReadPk = MessageRead.messageReadUid\n                 AND messageReadDestination = :newNodeId), 0) \n      /*psql ON CONFLICT(messageReadPk, messageReadDestination) DO UPDATE\n             SET messageReadPending = true\n      */       \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.MessageRead.class})
    public abstract java.lang.Object replicateOnNewNodeChats(@com.ustadmobile.door.annotation.NewNodeIdParam()
    long newNodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "\n         REPLACE INTO MessageReadReplicate(messageReadPk, messageReadDestination)\n          SELECT DISTINCT MessageRead.messageReadUid AS messageReadUid,\n                 UserSession.usClientNodeId AS messageReadDestination\n            FROM ChangeLog\n            \n                 JOIN MessageRead \n                      ON MessageRead.messageReadUid = ChangeLog.chEntityPk\n                         AND ChangeLog.chTableId = 129\n                         \n\n                 JOIN UserSession ON\n                      ((UserSession.usPersonUid IN \n                           (SELECT ChatMember.chatMemberPersonUid\n                              FROM ChatMember\n                             WHERE ChatMember.chatMemberChatUid = MessageRead.messageReadEntityUid))\n                       OR UserSession.usSessionType = 2)\n                   \n           WHERE UserSession.usStatus = 1\n             AND UserSession.usClientNodeId != (\n                 SELECT nodeClientId \n                   FROM SyncNode\n                  LIMIT 1)\n             AND MessageRead.messageReadLct != COALESCE(\n                 (SELECT messageReadVersionId\n                    FROM MessageReadReplicate\n                   WHERE messageReadPk = MessageRead.messageReadUid\n                     AND messageReadDestination = UserSession.usClientNodeId), 0)\n         /*psql ON CONFLICT(messageReadPk, messageReadDestination) DO UPDATE\n             SET messageReadPending = true\n          */               \n    ")
    @com.ustadmobile.door.annotation.ReplicationCheckPendingNotificationsFor(value = {com.ustadmobile.lib.db.entities.MessageRead.class})
    @com.ustadmobile.door.annotation.ReplicationRunOnChange(value = {com.ustadmobile.lib.db.entities.MessageRead.class})
    public abstract java.lang.Object replicateOnChange(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
}