package com.ustadmobile.core.db.dao;

import java.lang.System;

/**
 * Created by mike on 1/30/18.
 */
@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0005\b\'\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\'J\u0011\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\'J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\'J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\'J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bH\'J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u000eH\'J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u000bH\'J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\'J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u000bH\'J\u0019\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0005H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ!\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\'\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0005H\'J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0005H\'J!\u0010&\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\'\u001a\u00020\u000eH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J \u0010)\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000bH\'J%\u0010,\u001a\u00020\u00072\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0.H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u0019\u00100\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000eH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00063"}, d2 = {"Lcom/ustadmobile/core/db/dao/NetworkNodeDao;", "", "()V", "all", "", "Lcom/ustadmobile/lib/db/entities/NetworkNode;", "deleteAllAsync", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteByBluetoothAddress", "bluetoothAddress", "", "deleteOldAndBadNode", "minLastSeenTimestamp", "", "maxFailuresInPeriod", "", "findAllActiveNodes", "lastUpdatedTime", "maxNumFailure", "findNodeByBluetoothAddress", "findNodeById", "nodeId", "findNodeByIpAddress", "ipAddress", "findNodeByIpOrWifiDirectMacAddress", "wifiDirectMacAddress", "getEndpointUrlByGroupSsid", "ssid", "insertAsync", "node", "(Lcom/ustadmobile/lib/db/entities/NetworkNode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "insertList", "", "nodeList", "(Ljava/util/List;)[Ljava/lang/Long;", "replace", "update", "updateLastSeenAsync", "lastUpdateTimeStamp", "(Ljava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateNetworkNodeGroupSsid", "groupSsid", "endpointUrl", "updateNodeLastSeen", "knownNodes", "", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateRetryCountAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib-database"})
public abstract class NetworkNodeDao {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.NetworkNodeDao.Companion Companion = null;
    @org.jetbrains.annotations.NotNull()
    public static final java.lang.String findByBluetoothAddrSql = "SELECT * from NetworkNode WHERE bluetoothMacAddress = :bluetoothAddress";
    
    public NetworkNodeDao() {
        super();
    }
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "SELECT * FROM NetworkNode")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.NetworkNode> all();
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * From NetworkNode WHERE ipAddress = :ipAddress")
    public abstract com.ustadmobile.lib.db.entities.NetworkNode findNodeByIpAddress(@org.jetbrains.annotations.NotNull()
    java.lang.String ipAddress);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * From NetworkNode WHERE nodeId = :nodeId")
    public abstract com.ustadmobile.lib.db.entities.NetworkNode findNodeById(long nodeId);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "Select * From NetworkNode Where ((ipAddress = :ipAddress AND ipAddress IS NOT NULL) OR (wifiDirectMacAddress = :wifiDirectMacAddress AND wifiDirectMacAddress IS NOT NULL))")
    public abstract com.ustadmobile.lib.db.entities.NetworkNode findNodeByIpOrWifiDirectMacAddress(@org.jetbrains.annotations.NotNull()
    java.lang.String ipAddress, @org.jetbrains.annotations.NotNull()
    java.lang.String wifiDirectMacAddress);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * from NetworkNode WHERE bluetoothMacAddress = :bluetoothAddress")
    public abstract com.ustadmobile.lib.db.entities.NetworkNode findNodeByBluetoothAddress(@org.jetbrains.annotations.NotNull()
    java.lang.String bluetoothAddress);
    
    @androidx.room.Insert(onConflict = 1)
    public abstract long replace(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.NetworkNode node);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Object insertAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.NetworkNode node, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Long> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Insert(onConflict = 1)
    public abstract java.lang.Long[] insertList(@org.jetbrains.annotations.NotNull()
    java.util.List<? extends com.ustadmobile.lib.db.entities.NetworkNode> nodeList);
    
    @androidx.room.Update()
    public abstract void update(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.NetworkNode node);
    
    @androidx.room.Query(value = "DELETE FROM NetworkNode WHERE bluetoothMacAddress = :bluetoothAddress")
    public abstract void deleteByBluetoothAddress(@org.jetbrains.annotations.NotNull()
    java.lang.String bluetoothAddress);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "DELETE FROM NetworkNode")
    public abstract java.lang.Object deleteAllAsync(@org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "UPDATE NetworkNode SET numFailureCount = numFailureCount + 1 WHERE nodeId = :nodeId")
    public abstract java.lang.Object updateRetryCountAsync(long nodeId, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation);
    
    @org.jetbrains.annotations.NotNull()
    @androidx.room.Query(value = "Select * From NetworkNode WHERE lastUpdateTimeStamp >= :lastUpdatedTime AND numFailureCount <= :maxNumFailure")
    public abstract java.util.List<com.ustadmobile.lib.db.entities.NetworkNode> findAllActiveNodes(long lastUpdatedTime, int maxNumFailure);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "UPDATE NetworkNode set lastUpdateTimeStamp = :lastUpdateTimeStamp, numFailureCount = 0 WHERE bluetoothMacAddress = :bluetoothAddress")
    public abstract java.lang.Object updateLastSeenAsync(@org.jetbrains.annotations.NotNull()
    java.lang.String bluetoothAddress, long lastUpdateTimeStamp, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @androidx.room.Query(value = "DELETE FROM NetworkNode WHERE NetworkNode.lastUpdateTimeStamp < :minLastSeenTimestamp OR NetworkNode.numFailureCount >= :maxFailuresInPeriod")
    public abstract void deleteOldAndBadNode(long minLastSeenTimestamp, int maxFailuresInPeriod);
    
    @androidx.room.Query(value = "UPDATE NetworkNode SET groupSsid = :groupSsid, endpointUrl = :endpointUrl  WHERE nodeId = :nodeId")
    public abstract void updateNetworkNodeGroupSsid(long nodeId, @org.jetbrains.annotations.NotNull()
    java.lang.String groupSsid, @org.jetbrains.annotations.NotNull()
    java.lang.String endpointUrl);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT endpointUrl FROM NetworkNode WHERE groupSsid = :ssid")
    public abstract java.lang.String getEndpointUrlByGroupSsid(@org.jetbrains.annotations.NotNull()
    java.lang.String ssid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Transaction()
    public java.lang.Object updateNodeLastSeen(@org.jetbrains.annotations.NotNull()
    java.util.Map<java.lang.String, java.lang.Long> knownNodes, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super kotlin.Unit> continuation) {
        return null;
    }
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2 = {"Lcom/ustadmobile/core/db/dao/NetworkNodeDao$Companion;", "", "()V", "findByBluetoothAddrSql", "", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
    }
}