package com.ustadmobile.core.db.dao;

import java.lang.System;

@androidx.room.Dao()
@kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\'\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0003J#\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tJ!\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\rH\'J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\rH\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\'J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\'J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\rH\'J!\u0010\u001c\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0084@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000fJ)\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\rH\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0019\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0002H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J!\u0010#\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u00a7@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonAuthDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/PersonAuth;", "()V", "authenticate", "Lcom/ustadmobile/lib/db/entities/UmAccount;", "username", "", "password", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "changePassword", "", "personUid", "", "passwordHash", "(JLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByUid", "uid", "findByUidAsync", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findPersonByUsername", "Lcom/ustadmobile/lib/db/entities/Person;", "insertAccessToken", "", "token", "Lcom/ustadmobile/lib/db/entities/AccessToken;", "isPersonAdmin", "", "onSuccessCreateAccessToken", "resetPassword", "loggedInPersonUid", "(JLjava/lang/String;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateAsync", "entity", "(Lcom/ustadmobile/lib/db/entities/PersonAuth;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updatePasswordForPersonUid", "Companion", "lib-database"})
public abstract class PersonAuthDao implements com.ustadmobile.core.db.dao.BaseDao<com.ustadmobile.lib.db.entities.PersonAuth> {
    @org.jetbrains.annotations.NotNull()
    public static final com.ustadmobile.core.db.dao.PersonAuthDao.Companion Companion = null;
    private static final int KEY_LENGTH = 512;
    private static final int ITERATIONS = 10000;
    private static final java.lang.String SALT = "fe10fe1010";
    @org.jetbrains.annotations.NotNull()
    private static final java.lang.String ENCRYPTED_PASS_PREFIX = "e:";
    @org.jetbrains.annotations.NotNull()
    private static final java.lang.String PLAIN_PASS_PREFIX = "p:";
    
    public PersonAuthDao() {
        super();
    }
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM PersonAuth WHERE personAuthUid = :uid")
    public abstract java.lang.Object findByUidAsync(long uid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.PersonAuth> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM PersonAuth WHERE personAuthUid = :uid")
    public abstract com.ustadmobile.lib.db.entities.PersonAuth findByUid(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "SELECT * FROM Person WHERE username = :username")
    public abstract com.ustadmobile.lib.db.entities.Person findPersonByUsername(@org.jetbrains.annotations.NotNull()
    java.lang.String username);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Update()
    public abstract java.lang.Object updateAsync(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.PersonAuth entity, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @androidx.room.Query(value = "SELECT admin from Person WHERE personUid = :uid")
    public abstract boolean isPersonAdmin(long uid);
    
    @org.jetbrains.annotations.Nullable()
    @androidx.room.Query(value = "UPDATE PersonAuth set passwordHash = :passwordHash  WHERE personAuthUid = :personUid")
    public abstract java.lang.Object updatePasswordForPersonUid(long personUid, @org.jetbrains.annotations.NotNull()
    java.lang.String passwordHash, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation);
    
    @org.jetbrains.annotations.Nullable()
    @com.ustadmobile.door.annotation.Repository(methodType = 2)
    public java.lang.Object resetPassword(long personUid, @org.jetbrains.annotations.NotNull()
    java.lang.String password, long loggedInPersonUid, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    public java.lang.Object changePassword(long personUid, @org.jetbrains.annotations.NotNull()
    java.lang.String passwordHash, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.Integer> continuation) {
        return null;
    }
    
    @androidx.room.Insert()
    public abstract void insertAccessToken(@org.jetbrains.annotations.NotNull()
    com.ustadmobile.lib.db.entities.AccessToken token);
    
    @org.jetbrains.annotations.Nullable()
    protected final java.lang.Object onSuccessCreateAccessToken(long personUid, @org.jetbrains.annotations.NotNull()
    java.lang.String username, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.UmAccount> continuation) {
        return null;
    }
    
    @org.jetbrains.annotations.Nullable()
    public final java.lang.Object authenticate(@org.jetbrains.annotations.NotNull()
    java.lang.String username, @org.jetbrains.annotations.NotNull()
    java.lang.String password, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super com.ustadmobile.lib.db.entities.UmAccount> continuation) {
        return null;
    }
    
    @kotlin.Metadata(mv = {1, 6, 0}, k = 1, d1 = {"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006R\u000e\u0010\f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2 = {"Lcom/ustadmobile/core/db/dao/PersonAuthDao$Companion;", "", "()V", "ENCRYPTED_PASS_PREFIX", "", "getENCRYPTED_PASS_PREFIX", "()Ljava/lang/String;", "ITERATIONS", "", "KEY_LENGTH", "PLAIN_PASS_PREFIX", "getPLAIN_PASS_PREFIX", "SALT", "authenticateThisEncryptedPassword", "", "providedPassword", "encryptedPassword", "encryptThisPassword", "originalPassword", "lib-database"})
    public static final class Companion {
        
        private Companion() {
            super();
        }
        
        @org.jetbrains.annotations.NotNull()
        public final java.lang.String getENCRYPTED_PASS_PREFIX() {
            return null;
        }
        
        @org.jetbrains.annotations.NotNull()
        public final java.lang.String getPLAIN_PASS_PREFIX() {
            return null;
        }
        
        @org.jetbrains.annotations.NotNull()
        public final java.lang.String encryptThisPassword(@org.jetbrains.annotations.NotNull()
        java.lang.String originalPassword) {
            return null;
        }
        
        public final boolean authenticateThisEncryptedPassword(@org.jetbrains.annotations.NotNull()
        java.lang.String providedPassword, @org.jetbrains.annotations.Nullable()
        java.lang.String encryptedPassword) {
            return false;
        }
    }
}